<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Query\Builder;
use Illuminate\Notifications\Notifiable;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class CurrentAcadmicStatus extends Model
{
    use HasFactory;

    protected $table = 'current_academic_status';


    /**
     * Mass fillable fields
     *
     * @var array
     */
    protected $fillable = [
        'student_id'
    ];

    /**
     * Relationship to `classes` table
     *
     * @return mixed
     */
    public function class()
    {
        return $this->belongsTo(Classes::class, 'class_id', 'id');
    }

    /**
     * Relationship to `sections` table
     *
     * @return mixed
     */
    public function section()
    {
        return $this->belongsTo(Sections::class, 'section_id', 'id');
    }

    /**
     * Relationship to `sessions` table
     *
     * @return mixed
     */
    public function session()
    {
        return $this->belongsTo(Sessions::class, 'session_id', 'id');
    }

    /**
     * Relationship to `group` table
     *
     * @return mixed
     */
    public function group()
    {
        return $this->belongsTo(Groups::class, 'group_id', 'id');
    }

    /**
     * Relationship to `students` table
     *
     * @return mixed
     */
    public function student_details()
    {
        return $this->hasOne(Student::class, 'id', 'student_id');
    }

     /**
     * Relationship to `marksBySubject` table
     *
     * @return mixed
     */
    public function MarksBySubject(){
        return $this->hasOne(Marks::class, 'student_id', 'student_id')->with('subject');
    }


       /**
     * Relationship to `marks` table
     *
     * @return mixed
     */
    public function MarksDetails(){
        return $this->hasMany(Marks::class, 'student_id', 'student_id')->with('subject');
    }



     /**
     * Relationship to `marks` table
     *
     * @return mixed
     */
    public function FeeDetails(){
        return $this->hasMany(StudentFee::class, 'student_id', 'student_id');
    }


    public static function getStudents($arr,$arr_student_ids,$is_required_marks){
        $exam_id = $arr['exam_id'];
        $session_id = $arr['session_id'];
        $class_id = $arr['class_id'];
        $section_id = isset($arr['section_id']) ? $arr['section_id'] : '';

        $students = CurrentAcadmicStatus::with('student_details')
        ->with('class')
        ->with('section')
        ->with('session')
        ->with('group')
        ->where('class_id', $class_id)
        ->where('session_id',$session_id);
        if($is_required_marks==true){
            $students->with([
                'MarksDetails' => function ($query) use ($exam_id, $class_id, $session_id) {
                    $query->where('exam_id', $exam_id);
                    $query->where('class_id', $class_id);
                    $query->where('session_id', $session_id);
                }
            ]);
        }
        if($section_id){
            $students->where('section_id',$section_id);
        }
        if(!empty($arr_student_ids)){
            $students->whereIn('student_id',$arr_student_ids);
        }

        return $students->get();


    }



}
