<?php

namespace App\Jobs;

use App\Models\Product;
use App\Models\WooShop;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Http;

class InventoryQtySync implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    private $product;

    /**
     * Create a new job instance.
     *
     * @param Product $product
     */
    public function __construct(Product $product)
    {
        $this->product = $product;
    }

    /**
     * @var $product string WooCommerce product collection
     * Triggers only when stock is adjusted
     * @return void
     */
    public function handle()
    {
        $products = Product::where('id', $this->product->id)->get();
        $quantity = $this->product->getQuantity->quantity;

        foreach ($products as $product):
            if($quantity != $product->quantity):
                $product->quantity = $quantity;
                $product->update();
            endif;
        endforeach;
    }
}
