<?php

namespace App\Http\Requests\Stock;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Request;

class StockUpdateRequest extends FormRequest
{
    private $productId = 0;

    /**
     * Create new instance
     *
     * @param Request $request
     * @return void
     */
    public function __construct(Request $request)
    {
        $this->productId = $request->id;
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

 /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [           
            'stock_type' => [
                'required'
            ],
            'quantity.* ' => [
                'required',
                'integer',
                'min:1'
            ],
            'product_id.* ' => [
                'required',
                'integer',
                'min:1'
            ],
        ];
    }

    /**
     * Get the validation fields name
     *
     * @return array
     */
    public function attributes()
    {
        return [
            'product_id' => __('translation.Product Name'), 
            'unit_id' => __('translation.Unit Name'), 
            'stock_type' => __('translation.Stock Type'), 
            'product_qty.*' => __('translation.Quantity')
        ];
    }
}
