<?php

namespace App\Http\Requests\Product;

use App\Models\Product;
use Illuminate\Foundation\Http\FormRequest;

class ProductStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'product_name' => [
                'required',
                'max:255'
            ],            
            'price' => [
                'required',
                'integer',
                
            ],
        ];
    }

    /**
     * Get the validation fields name
     *
     * @return array
     */
    public function attributes()
    {
        return [
            'product_name' => __('translation.Part Name'), 
            'product_code' => __('translation.Product Code'), 
            'price' => __('translation.Price')
        ];
    }
}
