<?php

namespace App\Http\Requests\Payment;

use Illuminate\Foundation\Http\FormRequest;

class PaymentStoreRequest extends FormRequest
{


    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {

        $arr['payment_date'] = array('required');
        //$arr['shop_id'] = array('required');
        if($this->request->get('type')=='supplier') $arr['supplier_id'] = array('required');
        if($this->request->get('type')=='withdraw') $arr['bank_or_mobile_wallet_id'] = array('required');
        if($this->request->get('type')=='loan') $arr['lender_id'] = array('required');
        if($this->request->get('type')=='bank-loan') $arr['bank_or_mobile_wallet_id'] = array('required');
        if($this->request->get('type')=='salary') $arr['employee_id'] = array('required');
        $arr['payment_method_id'] = array('required');
        $arr['paid'] = array('required','numeric','min:0');

        return $arr;
    }


    /**
     * Get the attributes name
     *
     * @return array
     */
    public function attributes()
    {


        return [
            'payment_date' => 'Payment Date',
            'shop_id' => 'Shop',
            'supplier_id' => 'Supplier Name',
            'employee_id' => 'Employee Name',
            'bank_or_mobile_wallet_id' => 'Bank Name',
            'lender_id' => 'Lender Name',
            'payment_method_id' => 'Payment Method',     
            'paid' => 'Paid Amount',
        ];
    }


}