<?php

namespace App\Http\Requests\OrderPurchase;

use App\Models\OrderPurchase;
use Illuminate\Foundation\Http\FormRequest;

class UpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

       /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'supplier_id' => [
                'required'
            ],
            'order_date' => [
                'required',
                'date_format:d-m-Y'
            ],
           /* 'ship_date' => [
                'nullable',
                'date_format:d-m-Y'
            ],
            'e_a_d_f' => [
                'nullable',
                'date_format:d-m-Y'
            ],
            'e_a_d_t' => [
                'nullable',
                'date_format:d-m-Y'
            ],
            */
            // 'check' => [
            //     'required',
            //     'in:' . OrderPurchase::SUPPLY_FROM_IMPORT . ',' . OrderPurchase::SUPPLY_FROM_DOMESTIC
            // ],
           
            'product_code' => [
                'required',
                'array'
            ],
            'product_code.*' => [
                'required',
                'min:1'
            ],
            'quantity' => [
                'required',
                'array'
            ],
            'quantity.*' => [
                'required',
                'min:1'
            ],
            'cost_price' => [
                'required',
                'array'
            ],
            'cost_price.*' => [
                'required',
                'min:1'
            ]
        ];
    }

    
    /**
     * Get the attributes name
     *
     * @return array
     */
    public function attributes()
    {
        return [
            'supplier_id' => 'Supplier Name',
            'order_date' => 'Order Date',
            'quantity' => 'Quantity',
            'cost_price' => 'Cost Price',
            'product_code.*' => 'Products',
        ];
    }
}

