<?php

namespace App\Http\Requests\MyBanking;

use Illuminate\Foundation\Http\FormRequest;

class StoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'type' => [
                'required'
            ],
            'payment_method_id' => [
                'required'
            ],
            'amount' => [
                'required',
                'numeric',
                'min:0'
            ],
         ];
    }


    /**
     * Get the attributes name
     *
     * @return array
     */
    public function attributes()
    {
        return [
            'client_id' => 'Customer Name',
            'paid' => 'Paid Amount',
        ];
    }
}
