<?php

namespace App\Http\Requests\Expenses;

use Illuminate\Foundation\Http\FormRequest;

class ExpenseStoreRequest extends FormRequest
{


    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {

        return [
            'entry_date' => 'required',
            'expense_name' => 'required|array',
            //'expense_name.*' => 'required|string|max:255', // Adjust rules as needed
        ];
    }


    /**
     * Get the attributes name
     *
     * @return array
     */
    public function attributes()
    {


        return [
            'entry_date' => 'Entry Date',
            'amount' => 'Amount',
        ];
    }


}