<?php

namespace App\Http\Requests\DailyProductionCost;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Request;

class DailyProductionCostUpdateRequest extends FormRequest
{
    private $productId = 0;

    /**
     * Create new instance
     *
     * @param Request $request
     * @return void
     */
    public function __construct(Request $request)
    {
        $this->productId = $request->id;
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

  /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'production_date' => [
                'required',
            ],  
            'shop_id' => [
                'required',
                'integer'
            ],


             'quantity' => [
                'required',
                'min:1'
            ],      
           
            'quantity.*' => [
                'required',
                'min:1'
            ],

            'raw_material_id' => [
                'required',
                'min:1'
            ],

            'product_id' => [
                'required',
            ],
        ];
    }

    /**
     * Get the validation fields name
     *
     * @return array
     */
    public function attributes()
    {
        return [
            'stock_date' => __('translation.Date'), 
            'raw_material_id' => __('translation.Raw Material Name'), 
            'shop_id' => __('translation.Unit Name'),
            'product_qty.*' => __('translation.Quantity'),
            'product_id' => __('translation.Product')
        ];
    }
}
