<?php

namespace App\Http\Controllers;

use App\Http\Resources\ProductTypeAheadResource;
use App\Models\Student;
use App\Models\Classes;
use App\Models\Sections;
use App\Models\Groups;
use App\Models\Sessions;
use App\Models\Subjects;
use App\Models\MarkTypes;
use App\Models\Marks;
use App\Models\MarksEntryForm;
use App\Models\CurrentAcadmicStatus;
use App\Models\DailyExpenses;
use App\Models\FeeTypes;
use App\Models\StudentFee;
use App\Models\Upazilla;
use App\Models\Json;
use App\Models\OthersCollections;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Datatables;
use DB;
use PDF;

class VoterController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {


        $arr_param['personId'] = Auth::user()->id;
        Session::put('itemArray', []);
        return view('voters.index');
    }


    /**
     * Handle datatable serverside
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function data_voter_list(Request $request)
    {
        if ($request->ajax()) {
            $classId = $request->get('classId', '');
            $sectionId = $request->get('sectionId', array());
            $sessionId = $request->get('sessionId', '');
            $status = $request->get('status', 0);
            Session::put('sessionStatusDueOrPaid',$status);
            $offset = $request->get('start', 0);
            $limit = $request->get('length', 10);
            if ($limit < 1 OR $limit > 100) {
                $limit = 100;
            }

            $search = isset($request->get('search')['value'])
                    ? $request->get('search')['value']
                    : null;

            $orderColumnList = [
                'roll_no',
                'id',
                 '',
                'name',
                'roll_name',
                'section_name'
            ];

            $orderColumnIndex = isset($request->get('order')[0]['column'])
                                ? $request->get('order')[0]['column']
                                : 0;
            $orderColumnDir = isset($request->get('order')[0]['dir'])
                                ? $request->get('order')[0]['dir']
                                : 'desc';

            $orderColumn = isset($orderColumnList[$orderColumnIndex])
                            ? $orderColumnList[$orderColumnIndex]
                            : 'name';



            $students = Student::orderBy('ward_no', 'ASC')->get();



            $table = Datatables::of($students)

            ->addColumn('voter_name', function ($row) {
                if(!empty($row->voter_type) && !empty($row->fathers_name) && $row->voter_type =='fathers_name'){
                    return $row->fathers_name;
                }elseif(!empty($row->voter_type) && !empty($row->mothers_name) && $row->voter_type =='mothers_name'){
                    return $row->mothers_name;
                }else{
                    return $row->legal_guardians_name;
                }
            })

             ->addColumn('student_details', function ($row) {
                return $row->name;
              })

            ->addColumn('current_address', function ($row) {
                if(empty($row->current_address)){
                        return NULL;
                }
                $current_address = json_decode($row->current_address,true);
                $same_as_current = $row->same_as_current ? $row->same_as_current : NULL;

                $permanent_address = json_decode($row->permanent_address,true);

                if($same_as_current=='on'){
                    $village = $current_address['village'];
                    $post_code = $current_address['post_code'];
                    $upazila = $current_address['upazila'];
                    $district = $current_address['district'];
                }else{
                    $village = $permanent_address['village'];
                    $post_code = $permanent_address['post_code'];
                    $upazila = $permanent_address['upazila'];
                    $district = $permanent_address['district'];
                }
                $address = '
                <strong>Village : </strong>'.$village.',
                <strong>Post Code : </strong>'.$post_code.',
                <strong>Upazilla : </strong>'.$upazila.',
                <strong>District : </strong>'.$district
                ;

                return $address;


            })

            ->addColumn('ward_no', function ($row) {
                return $row->ward_no;

            })

            ->rawColumns(['student_details', 'current_address', 'ward_no'])
            ->skipPaging()
            ->make(true);

            return $table;
        }
    }



    public function VoterListPDFExport(Request $request)
    {


        $classId = $request->post('classId');
        $sectionId = $request->post('sectionId');
        $sessionId = $request->post('sessionId');
        $status = $request->post('status');
        Session::put('sessionStatusDueOrPaid',$status);
        $offset = $request->get('start', 0);
        $limit = $request->get('length', 10);
        if ($limit < 1 OR $limit > 100) {
            $limit = 100;
        }

        $search = isset($request->get('search')['value'])
                ? $request->get('search')['value']
                : null;

        $orderColumnList = [
            'roll_no',
            'id',
                '',
            'name',
            'roll_name',
            'section_name'
        ];

        $orderColumnIndex = isset($request->get('order')[0]['column'])
                            ? $request->get('order')[0]['column']
                            : 0;
        $orderColumnDir = isset($request->get('order')[0]['dir'])
                            ? $request->get('order')[0]['dir']
                            : 'desc';

        $orderColumn = isset($orderColumnList[$orderColumnIndex])
                        ? $orderColumnList[$orderColumnIndex]
                        : 'name';

        $otherReportParams = [
            'search' => $search,
            'limit' => $limit,
            'offset' => $offset,
            'order_column' => $orderColumn,
            'order_dir' => $orderColumnDir,
            'class_id' => $classId,
        ];

        $MonthArray = StudentFee:: MonthArray();
        $now = Carbon::now();
        $MonthArray = array_chunk($MonthArray, 6);
        $prevMonthArr = $MonthArray[0];


        $nextMonthArr = array();
        if(isset($MonthArray[1])){
            $nextMonthArr = $MonthArray[1];
        }

        $personId = Auth::user()->id;

        $studentWithFees = CurrentAcadmicStatus::with('student_details')
        ->with(['FeeDetails' => function ($query) use ($sessionId){
            $query->where('session_id',$sessionId);
            }])
            ->where('current_academic_status.class_id',$classId)
            ->where('current_academic_status.section_id',$sectionId)
            ->where('current_academic_status.session_id',$sessionId)
            ->with('session')
            ->with('class')
            ->with('section')
            ->get();



    $customPaper = array(0,0,60.00,50.80);

    $width= '600';
    $height = '1200';

    //dd($studentWithFees);

    if($status==1){
        $page_header = "Students Fee Paid List";
        $file_name = "Paid-List";
    }else{
        $page_header = "Students Fee Due List";
        $file_name = "Due-List";
    }
    $pdf = PDF::loadView('voters.generate-voter-list-pdf',compact('page_header','studentWithFees'))
    ->setOptions(['defaultFont' => 'Courier'])
    ->setOptions(['isHtml5ParserEnabled' => true, 'isRemoteEnabled' => true])
    ->setPaper('A3', 'portrait');//
    // ->setPaper(array(0,0,$width,$height));

        //         $paper_size = array(0,0,360,360);
        // $dompdf->set_paper($paper_size);

    if(!empty($studentWithFees)){
        $row = $studentWithFees[0];
        $class_name = $row->class->class_name;
        $section_name = $row->section->section_name;
        $session_name = $row->session->session_name;
        $file_name = $file_name.'-'.$class_name.'-'.$section_name.'-'.$session_name;
    }
    $time = strtotime("today");
    return $pdf->download($file_name.'.pdf');
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function transaction_report()
    {
        $arr_param['personId'] = Auth::user()->id;
        Session::put('itemArray', []);

        $data = [
            'classes' => Classes::get(),
            'sections' => Sections::get(),
            'sessions' => Sessions::orderBy('id', 'DESC')->get(),
            'MonthArray' => StudentFee:: MonthArray()
        ];

        return view('reports.transaction.index', $data);
    }


    /**
     * Handle datatable serverside
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */


    public function data_transaction_list(Request $request)
    {
        if ($request->ajax()) {
            $now = Carbon::now()->format('m');
            $start_date = $request->get('start_date', $now);
            $end_date = $request->get('end_date', $now);
            $transaction_type = $request->get('transaction_type', '');
            Session::put('sessionTransactionType',$transaction_type);

            $studentFees = StudentFee::whereBetween('entry_date', [$start_date, $end_date])
                ->get();
            $othersCollections = OthersCollections::whereBetween('entry_date', [$start_date, $end_date])
                ->get();
            $dailyExpenses = DailyExpenses::whereBetween('entry_date', [$start_date, $end_date])
                ->get();

            foreach($studentFees as $row){
                $arr[$row->payment_method][] = $row->amount;
            }

            foreach($othersCollections as $row){
                $arr[$row->payment_method][] = $row->amount;
            }

            foreach($dailyExpenses as $row){
                $arr[$row->payment_method][] = $row->amount;
            }


            foreach($arr as $key=>$row){
                if(!empty($key)){
                    $objPM[$key]['key'] = $key;
                    $objPM[$key]['value'] = array_sum($row);
                }

            }
            // dd($objPM);
            $table = Datatables::of($objPM)

             ->addColumn('details', function ($row) {
                $payment_method = "Total ".ucwords(str_replace('_', ' ', $row['key']));
                 return $payment_method;
              })

           ->addColumn('amount', function ($row) {
            return $row['value'];
           })
           ->addColumn('details_with_arithmetic_sign', function ($row) {

            if($row['key']=='cash') {
                return $row['value'];
            }else{
                return "-".$row['value'];
            }
          })
           ->rawColumns(['details','amount'])
            ->skipPaging()
            ->make(true);

            return $table;
        }
    }



    /**
     * Handle datatable serverside
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function data_student_fee_list(Request $request)
    {
        if ($request->ajax()) {
            $now = Carbon::now()->format('m');
            $start_date = $request->get('start_date', $now);
            $end_date = $request->get('end_date', $now);
            $transaction_type = $request->get('transaction_type', '');
            Session::put('sessionTransactionType',$transaction_type);

            $studentFees = StudentFee::whereBetween('entry_date', [$start_date, $end_date])
                ->get();

            $table = Datatables::of($studentFees)

             ->addColumn('entry_date', function ($row) {
                 return $row->entry_date;
              })

            ->addColumn('id', function ($row) {
                return '
                <span class="dont-break-out cursor-pointer hover:text-blue-500">
                '. $row->id .'
                </span>
                ';
            })

            ->addColumn('payment_method', function ($row) {
                $payment_method = ucwords(str_replace('_', ' ', $row->payment_method));
                return '
                <span class="dont-break-out cursor-pointer hover:text-blue-500">
                '. $payment_method .'
                </span>
                ';
            })

            ->addColumn('entry_date', function ($row) {
                return $row->entry_date;
             })

             ->addColumn('id', function ($row) {
               return '
               <span class="dont-break-out cursor-pointer hover:text-blue-500">
               '. $row->id .'
               </span>
               ';
           })

           ->addColumn('payment_method', function ($row) {
                $payment_method = ucwords(str_replace("_"," ",$row->payment_method));
               return '
               <span class="dont-break-out cursor-pointer hover:text-blue-500">
               '. $payment_method .'
               </span>
               ';
           })

           ->addColumn('amount', function ($row) {
               return  $row->amount;
           })
           ->rawColumns(['id', 'entry_date', 'payment_method','amount'])
            ->skipPaging()
            ->make(true);

            return $table;
        }
    }


    /**
     * Handle datatable serverside
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function data_others_collection_list(Request $request)
    {
        if ($request->ajax()) {
            $now = Carbon::now()->format('m');
            $start_date = $request->get('start_date', $now);
            $end_date = $request->get('end_date', $now);
            $transaction_type = $request->get('transaction_type', '');
            Session::put('sessionTransactionType',$transaction_type);

            $othersCollections = OthersCollections::whereBetween('entry_date', [$start_date, $end_date])
                ->get();

            $table = Datatables::of($othersCollections)

             ->addColumn('entry_date', function ($row) {
                 return $row->entry_date;
              })

            ->addColumn('id', function ($row) {
                return '
                <span class="dont-break-out cursor-pointer hover:text-blue-500">
                '. $row->id .'
                </span>
                ';
            })

            ->addColumn('payment_method', function ($row) {
                $payment_method = ucwords(str_replace("_"," ",$row->payment_method));
               return '
               <span class="dont-break-out cursor-pointer hover:text-blue-500">
               '. $payment_method .'
               </span>
               ';
           })

            ->addColumn('amount', function ($row) {
                return  $row->amount;
            })
            ->rawColumns(['details', 'id', 'payment_method','amount'])
            ->skipPaging()
            ->make(true);

            return $table;
        }
    }

    /**
     * Handle datatable serverside
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function data_expense_list(Request $request)
    {
        if ($request->ajax()) {
            $now = Carbon::now()->format('m');
            $start_date = $request->get('start_date', $now);
            $end_date = $request->get('end_date', $now);
            $transaction_type = $request->get('transaction_type', '');
            Session::put('sessionTransactionType',$transaction_type);

            $dailyExpenses = DailyExpenses::whereBetween('entry_date', [$start_date, $end_date])
                ->get();

            $table = Datatables::of($dailyExpenses)

             ->addColumn('entry_date', function ($row) {
                 return $row->entry_date;
              })

              ->addColumn('id', function ($row) {
                return '
                <span class="dont-break-out cursor-pointer hover:text-blue-500">
                '. $row->id .'
                </span>
                ';
            })

            ->addColumn('payment_method', function ($row) {
                $payment_method = ucwords(str_replace("_"," ",$row->payment_method));
               return '
               <span class="dont-break-out cursor-pointer hover:text-blue-500">
               '. $payment_method .'
               </span>
               ';
           })

            ->addColumn('amount', function ($row) {
                return  $row->amount;
            })
            ->rawColumns(['id', 'entry_date', 'payment_method','amount'])
            ->skipPaging()
            ->make(true);

            return $table;
        }
    }

}
