<?php

namespace App\Http\Controllers;

use App\Models\ActivityLog;
use App\Http\Resources\RawMaterialTypeAheadResource;
use App\Models\Permission;
use App\Models\User;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use App\Http\Requests\User\{UserStoreRequest, UserUpdateRequest};
use App\Imports\BulkImport;
use App\Models\RawMaterial;
use App\Models\Ordeanagement;
use App\Models\ProductMainUser;
use App\Models\Shop;
use App\Models\Role;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Datatables;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Maatwebsite\Excel\Facades\Excel;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Str;

use App\Exports\OrderAnalysisExport;


class UserController extends Controller
{
    public function users()
    {

        $shop = Shop::where('id', Auth::user()->shop_id)->first();
        $userCount = User::count();
        $prouctionUnits = Shop::get();
        return view('seller.users.index', compact('shop', 'userCount','prouctionUnits'));
    }



    public function data(Request $request)
    {
        if ($request->ajax()){
            
            if (isset($request->id) && $request->id != null) {
               
                $user = User::findOrFail($request->id);
                $shop = Shop::where('id', Auth::user()->shop_id)->first();    
                $raw_materials =  User::get();;
                
                $data = [
                    'user' => $user,                 
                    'prouctionUnits' => Shop::get(),
                    'roles' => Role::get()
                ];
                return view('seller.users.form-edit-modal-user', $data);
            }

            $product_name = $request->get('product_name', '');
            $unitId = $request->get('unitId', '');
            $role = $request->get('role', '-1');


            $start = $request->get('start', 0);
            $limit = $request->get('length', 10);
            if ($limit < 1 OR $limit > 100) {
                $limit = 100;
            }

            $search = isset($request->get('search')['value'])
                    ? $request->get('search')['value']
                    : null;

            $orderColumnList = [
                'users.id',
                'shop_id',
                'quantity',
            ];

            $orderColumnIndex = isset($request->get('order')[0]['column'])
                                ? $request->get('order')[0]['column']
                                : 0;
            $orderColumnDir = isset($request->get('order')[0]['dir'])
                                ? $request->get('order')[0]['dir']
                                : 'desc';
            $orderColumnDir = 'desc';

            $orderColumn = $orderColumnList[$orderColumnIndex] ?? 'raw_material_id';

            $userRole = 'member';
            $userId = Auth::id();
            
            $data = User::searchTable($search)
                    ->filterByShop($unitId)
                    ->filterByRole($role)
                    ->orderBy($orderColumn, $orderColumnDir)
                    ->take($limit)
                    ->skip($start)
                    ->get();
            
            $totalData = User::searchTable($search)
                        ->filterByShop($unitId)
                        ->filterByRole($role)
                        ->count();
            //dd($data);

            $table = Datatables::of($data)
            
           
                ->addColumn('id', function ($row) {                  
                    return $row->id;
                })

                ->addColumn('created_at', function ($row) {
                    return $row->created_at->format('d-m-Y H:i');
                })
                ->addColumn('staff_role', function ($row) {
                    return ucwords($row->role);
                    
                })
                ->addColumn('shop_name', function ($row) {
                    $productionUnits = Shop::select('name')->whereIn('id', explode(",",$row->shop_id))->pluck('name')
                    ->implode(', ');
                    
                    return $productionUnits;  
                    
                })

                ->addColumn('actions', function ($row) {
                    $actionContent = '';
                    
                    $actionContent = '
                    <div class="w-full text-center">
                        <div class="flex flex-wrap items-center -m-1.5">
                            <div class="m-1.5">
                                <!-- Start -->
                                <button id="BtnEditProduct" data-id="'.$row->id.'" class="btn bg-white dark:bg-gray-800 border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600">
                                    <svg class="fill-current text-gray-400 dark:text-gray-500 shrink-0" width="16" height="16" viewBox="0 0 16 16">
                                        <path d="M11.7.3c-.4-.4-1-.4-1.4 0l-10 10c-.2.2-.3.4-.3.7v4c0 .6.4 1 1 1h4c.3 0 .5-.1.7-.3l10-10c.4-.4.4-1 0-1.4l-4-4zM4.6 14H2v-2.6l6-6L10.6 8l-6 6zM12 6.6L9.4 4 11 2.4 13.6 5 12 6.6z"></path>
                                    </svg>
                                </button>
                                <!-- End -->
                            </div>
                            <div class="m-1.5">
                                <!-- Start -->
                                <button id="BtnDeleteProduct" data-id="'.$row->id.'" class="btn bg-white dark:bg-gray-800 border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600">
                                    <svg class="fill-current text-red-500 shrink-0" width="16" height="16" viewBox="0 0 16 16">
                                        <path d="M5 7h2v6H5V7zm4 0h2v6H9V7zm3-6v2h4v2h-1v10c0 .6-.4 1-1 1H2c-.6 0-1-.4-1-1V5H0V3h4V1c0-.6.4-1 1-1h6c.6 0 1 .4 1 1zM6 2v1h4V2H6zm7 3H3v9h10V5z"></path>
                                    </svg>
                                </button>
                                <!-- End -->
                            </div>
                        </div>                       
                    </div>
                    ';
                   
                    return $actionContent;
                })
                ->rawColumns(['unit_details','product_name','status','actions'])
                ->skipPaging()
                ->setTotalRecords($totalData)
                ->make(true);

            return $table;
        }
    }



    function loadInsertForm(Request $request){
        $raw_materials =  User::get();
        $data = [
            'raw_materials' => RawMaterialTypeAheadResource::collection($raw_materials),
            'prouctionUnits' => Shop::get(),
            'roles' => Role::get(),
        ];
        return view('seller.users.form-insert-modal-user',$data);
    }

    /**
     * Store new user
     *
     * @param UserStoreRequest $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function insert(UserStoreRequest $request)
    {
        try {
            if(Session::has('user_log_data')){
                $user = Session::forget('user_log_data');
            }

          
            $isInsert = 0 ;        
            $users = new User();
             
            $users->name = $request->name;
            $users->email = $request->email;
            $users->phone = $request->phone;
            $users->password = Hash::make($request->password);
            $users->role = $request->role;
            $users->shop_id = implode(",",$request->shop_id);
            $users->seller_id = Auth::user()->id;
            $users->created_at = date('Y-m-d');  
            $users->is_active = 1;                  
            $users->save();

            ActivityLog::updateProductActivityLog('Create new user ', $users->id);
            $isInsert = 1 ;    
           
            
            if($isInsert){
                return response()->json([
                    'status' => 1,
                    'message' => '<span class="flex space-x-4 text-green-600">User created successfully</span>'
                ]);
            }

        } catch (\Throwable $th) {
            report($th);

            return redirect()->back()
                    ->with('error', $th->getMessage())
                    ->withInput();
        }
    }

    /**
     * Update the user data
     *
     * @param UserUpdateRequest $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function update(UserUpdateRequest $request)
    {
        try {
            if(Session::has('user_log_data')){
                Session::forget('user_log_data');
            }
                
            $isUpdate = 0 ; 
            $users = User::findOrFail($request->id);            
            $users->name = $request->name;
            $users->email = $request->email;
            $users->phone = $request->phone;
            $users->password = Hash::make($request->password);
            $users->role = $request->role;
            $users->shop_id = implode(",",$request->shop_id);
            $users->seller_id = Auth::user()->id;
            $users->created_at = date('Y-m-d');  
            $users->is_active = 1;        
            $users->save();
            ActivityLog::updateProductActivityLog('Update User ', $users->id);
            $isUpdate = 1 ;     
                
            
            if($isUpdate){
                return response()->json([
                    'status' => 1,
                    'message' => '<span class="flex space-x-4 text-green-600">User updated successfully</span>'
                ]);
            }
            else{
                return redirect()->back()->with('danger','Something happened wrong');
            }


        } catch (\Throwable $th) {
            report($th);
            return $this->apiResponse(500, "Something went wrong. {$th->getMessage()}");
        }
    }


    
    function loadDeleteForm(Request $request){

        $user = User::where('id',$request->id)->first();
       
        abort_if(!$user, 404);

        $data = [
            'user' => $user           
        ];

        return view('seller.users.form-delete-modal-user', $data);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete(Request $request){
        
        $validator = Validator::make($request->all(), [
            'id' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 0,
                'message' => '<span class="pt-5 px-5 flex space-x-4 text-red-500">Field id is required</span>'
            ]);
        } else {

            if(session::has('user_log_data')){
                session::forget('user_log_data');
            }

            User::where('id', '=', $request->id)->delete();

            ActivityLog::updateProductActivityLog('Delete user', $request->id);
                        
            return [
                'status' => 1,
                'message' => '<span class="pt-5 px-5 flex space-x-4 text-green-600">User is deleted successfully.</span>'
            ];
        }
    }

        /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function bulkDelete(Request $request){
        
        $validator = Validator::make($request->all(), [
            'bulk_ids' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 0,
                'message' => '<span class="pt-5 px-5 flex space-x-4 text-red-500">Field id is required</span>'
            ]);
        } else {

            if(session::has('user_log_data')){
                session::forget('user_log_data');
            }
            $isBulkDelete = false;
            $arrBulkIds = explode(",",$request->bulk_ids);
            foreach($arrBulkIds as $id){
                User::where('id', '=', $id)->delete();
                $isBulkDelete = true;
            }

            
            if($isBulkDelete){
                ActivityLog::updateProductActivityLog('Bulk Delete user',count($arrBulkIds));
            }
            
                        
            return [
                'status' => 1,
                'message' => '<span class="pt-5 px-5 flex space-x-4 text-green-600">User is deleted successfully.</span>'
            ];
        }
    }

    

}