<?php

namespace App\Http\Controllers;

use App\Http\Requests\Student\StoreRequest;
use App\Http\Requests\Student\UpdateRequest;
use App\Http\Resources\ProductTypeAheadResource;
use App\Models\Student;
use App\Models\Classes;
use App\Models\Sections;
use App\Models\Groups;
use App\Models\Sessions;
use App\Models\Subjects;
use App\Models\MarkTypes;
use App\Models\Marks;
use App\Models\MarksEntryForm;
use App\Models\CurrentAcadmicStatus;
use App\Models\FeeTypes;
use App\Models\FeeTypesAmount;
use App\Models\StudentFee;
use App\Models\Json;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Datatables;
use DB;
use PDF;
class StudentIdCardsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {


        $arr_param['personId'] = Auth::user()->id;
        Session::put('itemArray', []);



        $data = [
            'classes' => Classes::get(),
            'sections' => Sections::get(),
            'sessions' => Sessions::orderBy('id', 'DESC')->get()
        ];

        return view('student_id_cards.index', $data);
    }








     // Generate PDF
     public function pdfview(Request $request)
    {
        $personId = Auth::user()->id;

        $orderPurchase = '';

        abort_if(!$orderPurchase, 404, __('translation.Data not found'));

        $data = [
            'orderPurchase' => $orderPurchase,
            'shiptypes' => ShipType::all(),
            'cargos' => AgentCargoName::all(),
            'shipping_marks' => AgentCargoMark::all(),

        ];

        set_time_limit(300);
        $pdf = PDF::loadView('person.purchase_order.po_sheet',$data);
        return $pdf->download('person.purchase_order.po_sheet',$data);
        //return view('person.purchase_order.show');
    }



    /**
     * Handle datatable serverside
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function data(Request $request)
    {
        if ($request->ajax()) {
            $classId = $request->get('classId', '');
            $sectionId = $request->get('sectionId', array());
            $sessionId = $request->get('sessionId', '');

            $offset = $request->get('start', 0);
            $limit = $request->get('length', 10);
            if ($limit < 1 OR $limit > 100) {
                $limit = 100;
            }

            $search = isset($request->get('search')['value'])
                    ? $request->get('search')['value']
                    : null;

            $orderColumnList = [
                'roll_no',
                'id',
                 '',
                'name',
                'roll_name',
                'section_name'
            ];

            $orderColumnIndex = isset($request->get('order')[0]['column'])
                                ? $request->get('order')[0]['column']
                                : 0;
            $orderColumnDir = isset($request->get('order')[0]['dir'])
                                ? $request->get('order')[0]['dir']
                                : 'desc';

            $orderColumn = isset($orderColumnList[$orderColumnIndex])
                            ? $orderColumnList[$orderColumnIndex]
                            : 'name';

            $otherReportParams = [
                'search' => $search,
                'limit' => $limit,
                'offset' => $offset,
                'order_column' => $orderColumn,
                'order_dir' => $orderColumnDir,
                'class_id' => $classId,
            ];



            $studentWithMarks = CurrentAcadmicStatus::with('student_details')
                ->where('current_academic_status.class_id',$classId)
                ->where('current_academic_status.section_id',$sectionId)
                ->where('current_academic_status.session_id',$sessionId)
                ->with('session')
                ->with('class')
                ->with('section')
                ->get();


            $table = Datatables::of($studentWithMarks)

                    ->addColumn('name', function ($row) {
                        return $row->student_details->name;
                    })

                    ->addColumn('student_id', function ($row) {
                        return $row->student_details->student_code;
                    })

                    ->addColumn('roll_no', function ($row) {
                        return $row->roll_no;
                    })

                    ->rawColumns([])
                    ->skipPaging()
                    ->make(true);

                return $table;
        }
    }

}
