<?php

namespace App\Http\Controllers;

use App\Http\Requests\Staff\StoreRequest;
use App\Http\Requests\Staff\UpdateRequest;
use App\Models\Employee;
use App\Models\Staff;
use App\Models\Settings;
use App\Models\Json;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Response;
use Datatables;
use DB;
use PDF;
class StaffsController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $arr_param['userId'] = Auth::user()->id;
        Session::put('itemArray', []);

        return view('staffs.index');
    }

    /**
     * Handle datatable serverside
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function data(Request $request)
    {
        if ($request->ajax()) {
            $status = $request->get('status', '0');

            $offset = $request->get('start', 0);
            $limit = $request->get('length', 10);
            if ($limit < 1 OR $limit > 100) {
                $limit = 100;
            }

            $search = isset($request->get('search')['value'])
                    ? $request->get('search')['value']
                    : null;

            $orderColumnList = [
                'id',
                 '',
                'name',
                'mobile_no'
            ];

            $orderColumnIndex = isset($request->get('order')[0]['column'])
                                ? $request->get('order')[0]['column']
                                : 0;
            $orderColumnDir = isset($request->get('order')[0]['dir'])
                                ? $request->get('order')[0]['dir']
                                : 'desc';

            $orderColumn = isset($orderColumnList[$orderColumnIndex])
                            ? $orderColumnList[$orderColumnIndex]
                            : 'name';

            $otherReportParams = [
                'search' => $search,
                'limit' => $limit,
                'offset' => $offset,
                'order_column' => $orderColumn,
                'order_dir' => $orderColumnDir,
                'status' => $status
            ];

            if($status=='all'){
                $staffs = Employee::where('employee_type','staff')->get();
            }else{
                $staffs = Employee::where('status',$status)->where('employee_type','staff')->get();
            }


            $table = Datatables::of($staffs)

                ->addColumn('profile_photo', function ($row) {
                    if ($row->profile_photo) {
                        $profile_photo = asset('uploads/staffs/' . $row->profile_photo);
                    } else {
                        $profile_photo = '/No-Image-Found.png';
                    }

                    return '
                            <div class="flex flex-row gap-4" id="__productDiv_3934">
                                <div class="w-1/2 sm:w-full md:w-fulllg:w-full">
                                    <img src="' . $profile_photo . '" style="width:50px !important" class="w-full h-auto">
                                </div>
                            </div>
                            ';
                        })

                        ->addColumn('name', function ($row) {
                            return '
                            <div class="ml-3">
                            '. $row->name.
                            '</div>';
                        })

                        ->addColumn('code', function ($row) {
                            return $row->code ;
                          })


                         ->addColumn('mobile_no', function ($row) {
                            return $row->mobile_no ;
                         })

                         ->addColumn('blood_group', function ($row) {
                            return $row->blood_group ;
                         })



                        ->addColumn('action', function ($row) {
                            $action = '<div class="w-full text-center">';
                            $action .= '<a href="'.route('staffs.view', [ 'id' => $row->id ]) .'" class="btn-action--green" title="Detail">
                               <i class="fas fa-info"></i>
                           </a>';
                           $action .= '<a href="'.route('staffs.edit', [ 'id' => $row->id ]) .'" class="ml-1 btn-action--yellow" title="'. __('translation.Edit') .'">
                           <i class="fas fa-pencil-alt"></i>
                           </a>';
                            if (Auth::user()->role == 'member') {
                                $action .= '<button hidden type="button" class="btn-action--red" title="Delete" data-id="' . $row->id . '" id="BtnDelete">
                                    <i class="fas fa-trash-alt"></i>
                                </button>';
                            }
                           $action .= '</div>';

                           return $action;

                        })

                        ->rawColumns(['profile_photo', 'name', 'action'])
                        ->skipPaging()
                        ->make(true);

            return $table;
        }
    }




    /**
     * Page URL : .... staffs/{id}/edit
     * @return mixed
     */

    public function viewStaffInfo($id)
    {

        $staff = Employee::where('id', $id)
        ->first();
        dd($staff);

        return view(
            'staffs.view_and_print_staff_info',
            compact(
                [
                'staff',
                ]
            )
        );
    }



        /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        Session::put('itemArray', []);
        $userId = Auth::user()->id;

        //Generate a timestamp using mt_rand.
        $timestamp = mt_rand(1, time());
        $data = [
            'timestamp' => $timestamp,
            'all_divisions' => Json::getAllDivision(),
            'all_districts' => Json::getAllDistrict(),
            'all_postcodes' => Json::getAllPostCodes(),
            'all_upazilas' => Json::getAllUpazilas(),
        ];

        return view('staffs.create', $data);
    }



    /**
     * Store `staff` data
     *
     * @param  \App\Http\Requests\Staff\StoreRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreRequest $request)
    {


        try {

            $staff = new Employee();
            $staff->employee_type = 'staff' ;
            $staff->mobile_no = $request->mobile_no ? $request->mobile_no: NULL ;
            $staff->name = $request->name ? $request->name: NULL ;
            $staff->fathers_name = $request->fathers_name ? $request->fathers_name: NULL ;
            $staff->mothers_name = $request->mothers_name ? $request->mothers_name: NULL ;
            $staff->mobile_no = $request->mobile_no ? $request->mobile_no: NULL ;
            $staff->email = $request->email ? $request->email: NULL ;
            $staff->nid = $request->nid ? $request->nid : NULL ;

            $staff->dob = $request->dob ? date('Y-m-d', strtotime($request->dob)) : NULL ;
            $staff->nationality = $request->nationality ? $request->nationality: NULL ;
            $staff->religion = $request->religion ? $request->religion: NULL ;
            $staff->blood_group = $request->blood_group ? $request->blood_group: NULL ;
            $staff->gender = $request->gender ? $request->gender: NULL ;
            $staff->marital_status = $request->marital_status ? $request->marital_status: 0 ;


            $arr_current_address = array();
            $arr_current_address['village'] = $request->village ? $request->village: NULL ;
            $arr_current_address['post_code'] = $request->post_code ? $request->post_code: NULL ;
            $arr_current_address['upazila'] = $request->upazila ? $request->upazila: NULL ;
            $arr_current_address['district'] = $request->district ? $request->district: NULL ;

            $staff->current_address = json_encode($arr_current_address);
            $staff->same_as_current = $request->same_as_current ? $request->same_as_current: NULL ;

            $arr_permanent_address = array();
            $arr_permanent_address['village'] = $request->village_permanent ? $request->village_permanent: NULL ;
            $arr_permanent_address['post_code'] = $request->post_code_permanent ? $request->post_code_permanent: NULL ;
            $arr_permanent_address['upazila'] = $request->upazila_permanent ? $request->upazila_permanent: NULL ;
            $arr_permanent_address['district'] = $request->district_permanent ? $request->district_permanent: NULL ;

            $staff->permanent_address = json_encode($arr_permanent_address);

            $arr_ssc_details["ssc_group"] = $request->ssc_group ? $request->ssc_group : NULL ;
            $arr_ssc_details["ssc_institute"] = $request->ssc_institute ? $request->ssc_institute : NULL ;
            $arr_ssc_details["ssc_gpa"] = $request->ssc_gpa ? $request->ssc_gpa : NULL ;
            $arr_ssc_details["ssc_year_in_completed"] = $request->ssc_year_in_completed ? $request->ssc_year_in_completed : NULL ;
            $arr_ssc_details["ssc_board"] = $request->ssc_board ? $request->ssc_board : NULL ;

            $arr_hsc_details["hsc_group"] = $request->hsc_group ? $request->hsc_group : NULL ;
            $arr_hsc_details["hsc_institute"] = $request->hsc_institute ? $request->hsc_institute : NULL ;
            $arr_hsc_details["hsc_gpa"] = $request->hsc_gpa ? $request->hsc_gpa : NULL ;
            $arr_hsc_details["hsc_year_in_completed"] = $request->hsc_year_in_completed ? $request->hsc_year_in_completed : NULL ;
            $arr_hsc_details["hsc_board"] = $request->hsc_board ? $request->hsc_board : NULL ;


            $arr_honors_details["honors_dept"] = $request->honors_dept ? $request->honors_dept : NULL ;
            $arr_honors_details["honors_institute"] = $request->honors_institute ? $request->honors_institute : NULL ;
            $arr_honors_details["honors_gpa"] = $request->honors_gpa ? $request->honors_gpa : NULL ;
            $arr_honors_details["honors_year_in_completed"] = $request->honors_year_in_completed ? $request->honors_year_in_completed : NULL ;
            $arr_honors_details["honors_board"] = $request->honors_board ? $request->honors_board : NULL ;

            $arr_masters_details["masters_dept"] = $request->masters_dept ? $request->masters_dept : NULL ;
            $arr_masters_details["masters_institute"] = $request->masters_institute ? $request->masters_institute : NULL ;
            $arr_masters_details["masters_gpa"] = $request->masters_gpa ? $request->masters_gpa : NULL ;
            $arr_masters_details["masters_year_in_completed"] = $request->masters_year_in_completed ? $request->masters_year_in_completed : NULL ;
            $arr_masters_details["masters_board"] = $request->masters_board ? $request->masters_board : NULL ;


            $arr_academic_background["ssc"] =  json_encode($arr_ssc_details) ;
            $arr_academic_background["hsc"] =  json_encode($arr_hsc_details) ;
            $arr_academic_background["honors"] =  json_encode($arr_honors_details) ;
            $arr_academic_background["masters"] =  json_encode($arr_masters_details) ;

            $staff->academic_info = json_encode($arr_academic_background);

            $staff->designation = $request->designation ? $request->designation : NULL ;
            $staff->designation_type = $request->designation_type ? $request->designation_type : NULL ;
            $staff->subject_or_course_name = $request->subject_or_course_name ? $request->subject_or_course_name : NULL ;
            $staff->index_no = $request->index_no ? $request->index_no : NULL ;
            $staff->salary_status = $request->salary_status ? $request->salary_status : NULL ;
            $staff->pay_code = $request->pay_code ? $request->pay_code : NULL ;
            $staff->basic_salary = $request->basic_salary ? $request->basic_salary : NULL ;

            $arr_bank_info["bank_name"] = $request->bank_name ? $request->bank_name : NULL ;
            $arr_bank_info["branch_name"] = $request->branch_name ? $request->branch_name : NULL ;
            $arr_bank_info["routing_no"] = $request->routing_no ? $request->routing_no : NULL ;
            $arr_bank_info["bank_account_name"] = $request->bank_account_name ? $request->bank_account_name : NULL ;
            $arr_bank_info["bank_account_no"] = $request->bank_account_no ? $request->bank_account_no : NULL ;
            $staff->bank_info = json_encode($arr_bank_info);

            $staff->status = 1;
            $staff->save();

            $file_name = '';

            if(!is_null($request->file('profile_photo'))){
                $profile_photo = $request->file('profile_photo') ;
                //Display File Extension
                $extension = $profile_photo->getClientOriginalExtension();
                $file_name = $staff->id.".".$extension;
                //Move Uploaded File
                $destinationPath = 'uploads/staffs';
                $profile_photo->move($destinationPath,$file_name);
                $data['profile_photo'] = $file_name;
            }


            $code = "T".$staff->id;
            $data['code'] = $code;
                //update Profile Photo and Staff Code
                Employee::where('id', $staff->id)
                    ->update($data);


            QrCode::generate($code, 'qrcodes/'.$code.'.svg');

            return response()->json([
                'id' => $staff->id
            ]);


        } catch (\Exception $th) {
            report($th);

            return response()->json([
                'message' => 'Something went wrong. ' . $th->getMessage()
            ], 500);
        }
    }

    /**
     * This will return data into PO Edit Page >> Shipment Details Tab
     * Page URL : .... staffs/{id}/edit
     * @return mixed
     */

    public function editStaff($id)
    {

        $userId = Auth::user()->id;
        $staff = Employee::where('id', $id)
        ->first();
        //dd($staff);

        $all_divisions = Json::getAllDivision();
        $all_districts = Json::getAllDistrict();
        $all_postcodes = Json::getAllPostCodes();
        $all_upazilas = Json::getAllUpazilas();


        //Generate a timestamp using mt_rand.
        $timestamp = mt_rand(1, time());

        return view(
            'staffs.edit',
            compact(
                [
                'timestamp',
                'staff',
                'all_divisions',
                'all_districts',
                'all_postcodes',
                'all_upazilas'
                ]
            )
    );
    }



    /**
     * Update `staff` data
     *
     * @param  \App\Http\Requests\Staff\StoreRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function update(StoreRequest $request)
    {

        try {
            $staff_id = $request->id ? $request->id: NULL ;
            $name = $request->name ? $request->name: NULL ;
            $fathers_name = $request->fathers_name ? $request->fathers_name: NULL ;
            $mothers_name = $request->mothers_name ? $request->mothers_name: NULL ;
            $mobile_no = $request->mobile_no ? $request->mobile_no: NULL ;
            $email = $request->email ? $request->email: NULL ;
            $nid = $request->nid ? $request->nid : NULL ;

            $dob = $request->dob ? date('Y-m-d', strtotime($request->dob)) : NULL ;
            $nationality = $request->nationality ? $request->nationality: NULL ;
            $religion = $request->religion ? $request->religion: NULL ;
            $blood_group = $request->blood_group ? $request->blood_group: NULL ;
            $gender = $request->gender ? $request->gender: NULL ;
            $marital_status = $request->marital_status ? $request->marital_status: 0 ;
            $profile_photo = $request->profile_photo ;

            $arr_current_address = array();
            $arr_current_address['village'] = $request->village ? $request->village: NULL ;
            $arr_current_address['post_code'] = $request->post_code ? $request->post_code: NULL ;
            $arr_current_address['upazila'] = $request->upazila ? $request->upazila: NULL ;
            $arr_current_address['district'] = $request->district ? $request->district: NULL ;

            $current_address = json_encode($arr_current_address);
            $same_as_current = $request->same_as_current ? $request->same_as_current: NULL ;

            $arr_permanent_address = array();
            $arr_permanent_address['village'] = $request->village_permanent ? $request->village_permanent: NULL ;
            $arr_permanent_address['post_code'] = $request->post_code_permanent ? $request->post_code_permanent: NULL ;
            $arr_permanent_address['upazila'] = $request->upazila_permanent ? $request->upazila_permanent: NULL ;
            $arr_permanent_address['district'] = $request->district_permanent ? $request->district_permanent: NULL ;

            $permanent_address = json_encode($arr_permanent_address);

            $arr_ssc_details["ssc_group"] = $request->ssc_group ? $request->ssc_group : NULL ;
            $arr_ssc_details["ssc_institute"] = $request->ssc_institute ? $request->ssc_institute : NULL ;
            $arr_ssc_details["ssc_gpa"] = $request->ssc_gpa ? $request->ssc_gpa : NULL ;
            $arr_ssc_details["ssc_year_in_completed"] = $request->ssc_year_in_completed ? $request->ssc_year_in_completed : NULL ;
            $arr_ssc_details["ssc_board"] = $request->ssc_board ? $request->ssc_board : NULL ;

            $arr_hsc_details["hsc_group"] = $request->hsc_group ? $request->hsc_group : NULL ;
            $arr_hsc_details["hsc_institute"] = $request->hsc_institute ? $request->hsc_institute : NULL ;
            $arr_hsc_details["hsc_gpa"] = $request->hsc_gpa ? $request->hsc_gpa : NULL ;
            $arr_hsc_details["hsc_year_in_completed"] = $request->hsc_year_in_completed ? $request->hsc_year_in_completed : NULL ;
            $arr_hsc_details["hsc_board"] = $request->hsc_board ? $request->hsc_board : NULL ;


            $arr_honors_details["honors_dept"] = $request->honors_dept ? $request->honors_dept : NULL ;
            $arr_honors_details["honors_institute"] = $request->honors_institute ? $request->honors_institute : NULL ;
            $arr_honors_details["honors_gpa"] = $request->honors_gpa ? $request->honors_gpa : NULL ;
            $arr_honors_details["honors_year_in_completed"] = $request->honors_year_in_completed ? $request->honors_year_in_completed : NULL ;
            $arr_honors_details["honors_board"] = $request->honors_board ? $request->honors_board : NULL ;

            $arr_masters_details["masters_dept"] = $request->masters_dept ? $request->masters_dept : NULL ;
            $arr_masters_details["masters_institute"] = $request->masters_institute ? $request->masters_institute : NULL ;
            $arr_masters_details["masters_gpa"] = $request->masters_gpa ? $request->masters_gpa : NULL ;
            $arr_masters_details["masters_year_in_completed"] = $request->masters_year_in_completed ? $request->masters_year_in_completed : NULL ;
            $arr_masters_details["masters_board"] = $request->masters_board ? $request->masters_board : NULL ;


            $arr_academic_background["ssc"] =  json_encode($arr_ssc_details) ;
            $arr_academic_background["hsc"] =  json_encode($arr_hsc_details) ;
            $arr_academic_background["honors"] =  json_encode($arr_honors_details) ;
            $arr_academic_background["masters"] =  json_encode($arr_masters_details) ;

            $academic_info = json_encode($arr_academic_background);

            $designation = $request->designation ? $request->designation : NULL ;
            $designation_type = $request->designation_type ? $request->designation_type : NULL ;
            $subject_or_course_name = $request->subject_or_course_name ? $request->subject_or_course_name : NULL ;
            $index_no = $request->index_no ? $request->index_no : NULL ;
            $salary_status = $request->salary_status ? $request->salary_status : NULL ;
            $pay_code = $request->pay_code ? $request->pay_code : NULL ;
            $basic_salary = $request->basic_salary ? $request->basic_salary : NULL ;

            $arr_bank_info["bank_name"] = $request->bank_name ? $request->bank_name : NULL ;
            $arr_bank_info["branch_name"] = $request->branch_name ? $request->branch_name : NULL ;
            $arr_bank_info["routing_no"] = $request->routing_no ? $request->routing_no : NULL ;
            $arr_bank_info["bank_account_name"] = $request->bank_account_name ? $request->bank_account_name : NULL ;
            $arr_bank_info["bank_account_no"] = $request->bank_account_no ? $request->bank_account_no : NULL ;
            $bank_info = json_encode($arr_bank_info);

            $status = '1';

            $data = [
                'name' => $name,
                'fathers_name' => $fathers_name,
                'mothers_name' => $mothers_name,
                'mobile_no' => $mobile_no,
                'email' => $email,
                'nid' => $nid ,
                'dob' => $dob,
                'nationality' => $nationality ,
                'religion' => $religion ,
                'blood_group' => $blood_group ,
                'gender' => $gender ,
                'marital_status' => $marital_status ,
                'current_address' => $current_address,
                'same_as_current' => $same_as_current,
                'permanent_address' => $permanent_address,
                'academic_info' => $academic_info,
                'designation' => $designation,
                'designation_type' => $designation_type,
                'subject_or_course_name' => $subject_or_course_name,
                'index_no' => $index_no,
                'salary_status' => $salary_status,
                'pay_code' => $pay_code,
                'basic_salary' => $basic_salary,
                'bank_info' => $bank_info
            ];



             $file_name = '';
            if(!is_null($request->file('profile_photo'))){
                $profile_photo = $request->file('profile_photo') ;
                //Display File Extension
                $extension = $profile_photo->getClientOriginalExtension();
                $file_name = $staff_id.".".$extension;
                //Move Uploaded File
                $destinationPath = 'uploads/staffs';
                $profile_photo->move($destinationPath,$file_name);
                $data['profile_photo'] = $file_name;
            }

            Employee::where('id',$staff_id)
                ->update($data);



           //return redirect(route('staffs.edit'))->with('success', 'Staff  created successfully.');


        } catch (\Exception $th) {
            report($th);

            return response()->json([
                'message' => 'Something went wrong. ' . $th->getMessage()
            ], 500);
        }
    }



    public function delete(Request $request)
    {
        Employee::where('id', $request->id)->delete();
        return [
            'status' => 1
        ];
    }

    /**
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     *
     */
    public function DownloadStaffs(Request $request)
    {
        $status = $request->status;

        if($status=='all'){
            $staffs = Employee::where('employee_type','staff')->get();
        }else{
            $staffs = Employee::where('employee_type','staff')->where('status',$status)->get();
        }

        $data = [
            'school_info' => Settings::first(),
            'staffs' => $staffs
        ];

        $customPaper = array(0,0,60.00,50.80);

        $width= '600';
        $height = '1200';


        $page_header = "Staffs List";
        $file_name = "staffs_list";

        $pdf = PDF::loadView('staffs.pdf_staffs_list',$data)
        ->setOptions(['defaultFont' => 'Courier'])
        ->setOptions(
            ['isHtml5ParserEnabled' => true,
            'enable_remote' => true,
            'chroot'  => public_path(),
        ])
        ->setPaper('A4', 'portrait');//
        // ->setPaper(array(0,0,$width,$height));

            // $paper_size = array(0,0,360,360);
            // $dompdf->set_paper($paper_size);

        $time = strtotime("today");
        if(!empty($staffs)){
            $file_name = $file_name.'-'.$time.'.pdf';
        }

        $path = public_path('pdf');
        $pdf->save($path . '/' . $file_name);
        $download_link = asset('pdf').'/'.$file_name;
        return 'Staffs PDF List Created Successfully, Please click to <a class="font-bold" href="'.$download_link.'" target="_blank">View</a> Or <a class="font-bold" href="'.$download_link.'" download>Download Now</a>';
    }


}
