<?php

namespace App\Http\Controllers;

use App\Models\Size;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Yajra\DataTables\Facades\DataTables;

class SizeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return array
     */
    public function index()
    {
        $title = 'size';
        $data = Size::get();
        return view('settings.size',compact('title','data'));
    }

    public function data(Request $request)
    {
        if ($request->ajax()){
            if (isset($request->id) && $request->id != null) {
                $editData = Size::where([
                    'id' => $request->id
                ])->first();
                return view('elements.form-update-size',compact( 'editData'));
            }

            $data = Size::where('shop_id',Auth::user()->shop_id)->get();

            $table = Datatables::of($data)
                ->addColumn('manage', function ($row) {
                    return '
                        <div class="w-full text-left">
                            <button type="button" class="modal-open btn-action--green" title="'. __('translation.Edit') .'" x-on:click="showEditModal=true" data-id="' . $row->id . '" id="BtnUpdate">
                                <i class="fas fa-pencil-alt"></i>
                            </button>
                            <button type="button" class="btn-action--red" title="'. __('translation.Delete') .'" data-id="' . $row->id . '" id="BtnDelete">
                                <i class="fas fa-trash-alt"></i>
                            </button>
                        </div>
                    ';
                })
                ->rawColumns(['manage'])
                ->make(true);

            return $table;
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('elements.form-update-size');

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $size = new Size();
        $size->name = $request->name;

        $size->shop_id = Auth::user()->shop_id;
        $size->seller_id = Auth::user()->id;
        $size->save();

        if($size)
        {
            return redirect()->back()->with('success','Size Added Successfully');
        }
        else{
            return redirect()->back()->with('danger','Something happened wrong');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = Size::where('id',$id)->get();

        return view('settings.size',compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'id' => 'required',
            'name' => 'required'
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }
        $size = Size::where('id', $request->id)->first();
        $size->name = $request->name;
        $size->seller_id = Auth::user()->id;
        $size->save();

        if($size)
        {
            return redirect('sizes')->with('success','Size Updated Successfully');
        }
        else{
            return redirect('sizes')->with('danger','Something happened wrong');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
    public function delete(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'id' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 0,
                'message' => 'Field id is required'
            ]);
        } else {

            $size = Size::where('id',$request->id)->where('seller_id',Auth::user()->id)->first();
            if(file_exists($size->logo)){
                unlink($size->logo);
            }
            $size->delete();

            return [
                'status' => 1
            ];
        }
    }
}
