<?php

namespace App\Http\Controllers\Shop;

use App\Http\Controllers\Controller;
use App\Http\Requests\Shop\SelectShopRequest;
use App\Http\Resources\ShopSelectTwoResource;
use App\Models\Shop;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ShopSelectController extends Controller
{
    /**
     * Handle the select2 server for shops side from custom_orders
     *
     * @param  \App\Http\Requests\Shop\SelectShopRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function index(SelectShopRequest $request)
    {
        $personId = Auth::user()->id;

        $page = $request->get('page');
        $keyword = $request->get('search');

        $limit = 10;
        $skip = ($page - 1) * $limit;

        $shops = Shop::selectRaw('id, name')
                    ->where('person_id', $personId)
                    ->searchFromSelectTwo($keyword)
                    ->take($limit)
                    ->skip($skip)
                    ->orderBy('name')
                    ->get();

        $shopsCount = Shop::where('person_id', $personId)
                    ->searchFromSelectTwo($keyword)
                    ->count();

        return response()->json([
            'results' => ShopSelectTwoResource::collection($shops),
            'pagination' => [
                'more' => $shopsCount > ($page * $limit)
            ]
        ]);
    }
}
