<?php

namespace App\Http\Controllers;
use App\Http\Requests\Settings\FeeSetting\StoreRequest;
use App\Actions\UpdateSchoolInfoAction;
use App\Http\Controllers\Controller;
use App\Http\Requests\Settings\SchoolInfoSetting\UpdateRequest;

use App\Models\FeeTypesAmount;


use App\Models\Classes;
use App\Models\Sections;
use App\Models\Groups;
use App\Models\Sessions;
use App\Models\Subjects;
use App\Models\MarkTypes;
use App\Models\Marks;
use App\Models\MarksEntryForm;
use App\Models\CurrentAcadmicStatus;
use App\Models\FeeTypes;
use App\Models\StudentFee;
use App\Models\Settings;
use App\Models\Json;


use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Datatables;
use DB;
use PDF;
class SettingsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {


        $arr_param['personId'] = Auth::user()->id;
        Session::put('itemArray', []);



        $data = [
            'classes' => Classes::get(),
            'sections' => Sections::get(),
            'sessions' => Sessions::orderBy('id', 'DESC')->get()
        ];

        //return view('settings.fee', $data);
    }

    /**
     * Show form to update school info data
     *
     * @return \Illuminate\View\View
     */
    public function school_info_settings()
    {
        $data = [
            'settings' => Settings::where('user_id', Auth::user()->id)->first()
        ];
        return view('settings.school-info-settings',$data);
    }

        /**
     * Update the school info data
     *
     * @param  \App\Http\Requests\Settings\SchoolInfoSetting\UpdateRequest  $request
     * @param  \App\Actions\UpdateSchoolInfoAction  $action
     * @return \Illuminate\Http\Response
     */
    public function update_school_info(UpdateRequest $request, UpdateSchoolInfoAction $action)
    {
        try {
            $schoolData = [
                'school_name' => $request->school_name,
                'established' => $request->established,
                'school_logo' => $request->file('school_logo'),
                'school_phone' => $request->school_phone,
                'school_address' => $request->school_address,
            ];

            $action->handle($schoolData);

            return $this->apiResponse(Response::HTTP_OK, 'Data successfully updated.');

        } catch (\Throwable $th) {
            report($th);

            return $this->apiResponse(Response::HTTP_INTERNAL_SERVER_ERROR, 'Something went wrong.');
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function fee()
    {
        Session::put('itemArray', []);

        $personId = Auth::user()->id;


        $current_year = Carbon::now()->format('Y');
        $currentSession = Sessions::select('id')->where('session_name', $current_year)->first();
        $class_arr = Classes::all();
        $currentSession_id=$currentSession->id;
        $feeTypes = FeeTypes::with(['fee_types_amount' => function ($query)  use ($currentSession_id){
                    $query->where('session_id', $currentSession_id);
                }])
                ->orderBy('name')->get();
        //dd($feeTypes[0]);
        $i=0;
        foreach($class_arr as $key=>$class){
            $classes[$key]=$class;
            if($i==0){
                $classes[$key]['active']='active';
            }else{
                $classes[$key]['active']=NULL;
            }
        $i++;
        }
        $data = [
            'feeTypes' => $feeTypes,
            'amount' => '',
            'classes' => $classes,
            'currentSession_id' => $currentSession_id,
            'sessions' => Sessions::orderBy('session_name','desc')->get()
        ];

        return view('settings.fee', $data);
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function getFeeBySessionId(Request $request)
    {
        Session::put('itemArray', []);

        $personId = Auth::user()->id;

        $class_arr = Classes::all();
        $currentSession_id=$request->sessionId;
        $feeTypes = FeeTypes::with(['fee_types_amount' => function ($query)  use ($currentSession_id){
                    $query->where('session_id', $currentSession_id);
                }])
                ->orderBy('name')->get();


        $i=0;
        foreach($class_arr as $key=>$class){
            $classes[$key]=$class;
            if($i==0){
                $classes[$key]['active']='active';
            }else{
                $classes[$key]['active']=NULL;
            }
        $i++;
        }

        $defaultFeeTypes = FeeTypes::get();


        $data = [
            'feeTypes' => $feeTypes,
            'amount' => '',
            'classes' => $classes,
            'currentSession_id' => $currentSession_id,
            'sessions' => Sessions::orderBy('session_name','desc')->get()
        ];

        return view('settings.ajax_fee', $data);
    }



    /**
     * Store `order_purchase` data
     *
     * @param  \App\Http\Requests\Student\StoreRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function storeFee(StoreRequest $request)
    {

        //dd($request->all());
        DB::table('fee_types_amount')->where('session_id',$request->session_id)->delete();

        try {

            $classes = Classes::all();
            foreach($classes as $class):
                $class_id = $class->id;
                $class_name = $class->class_name;
                $classWiseFeeType = $request->$class_name;
                //dd($classWiseFeeType);
                foreach($classWiseFeeType as $fee_type_id=>$amount):
                    $fee_types_amount = new FeeTypesAmount();
                    $fee_types_amount->fee_type_id = $fee_type_id;
                    $fee_types_amount->amount = $amount ? $amount: 0 ;
                    $fee_types_amount->session_id = $request->session_id ;
                    $fee_types_amount->class_id = $class_id ;
                    $fee_types_amount->save();
                endforeach;
             endforeach;
             return redirect(route('fee'))->with('success', 'Fee Amount created successfully.');

        } catch (\Exception $th) {
            report($th);

            return response()->json([
                'message' => 'Something went wrong. ' . $th->getMessage()
            ], 500);
        }
    }










    /**
     * Set Status 1 OR 0 on fee_types table page.
     *
     * @param  int  $id
     * @return \Illuminate\View\View
     */
    public function statusChangeOthersFeeField(Request $request)
    {

        $status = $request->status;
        $feeTypes = FeeTypes::find($request->id);
        $feeTypes->status = $request->status;
        $feeTypes->save();
        return 'success';
    }




}
