<?php

namespace App\Http\Controllers;

use App\Models\Package;
use App\Models\Product;
use App\Models\OrderPurchase;
use App\Models\Shipment;
use App\Models\StockLog;
use App\Models\OrderManagement;
use Illuminate\Support\Facades\Cache;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Carbon;
use Yajra\DataTables\Facades\DataTables;


class SellerController extends Controller
{
    public function dashboard()
    {
        
        
        // try {
        //     $seller_id = Auth::id();

        //     $data2[] = StockLog::where('date', '>=', Carbon::now()->subDay())->get()->groupBy(function ($date) {
        //         return Carbon::parse($date->date)->format('h');
        //     });

        //     $arr_remove_from_stock = array();
        //     $arr_add_to_stock = array();

        //     foreach ($data2[0] as $arrItem) {
        //         foreach ($arrItem as $value) {
        //             $current = strtotime(date("Y-m-d"));
        //             $date = strtotime($value['date']);

        //             $datediff = $date - $current;
        //             $difference = floor($datediff / (60 * 60 * 24));
        //             if ($difference == 0) {
        //                 $hour = date("H", strtotime($value['date']));
        //                 $hour = ltrim($hour, "0");
        //                 if ($value['str_in_out'] == 'Remove') $arr_remove_from_stock[$hour][] = $value['quantity'];
        //                 if ($value['str_in_out'] == 'Add') $arr_add_to_stock[$hour][] = $value['quantity'];
        //             }
        //         }
        //     }

        //     foreach ($arr_add_to_stock as $hour => $list) {
        //         $arr_add_to_stock[$hour] = array_sum($list);
        //     }

        //     foreach ($arr_remove_from_stock as $hour => $list) {
        //         $arr_remove_from_stock[$hour] = array_sum($list);
        //     }

        //     $today = date('Y-m-d');
        //     $data_add_to_stock = array_fill(0, 24, '0');
        //     $data_remove_from_stock = array_fill(0, 24, '0');
        //     for ($i = 0; $i < 24; $i++) {
        //         $dates[] = $i;
        //         if (!empty($arr_add_to_stock[$i])) {
        //             $data_add_to_stock[$i] = $arr_add_to_stock[$i];
        //         }
        //         if (!empty($arr_remove_from_stock[$i])) {
        //             $data_remove_from_stock[$i] = $arr_remove_from_stock[$i];
        //         }

        //         $arr_date[$i] = $today . ' ' . $i . ':00:00';
        //     }

        //     $ordersToProcess =
        //         Cache::remember('orders-to-process', 60, function () {
        //             return
        //                 OrderManagement::where("seller_id", Auth::id())
        //                     ->where('order_status', OrderManagement::ORDER_STATUS_PROCESSING)
        //                     ->select(DB::raw('count(*) as total'))
        //                     ->count();
        //         });

        //     $ordersToShip =
        //         Cache::remember('orders-to-ship', 60, function () {
        //             return
        //                 Shipment::where("seller_id", Auth::id())
        //                     ->where('shipment_status', Shipment::SHIPMENT_STATUS_READY_TO_SHIP)
        //                     ->orWhere("shipment_status", Shipment::SHIPMENT_STATUS_READY_TO_SHIP_PRINTED)
        //                     ->select(DB::raw('count(*) as total'))
        //                     ->count();
        //         });

        //     $total_low_stock =
        //         Cache::remember('total-low-stock', 60, function () {
        //             return
        //                 Product::join('product_main_stocks', 'product_main_stocks.product_id' , '=', 'products.id')
        //                     ->select('product_main_stocks.quantity', 'products.alert_stock')
        //                     ->where('product_main_stocks.quantity' , '>', 0)
        //                     ->Where('product_main_stocks.quantity' , '<=', 'products.alert_stock')
        //                     ->count();
        //         });


        //     $total_out_of_stock =
        //         Cache::remember('total-out-of-stock', 60, function () {
        //             return
        //                 Product::join('product_main_stocks', 'product_main_stocks.product_id' , '=', 'products.id')
        //                     ->select('product_main_stocks.quantity', 'products.alert_stock')
        //                     ->where('product_main_stocks.quantity' , '<=', 0)
        //                     ->where('products.alert_stock' , '!=', '')
        //                     ->count();
        //         });

        //     $last_changes =
        //         Cache::remember('stock-changes', 60, function () {
        //             return
        //                 StockLog::getLastChangesStock(10);
        //         });

        //     abort_if(!$last_changes, 404, 'Data not found');

        //     $top_five_stock =
        //         Cache::remember('highest-stock', 60*60, function () {
        //             return
        //                 StockLog::getTopNthStock(5);
        //         });

        //     abort_if(!$top_five_stock, 404, 'Data not found');

        //     $latest_stock =
        //         Cache::remember('latest-stock', 60*60, function (){
        //             return
        //                 StockLog::where('seller_id', Auth::id())
        //                 ->with('product')
        //                 ->with('main_stock')
        //                 ->with('seller')
        //                 ->with('staff')
        //                 ->orderBy('quantity', 'desc')
        //                 ->orderBy('date', 'desc')
        //                 ->get();
        //         });

        //     abort_if(!$latest_stock, 404, 'Data not found');

        //     $series_data['orders_today'] = OrderPurchase::getTodaysPODataBySellerID($today, $seller_id);
        //     $series_data['orderPurchaseTotalProcess'] = $ordersToProcess;
        //     $series_data['shipmentsTotal'] = $ordersToShip;
        //     $series_data['total_low_stock'] = $total_low_stock;
        //     $series_data['total_out_of_stock'] = $total_out_of_stock;
        //     $series_data['defect_stock'] = StockLog::getTotalDefectStocks();
        //     //return view('seller.dashboard', compact(['arr_date', 'dates', 'series_data', 'last_changes', 'data_add_to_stock', 'data_remove_from_stock', 'top_five_stock', 'latest_stock']));

        // }
        // catch (\Throwable $th) {
        //     report($th);

        //     return $this->apiResponse(Response::HTTP_INTERNAL_SERVER_ERROR, 'Sorry, something went wrong. ' . $th->getMessage());
        // }

    }

    public function package()
    {
        $packages = DB::table('packages')
            ->get();
        return view('seller.package', compact('packages'));
    }

    public function data(Request $request)
    {
        if ($request->ajax()) {

            if (isset($request->id) && $request->id != null) {
                $data = Package::where([
                    'id' => $request->id
                ])->first();

                $id = $request->id;

                return view('elements.form-update-package', compact(['data', 'id']));
            }


            $data = package::orderBy('id', 'desc')->get();


            $table = Datatables::of($data)
                ->addColumn('price', function ($row) {
                    return currency_symbol('BDT') .$row->price;
                })
                ->addColumn('package_type', function ($row) {
                    if($row->package_type == 1)
                    {
                        return 'Daily';
                    }
                    else
                    {
                        return 'Monthly';
                    }
                })
                ->addColumn('manage', function ($row) {
                    return '<span x-on:click=" showEditModal=true"class="modal-open bg-green-500 text-white rounded px-2 py-1 mr-4 capitalize cursor-pointer" data-id="' . $row->id . '" id="BtnUpdate">Edit</span><span class="bg-red-500 text-white rounded px-2 py-1 capitalize cursor-pointer" data-id="' . $row->id . '" id="BtnDelete">Delete</span>';
                })

                ->rawColumns(['manage'])
                ->make(true);
            return $table;
        }
    }

    public function insert(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required|',
            'price' => 'required',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        Package::create([
            'package_name' => $request->name,
            'price' => $request->price,
            'details' => $request->details,
            'max_limit' => $request->max_limit,
            'package_type' => $request->package_type
        ]);

        return redirect()->back()->with('success', 'Package successfully created');
    }

    public function update(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required|',
            'price' => 'required',
        ],);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        DB::table('packages')
            ->where('id', $request->id)
            ->update([
                'package_name' => $request->name,
                'price' => $request->price,
                'details' => $request->details,
                'max_limit' => $request->max_limit,
                'package_type' => $request->package_type
            ]);

        if ($request->password) {
            return $this->changePassword($request);
        }

        return redirect('/admin/package')->with('success', 'Package successfully updated');
    }

    public function delete(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'id' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 0,
                'message' => 'Field id is required'
            ]);
        } else {

            DB::table('packages')->where([
                'id' => $request->id
            ])->delete();

            return [
                'status' => 1
            ];
        }
    }

}
