<?php

namespace App\Http\Controllers;

use App\Models\Sections;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Yajra\DataTables\Facades\DataTables;
use DB;
class SectionController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return array
     */
    public function index()
    {
        $title = 'section';
        $data = Sections::orderBy('position','ASC')->get();
        return view('sections.index',compact('title','data'));
    }

      /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $section = new Sections();
        $section->section_name = $request->section_name;
        $section->position = Sections::max('position')+1;
        $section->save();

        if($section)
        {
            return redirect()->back()->with('success','Section Added Successfully');
        }
        else{
         return redirect()->back()->with('danger','Something happened wrong');
        }
    }


    public function updateSection(Request $request, $id)
    {
        $section = Sections::find($id);
        $section->section_name = $request->section_name;
        $section->save();

        if($section){
            return redirect('sections')->with('success','Section Updated Successfully');
        }
        else{
         return redirect('sections')->with('danger','Something happened wrong');
        }
    }


    public function sectionReOrder(Request $request)
    {

        //return($request->order);
        foreach ($request->order as $order) {
                DB::table('sections')
                ->where('id',$order['id'])
                ->update([
                    'position' =>$order['position']
                ]);

            }
            return "success";
    }

    public function delete($id)
    {
        $section = Sections::where('id',$id)->delete();
        if($section)
        {
            return redirect()->back()->with('success','Section Deleted Successfully');
        }
        else{
         return redirect()->back()->with('danger','Something happened wrong');
        }
    }
}
