<?php

namespace App\Http\Controllers;
use App\Models\Student;
use App\Models\Exams;
use App\Models\Classes;
use App\Models\Sections;
use App\Models\Sessions;
use App\Models\Groups;
use App\Models\Subjects;
use App\Models\MarkTypes;
use App\Models\Marks;
use App\Models\MarksByClass;
use App\Models\CurrentAcadmicStatus;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Datatables;
use DB;
use PDF;
use Illuminate\Support\Facades\Auth;
class SeatPlansController extends Controller
{


    /**
     * Load `Marks Entry Form ` Page >> URL : .../marks_by_class
    */
    public function SeatPlans()
    {


        $data = [
            'exams' => Exams::orderBy('position', 'ASC')->get(),
            'classes' => Classes::get(),
            'sections' => Sections::get(),
            'sessions' => Sessions::orderBy('id', 'DESC')->get(),
            'subjects' => Subjects::orderBy('name', 'ASC')->get(),
            'mark_types' => MarkTypes::orderBy('position', 'ASC')->get(),
        ];
        return view('seat_plans.index', $data);
    }




    /**
     * Handle the `marks entry form ` datatable
     * Serverside Datatable
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     *
     */
    public function SeatPlansDataTable(Request $request)
    {
        if ($request->ajax()) {
            $userId = Auth::user()->id;
            $examId = $request->get('examId', '');
            $class_id = $request->get('classId', '');
            $section_id = $request->get('sectionId', array());
            $session_id = $request->get('sessionId', '');


            $students = CurrentAcadmicStatus::where('session_id', $session_id)
            ->where('class_id', $class_id)
            ->where('section_id', $section_id)
            ->join('students', 'students.id', '=', 'current_academic_status.student_id')
            ->with('session')
            ->with('class')
            ->with('section')
            ->with('group')
            ->orderBy('current_academic_status.id','desc')
            ->select(
                'current_academic_status.*',
                'students.name',
                'students.roll_no'
                )
            ->get();
            //dd($students);
            $table = Datatables::of($students)
                        ->addColumn('name', function ($row) {
                            if(isset($row->name)){
                                return $row->name;
                            }
                        })

                        ->addColumn('roll_no', function ($row) {
                            if(isset($row->roll_no)){
                                return $row->roll_no;
                            }
                        })



                        ->addColumn('class_name', function ($row) {
                           return $row->class->class_name;
                        })


                        ->addColumn('section_name', function ($row) {
                            return $row->section->section_name;
                        })
                        ->addColumn('session_name', function ($row) {
                            return $row->session->session_name;
                        })

                        ->rawColumns(['name', 'roll_no'])
                        ->skipPaging()
                        //->setTotalRecords($dataCount)
                        ->make(true);

            return $table;
        }
    }


    /**
     * Handle the `product stock report` datatable
     * Serverside Datatable
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     *
     */
    public function SeatPlansPDFExport(Request $request)
    {

            $userId = Auth::user()->id;

            $session_id = $request->session_id;
            $exam_id = $request->exam_id;
            $class_id = $request->class_id;
            $section_id = $request->section_id;


            $offset = $request->get('start', 0);

            $limit = $request->get('length', 10);
            if ($limit < 1 OR $limit > 100) {
                $limit = 100;
            }

            $search = isset($request->get('search')['value'])
                    ? $request->get('search')['value']
                    : null;

            $orderColumnList = [
                'id',
                 '',
                'name',
                'roll_name',
                'section_name'
            ];

            $orderColumnIndex = isset($request->get('order')[0]['column'])
                                ? $request->get('order')[0]['column']
                                : 0;
            $orderColumnDir = isset($request->get('order')[0]['dir'])
                                ? $request->get('order')[0]['dir']
                                : 'asc';

            $orderColumn = isset($orderColumnList[$orderColumnIndex])
                            ? $orderColumnList[$orderColumnIndex]
                            : 'name';

            $otherReportParams = [
                'search' => $search,
                'limit' => $limit,
                'offset' => $offset,
                'order_column' => $orderColumn,
                'order_dir' => $orderColumnDir,
                'exam_id' => $exam_id,
                'class_id' => $class_id,
                'section_id' => $section_id,
                'session_id' => $session_id,
            ];



        $students = CurrentAcadmicStatus::where('session_id', $session_id)
        ->where('class_id', $class_id)
        ->where('section_id', $section_id)
        ->join('students', 'students.id', '=', 'current_academic_status.student_id')
        ->with('session')
        ->with('class')
        ->with('section')
        ->with('group')
        ->orderBy('current_academic_status.id','desc')
        ->select(
            'current_academic_status.*',
            'students.name',
            'students.roll_no'
            )
        ->get();


        $customPaper = array(0,0,60.00,50.80);

        $width= '600';
        $height = '1200';

        //dd($students);

        $pdf = PDF::loadView('seat_plans.generate-seat-plans-pdf',compact('students'))
        ->setOptions(['defaultFont' => 'Courier'])
        ->setOptions(['isHtml5ParserEnabled' => true, 'isRemoteEnabled' => true])
        ->setPaper('A4', 'portrait');//
       // ->setPaper(array(0,0,$width,$height));

            //         $paper_size = array(0,0,360,360);
            // $dompdf->set_paper($paper_size);

        $time = strtotime("today");
        return $pdf->download('Seat Plans-'.$time.'.pdf');

    }

}
