<?php

namespace App\Http\Controllers;

use App\Models\Role;
use App\Models\Shop;
use App\Models\User;
use App\Models\Salary;
use App\Models\Banks;
use App\Models\MobileWalets;
use App\Models\Employee;
use Illuminate\Http\Request;
use Datatables;
use DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Carbon;
class SalaryController extends Controller
{
    public function salaries()
    {
        $banks = Banks::get();
        $mobile_walets = MobileWalets::get();
        $title = 'Daily Expense';
        return view('transactions.salaries', compact('banks', 'mobile_walets', 'title'));
    }

    public function data(Request $request)
    {
        if ($request->ajax()) {
            if (isset($request->id) && $request->id != null) {
                $data = Salary::where([
                    'id' => $request->id
                ])
                ->with('employee')
                ->first();

                $id = $request->id;
                $roles = Role::all();
                $banks = Banks::get();
                $mobile_wallets = MobileWalets::get();

                return view('elements.form-update-salaries', compact(['data', 'id', 'banks','mobile_wallets']));
            }

            $data = Salary::orderBy('id', 'desc')
            ->with('employee')
                ->get();

            $table = Datatables::of($data)
            ->addColumn('checkbox', function ($row) {
                return "<input type='checkbox' name='salary_id' class='salary_id' data-id='" . $row->id . "'>";
            })
                ->addColumn('created_at', function ($row) {
                    return $row->entry_date;
                })
                ->addColumn('name', function ($row) {
                    return $row->employee->name;
                })

                ->addColumn('details', function ($row) {
                    return $row->details;
                })

                ->addColumn('amount', function ($row) {
                    return $row->amount;
                })

                ->addColumn('note', function ($row) {
                    return $row->note;
                })
                ->addColumn('designation', function ($row) {
                    return ucfirst($row->employee->employee_type);
                })
                ->addColumn('manage', function ($row) {
                    if (Auth::user()->role == 'member'){
                        return '<div class="w-full text-center">
                                    <button type="button" class="modal-open btn-action--green" title="'. __('translation.Edit') .'" x-on:click="showEditModal=true" data-id="' . $row->id . '" id="BtnUpdate">
                                       <i class="fas fa-pencil-alt"></i>
                                    </button>
                                    <button type="button" class="btn-action--red" title="'. __('translation.Delete') .'" data-id="' . $row->id . '" id="BtnDelete">
                                        <i class="fas fa-trash-alt"></i>
                                    </button>
                                </div>';
                    }
                    else{
                        return '<div class="w-full text-center">
                                    <button type="button" class="modal-open btn-action--green" title="'. __('translation.Edit') .'" x-on:click="showEditModal=true" data-id="' . $row->id . '" id="BtnUpdate">
                                        <i class="fas fa-pencil-alt"></i>
                                    </button>
                                    <button type="button" class="btn-action--red" title="'. __('translation.Delete') .'" data-id="' . $row->id . '" id="BtnDelete">
                                        <i class="fas fa-trash-alt"></i>
                                    </button>
                                </div>';
                    }
                })
                ->rawColumns(['checkbox','manage'])
                ->make(true);
            return $table;
        }
    }

    public function autocomplete(Request $request){

        $query = Employee::select(
                DB::raw(
                    "CONCAT(`name`,' (',`code`,')') as value"),
                     "code", "id"
                    )->where('name', 'LIKE', '%'. $request->get('search'). '%');

        if($request->employee_type=='teacher'){
            $query->where('employee_type', 'teacher');
        }else{
            $query->where('employee_type', 'staff');
        }

        $data = $query->get();

        return response()->json($data);
    }

    public function insert(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'details' => 'required',
            'amount' => 'required',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }
        $bank_or_wallet_id = 0;
        $acc_or_mobile_no = 0;
        if($request->payment_method=='cheque'){
            $bank_or_wallet_id = $request->bank_name ? $request->bank_name: 0 ;
            $acc_or_mobile_no = $request->cheque_no ? $request->cheque_no: '' ;
        }

        if($request->payment_method=='mobile_banking'){
            $bank_or_wallet_id = $request->wallet_name ? $request->wallet_name: '' ;
            $acc_or_mobile_no = $request->mobile_no ? $request->mobile_no: '' ;
        }

        $dailyCost = Salary::create([
            'employee_id' => $request->employee_id,
            'details' => $request->details,
            'amount' => $request->amount,
            'note' => $request->note,
            'entry_date' => Carbon::now(),
            'status' => '0',
            'payment_method' => $request->payment_method,
            'bank_or_wallet_id' => $bank_or_wallet_id,
            'acc_or_mobile_no' => $acc_or_mobile_no
        ]);

        return redirect()->back()->with('success', 'Data successfully created');
    }

    public function update(Request $request)
    {
        $salaries = Salary::find($request->id);

        $validator = Validator::make($request->all(), [
            'details' => 'required',
            'amount' => 'required',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }
        $salaries->employee_id = $request->employee_id;
        $salaries->details = $request->details;
        $salaries->amount = $request->amount;
        $salaries->note = $request->note;
        $salaries->payment_method = $request->payment_method;
        if($request->payment_method=='cheque'){
            $salaries->bank_or_wallet_id = $request->bank_name ? $request->bank_name: '' ;
            $salaries->acc_or_mobile_no = $request->cheque_no ? $request->cheque_no: '' ;
        }

        if($request->payment_method=='mobile_banking'){
            $salaries->bank_or_wallet_id = $request->wallet_name ? $request->wallet_name: '' ;
            $salaries->acc_or_mobile_no = $request->mobile_no ? $request->mobile_no: '' ;
        }
        $salaries->update();

        return redirect('salaries')->with('success', __('translation.Data successfully updated'));
    }

    public function changeStatusModal(Request $request)
    {
        $ids = $request->ids;
        return view('elements.form-approved-daily-expense', compact('ids'));
    }

    public function changeStatus(Request $request)
    {
        $arr_ids = explode(",",$request->ids);
        DB::table('salariess')->whereIn('id', $arr_ids)
            ->update([
                'status' => $request->status
            ]);
        return redirect()->back()->with('success', 'Status successfully changed');
//            } else {
//                return redirect()->back()->with('error', 'Wrong Status');
//            }

    }

    public function delete(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'id' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 0,
                'message' => 'Field id is required'
            ]);
        }

        Salary::where('id', $request->id)->delete();
        return [
            'status' => 1
        ];
    }


}
