<?php

namespace App\Http\Controllers;

use App\Http\Requests\Salaries\StoreRequest;
use App\Http\Requests\Salaries\UpdateRequest;
use App\Models\Employee;
use App\Models\BanksOrMobiles;
use App\Models\PaymentMethods;
use App\Models\Payments;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Datatables;
use DB;
use PDF;
class SalariesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(){

        Session::put('itemArray', []);
        $employees = Employee::get();

        $saleTotalAll = array();

        //SET Total by pm
        $data = [
            'saleTotalAll' => array_sum($saleTotalAll),
            'employees' => $employees
            ];

        return view('seller.salaries.index', $data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        Session::put('itemArray', []);

        $sellerId = Auth::user()->id;

        $employees = Employee::all();
        if(Auth::user()->role == 'staff'):
            $employees = Employee::all();
        endif;
        //Generate a timestamp using mt_rand.
        $timestamp = mt_rand(1, time());

        $data = [
            'timestamp' => $timestamp,
            'banks_or_mobiles' => BanksOrMobiles::all(),
            'payment_methods' => PaymentMethods::all(),
            'employees' =>  $employees,
        ];

        return view('seller.salaries.create', $data);
    }

    /**
     * Store `sale` data
     *
     * @param  \App\Http\Requests\Sales\StoreRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreRequest $request)
    {


        try {
            $payment = new Payments();

            $payment->payment_date = $request->payment_date ? date('Y-m-d', strtotime($request->payment_date)) : NULL ;
            $payment->purchase_id = 0;
            $payment->type = 'salary';
            $payment->employee_id = $request->employee_id;
            $payment->amount = $request->amount ?? 0;
            $payment->paid = $request->paid ?? 0;
            $payment->payment_method_id = $request->payment_method_id ?? '';
            $payment->bank_or_mobile_wallet_id = $request->bank_or_mobile_wallet_id ?? '';
            $payment->account_no_id = $request->account_no_id ?? '';
            $payment->notes = $request->notes;
            $payment->user_id = Auth::user()->id;
            $payment->save();
           // dd($payment);


            return response()->json([
                'message' => 'Payment created successfully'
            ]);

        } catch (\Exception $th) {
            report($th);

            return response()->json([
                'message' => 'Something went wrong. ' . $th->getMessage()
            ], 500);
        }
    }





    /**
     * Update the `sale` data
     *
     * @param  \App\Http\Requests\Sales\UpdateRequest $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateRequest $request, $id)
    {

        try {

            $payment = Payments::find($id);


            $payment->payment_date = $request->payment_date ? date('Y-m-d', strtotime($request->payment_date)) : NULL ;
            $payment->purchase_id = 0;
            $payment->type = $request->type;
            $payment->employee_id = $request->employee_id;
            $payment->amount = $request->amount ?? 0;
            $payment->paid = $request->paid ?? 0;
            $payment->payment_method_id = $request->payment_method_id ?? '';
            $payment->bank_or_mobile_wallet_id = $request->bank_or_mobile_wallet_id ?? '';
            $payment->account_no_id = $request->account_no_id ?? '';
            $payment->notes = $request->notes;
            $payment->user_id = Auth::user()->id;
            $payment->save();

            return response()->json([
                'message' => 'Payment Updated Successfully'
            ]);

        } catch (\Exception $th) {
            report($th);

            return response()->json([
                'message' => 'Something happened wrong ' . $th->getMessage()
            ], 500);
        }
    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $sellerId = Auth::user()->id;

        $payment = Payments::find($id);

       // dd($payment);
        abort_if(!$payment, 404);

        $employees = Employee::all();
        if(Auth::user()->role == 'staff'):
            $employees = Employee::all();
        endif;
        //Generate a timestamp using mt_rand.
        $timestamp = mt_rand(1, time());

        $data = [
            'payment' => $payment,
            'banks_or_mobiles' => BanksOrMobiles::all(),
            'payment_methods' => PaymentMethods::all(),
            'employees' =>  $employees,
        ];

        return view('seller.salaries.edit', $data);
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {

    }
    public function paymentDelete(Request $request)
    {


        $payment = Payments::find($request->id);
        $payment->delete();
        return [
        'status' => 1
        ];
    }


    /**
     * Handle datatable serverside
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function data(Request $request)
    {
        if ($request->ajax()) {
            $data = [];
            $start = $request->get('start', 0);
            $limit = $request->get('length', 10);
            if ($limit < 1 OR $limit > 100) {
                $limit = 100;
            }

            if($request->get('employee_name')){
                $search = $request->get('employee_name');
            }else{
                $search = isset($request->get('search')['value'])
                    ? $request->get('search')['value']
                    : null;
            }

            $orderColumnList = [
                'id',
                'payment_date',
                'employee_name',
                'paid',
            ];

            $employee_id = $request->get('employee_id', '');
            
      
        
            $start_date = $request->get('start_date') != null ? date('Y-m-d', strtotime($request->get('start_date'))) : '';
            $end_date = $request->get('end_date') != null ? date('Y-m-d', strtotime($request->get('end_date'))) : '';
 


            $orderColumnIndex = isset($request->get('order')[0]['column'])
                                ? $request->get('order')[0]['column']
                                : 0;

            $orderColumnList = [
                'payments.id',
                'payment_date',
                'paid',
            ];

            $orderColumnIndex = isset($request->get('order')[0]['column'])
                                ? $request->get('order')[0]['column']
                                : 0;
            $orderColumnDir = isset($request->get('order')[0]['dir'])
                                ? $request->get('order')[0]['dir']
                                : 'desc';
            $orderColumnDir = 'desc';

            $orderColumn = isset($orderColumnList[$orderColumnIndex])
                            ? $orderColumnList[$orderColumnIndex]
                            : 'id';

            $payment_methodFilter = $request->get("pm");
            $employeeId = $request->get('employeeId', 0);
            $start_date = $request->start_date != null ? date('Y-m-d', strtotime($request->start_date)) : '';
            $end_date = $request->end_date != null ? date('Y-m-d', strtotime($request->end_date)) : '';

            $payments = Payments::query()->searchTable($search)
            ->with(['employee' => function ($query) {
                $query->whereNotNull('employees.id');
            }])
            ->with('payment_method')
            ->with('mobileOrBank')
            ->with('account')
            ->when(!empty($start_date) && !empty($end_date), function ($query) use ($start_date, $end_date) {
                $query->whereBetween('payments.payment_date', [$start_date, $end_date]);
            })
            ->when(!empty($employee_id), function ($query) use ($employee_id) {
                $query->where('payments.employee_id', $employee_id);
            })
            ->where('payments.type', 'salary')
                    ->orderBy($orderColumn, $orderColumnDir)
                    ->take($limit)
                    ->skip($start)
                    ->get();



            $table = Datatables::of($payments)
                ->addColumn('date', function ($row) {
                    return $row->payment_date;
                })

                ->addColumn('employee_name', function ($row) {
                    return $row->employee->employee_name;
                })

                ->addColumn('payment_method_id', function ($row) {

                    if ($row->id) {
                       return $row->payment_method->name;
                    }
                })

                ->addColumn('total', function ($row) {


                        $details = '
                        <span class="whitespace-nowrap cursor-pointer hover:text-blue-500">
                            <strong>'. number_format($row->paid,2) .'</strong>
                        </span><br>
                    ';
                        return $details ;

                })


                ->addColumn('action', function ($row) {
                    return '
                    <a href="'. route('salary.edit', [ 'id' => $row->id ]) .'"
                        class="btn-action--yellow">
                        &nbsp;<i class="fas fa-pencil-alt"></i>&nbsp;
                    </a>
                    <button type="button"
                        class="btn-action--red"
                        id="BtnDelete"
                        data-id="' . $row->id . '">
                        <i class="fas fa-trash-alt"></i>
                    </button>
                ';
                })
                ->rawColumns(['date','employee_name','total','details','action'])
                ->skipPaging()
                ->make(true);

            return $table;

        }
    }


    /**
     * This will return data into PO Edit Page >> Shipment Details Tab
     * Page URL : .... sale/{id}/edit
     * @return mixed
     */


    public function ShowShipmentTableOnPOeditPage(Request $request)
    {
        if ($request->ajax()) {
            $sellerId = Auth::user()->id;
            $receiverId = $request->get('receiverId', 0);
            $purchase_id = $request->get('purchase_id', 0);
            return $data = PoShipment::poShipmentDetailsBySalesID($purchase_id,$sellerId);
        }
    }


    public function poShipmentEdit(Request $request)
    {

        $poShipment = PoShipment::poShipmentDetailsByID($request->id,Auth::user()->id);
        return $poShipment[0];

    }

    public function poShipmentDelete(Request $request)
    {
        // Delete PO Shipment By po shipment ID
        $poShipment = PoShipment::deleteByID($request->id);

        // Delete PO Shipment Details  By po shipment ID
        PoShipmentDetail::deleteByPoShipmentID($request->id);

        return [
        'pm' => 1
        ];
    }





}
