<?php

namespace App\Http\Controllers;

use App\Models\ActivityLog;
use App\Http\Resources\RawMaterialTypeAheadResource;
use App\Models\Permission;
use App\Models\User;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use App\Http\Requests\RmStock\{RmStockStoreRequest, RmStockUpdateRequest};
use App\Imports\BulkImport;
use App\Models\RawMaterial;
use App\Models\OrderManagement;
use App\Models\ProductMainStock;
use App\Models\Shop;
use App\Models\RmStockLog;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Datatables;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Maatwebsite\Excel\Facades\Excel;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Str;

use App\Exports\OrderAnalysisExport;


class RmStockController extends Controller
{
    public function rMstocks()
    {

        $raw_materials =  RawMaterialTypeAheadResource::collection(RawMaterial::get());
        $shop = Shop::where('id', Auth::user()->shop_id)->first();
        $stockCount = RmStockLog::count();
        $prouctionUnits = Shop::get();
        return view('seller.rm-stocks.index', compact('raw_materials','shop', 'stockCount','prouctionUnits'));
    }



    public function data(Request $request)
    {
        if ($request->ajax()){
            
            if (isset($request->id) && $request->id != null) {
               
                $rmStock = RmStockLog::with(['raw_material' => function ($query) {
                    //$query->quantity();  // This applies the scopeQuantity method to the product
                }])->findOrFail($request->id);
                $shop = Shop::where('id', Auth::user()->shop_id)->first();    
                $raw_materials =  RawMaterial::get();;
                
                $data = [
                    'rmStock' => $rmStock,   
                    'raw_materials' => RawMaterialTypeAheadResource::collection($raw_materials),                 
                    'prouctionUnits' => Shop::get()
                ];

                return view('seller.rm-stocks.form-edit-modal-rm-stock', $data);
            }

            $product_name = $request->get('product_name', '');
            $unitId = $request->get('unitId', '');
            $statusId = $request->get('statusId', '-1');


            $start = $request->get('start', 0);
            $limit = $request->get('length', 10);
            if ($limit < 1 OR $limit > 100) {
                $limit = 100;
            }

            $search = isset($request->get('search')['value'])
                    ? $request->get('search')['value']
                    : null;

            $orderColumnList = [
                'rm_stock_logs.id',
                'shop_id',
                'quantity',
            ];

            $orderColumnIndex = isset($request->get('order')[0]['column'])
                                ? $request->get('order')[0]['column']
                                : 0;
            $orderColumnDir = isset($request->get('order')[0]['dir'])
                                ? $request->get('order')[0]['dir']
                                : 'desc';
            $orderColumnDir = 'desc';

            $orderColumn = $orderColumnList[$orderColumnIndex] ?? 'raw_material_id';

            $userRole = 'member';
            $userId = Auth::id();
            
            $data = RmStockLog::searchTable($search)
                    ->filterByShop($unitId)
                    ->filterByStockStatus($statusId)
                    ->with('raw_material')
                    ->with('shop')
                    ->orderBy($orderColumn, $orderColumnDir)
                    ->take($limit)
                    ->skip($start)
                    ->get();
            
            $totalData = RmStockLog::searchTable($search)
                        ->filterByShop($unitId)
                        ->filterByStockStatus($statusId)
                        ->with('raw_material')
                        ->with('shop')
                        ->count();


            $table = Datatables::of($data)
            
           
                ->addColumn('id', function ($row) {                  
                    return $row->id;
                })

                ->addColumn('stock_date', function ($row) {                    
                    return date('Y-m-d', strtotime($row->stock_date));
                })
                
                ->addColumn('unit_details', function ($row) {
                    $details = '<p class="m-0">';
              
                    if($row->shop){
                        $details .= '<span style="white-space:nowrap">' . $row->shop->name . "</span>";
                    }
                        
                    if($row->shop){
                        $details .= ' (<span style="white-space:nowrap">' . $row->shop->location . "</span>)";
                    }
                        

                    $details .= '</p>';
                    return $details;
                })

                ->addColumn('product_name', function ($row) {
                    $details = '';
                     if($row->raw_material){
                         $details .= '<p class="m-0"><span style="white-space:nowrap">' . $row->raw_material->name . "</span></p>";
                     }
                        
                    return $details;
                })

                ->addColumn('quantity', function ($row) {                    
                    return $row->quantity;
                })
                ->addColumn('status', function ($row) {   
                    
                    if($row->stock_status==RmStockLog::CHECK_IN_OUT_ADD){
                        return '
                        <div class="text-center">
                            <div class="text-xs inline-flex font-medium bg-green-500/20 text-green-700 rounded-full text-center px-2.5 py-1">In</div>
                        </div>
                        ';
                    }

                    if($row->stock_status==RmStockLog::CHECK_IN_OUT_REMOVE){
                        return '
                        <div class="text-center">
                            <div class="text-xs inline-flex font-medium bg-red-500/20 text-red-700 rounded-full text-center px-2.5 py-1">Out</div>
                        </div>
                        ';
                    }

                    if($row->stock_status==RmStockLog::CHECK_IN_OUT_DEFECT){
                        return '
                        <div class="text-center">
                            <div class="text-xs inline-flex font-medium bg-yellow-500/20 text-yellow-700 rounded-full text-center px-2.5 py-1">Defect</div>
                        </div>
                        ';
                    }
                    
                })

                ->addColumn('actions', function ($row) {
                    $actionContent = '';
                    
                    $actionContent = '
                    <div class="w-full text-center">
                        <div class="flex flex-wrap items-center -m-1.5">
                            <div class="m-1.5">
                                <!-- Start -->
                                <button id="BtnEditProduct" data-id="'.$row->id.'" class="btn bg-white dark:bg-gray-800 border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600">
                                    <svg class="fill-current text-gray-400 dark:text-gray-500 shrink-0" width="16" height="16" viewBox="0 0 16 16">
                                        <path d="M11.7.3c-.4-.4-1-.4-1.4 0l-10 10c-.2.2-.3.4-.3.7v4c0 .6.4 1 1 1h4c.3 0 .5-.1.7-.3l10-10c.4-.4.4-1 0-1.4l-4-4zM4.6 14H2v-2.6l6-6L10.6 8l-6 6zM12 6.6L9.4 4 11 2.4 13.6 5 12 6.6z"></path>
                                    </svg>
                                </button>
                                <!-- End -->
                            </div>
                            <div class="m-1.5">
                                <!-- Start -->
                                <button id="BtnDeleteProduct" data-id="'.$row->id.'" class="btn bg-white dark:bg-gray-800 border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600">
                                    <svg class="fill-current text-red-500 shrink-0" width="16" height="16" viewBox="0 0 16 16">
                                        <path d="M5 7h2v6H5V7zm4 0h2v6H9V7zm3-6v2h4v2h-1v10c0 .6-.4 1-1 1H2c-.6 0-1-.4-1-1V5H0V3h4V1c0-.6.4-1 1-1h6c.6 0 1 .4 1 1zM6 2v1h4V2H6zm7 3H3v9h10V5z"></path>
                                    </svg>
                                </button>
                                <!-- End -->
                            </div>
                        </div>                       
                    </div>
                    ';
                   
                    return $actionContent;
                })
                ->rawColumns(['unit_details','product_name','status','actions'])
                ->skipPaging()
                ->setTotalRecords($totalData)
                ->make(true);

            return $table;
        }
    }



    function loadInsertForm(Request $request){
        $raw_materials =  RawMaterial::get();
        $data = [
            'raw_materials' => RawMaterialTypeAheadResource::collection($raw_materials),
            'prouctionUnits' => Shop::get()
        ];
        return view('seller.rm-stocks.form-insert-modal-rm-stock',$data);
    }

    /**
     * Store new stock
     *
     * @param RmStockStoreRequest $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function insert(RmStockStoreRequest $request)
    {
        try {
            if(Session::has('stock_log_data')){
                $stock = Session::forget('stock_log_data');
            }

          
            $isInsert = 0 ;        
            foreach($request->raw_material_id as $key => $raw_material_id ) {
                if (!is_null($raw_material_id)) { 
                    
                    $rmStockLogs = new RmStockLog();                              

                    $rmStockLogs->stock_date = date('Y-m-d', strtotime($request->stock_date));
                    $rmStockLogs->shop_id = $request->shop_id;
                    $rmStockLogs->raw_material_id = $raw_material_id;
                    $rmStockLogs->quantity = $request->quantity[$key] ? $request->quantity[$key] : 0;
                    $rmStockLogs->seller_id = Auth::user()->id;
                    $rmStockLogs->created_at = date('Y-m-d');  
                    $rmStockLogs->stock_status = $request->stock_status;                   
                    $rmStockLogs->is_defect = ($request->stock_status==2) ? 1 : 0;                   
                    $rmStockLogs->defect_note = ($request->stock_status==2) ? $request->defect_note : ''; 
                       
                    $rmStockLogs->save();
                    ActivityLog::updateProductActivityLog('Create new stock ', $rmStockLogs->id);
                    $isInsert = 1 ;     
                }
            }
            
            if($isInsert){
                return response()->json([
                    'status' => 1,
                    'message' => '<span class="flex space-x-4 text-green-600">Stock created successfully</span>'
                ]);
            }

        } catch (\Throwable $th) {
            report($th);

            return redirect()->back()
                    ->with('error', $th->getMessage())
                    ->withInput();
        }
    }

    /**
     * Update the stock data
     *
     * @param RmStockUpdateRequest $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function update(RmStockUpdateRequest $request)
    {
        try {
            if(Session::has('stock_log_data')){
                Session::forget('stock_log_data');
            }
            RmStockLog::where('id', '=', $request->id)->delete();
            $isUpdate = 0 ;     
            
            
            foreach($request->raw_material_id as $key => $raw_material_id ) {
                if (isset($raw_material_id)) {   
                    $rmStockLogs = new RmStockLog();
                    $rmStockLogs->shop_id = Auth::user()->shop_id;
                    $rmStockLogs->stock_date = date('Y-m-d', strtotime($request->stock_date));
                    $rmStockLogs->shop_id = $request->shop_id ? $request->shop_id : 0;
                    $rmStockLogs->raw_material_id = $raw_material_id;
                    $rmStockLogs->quantity = $request->quantity[$key] ? $request->quantity[$key] : 0;
                    $rmStockLogs->seller_id = Auth::user()->id;
                    $rmStockLogs->created_at = date('Y-m-d');  
                    $rmStockLogs->stock_status = $request->stock_status;                   
                    $rmStockLogs->is_defect = ($request->stock_status==2) ? 1 : 0;                   
                    $rmStockLogs->defect_note = ($request->stock_status==2) ? $request->defect_note : '';                  
                    $rmStockLogs->save();
                    ActivityLog::updateProductActivityLog('Update Stock ', $rmStockLogs->id);
                    $isUpdate = 1 ;     
                }
            }
            if($isUpdate){
                return response()->json([
                    'status' => 1,
                    'message' => '<span class="flex space-x-4 text-green-600">Stock updated successfully</span>'
                ]);
            }
            else{
                return redirect()->back()->with('danger','Something happened wrong');
            }


        } catch (\Throwable $th) {
            report($th);
            return $this->apiResponse(500, "Something went wrong. {$th->getMessage()}");
        }
    }


    
    function loadDeleteForm(Request $request){

        $stockLog = RmStockLog::with('raw_material')->where('id',$request->id)->first();
       
        abort_if(!$stockLog, 404);

        $data = [
            'stockLog' => $stockLog           
        ];

        return view('seller.rm-stocks.form-delete-modal-rm-stock', $data);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete(Request $request){
        
        $validator = Validator::make($request->all(), [
            'id' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 0,
                'message' => '<span class="pt-5 px-5 flex space-x-4 text-red-500">Field id is required</span>'
            ]);
        } else {

            if(session::has('stock_log_data')){
                session::forget('stock_log_data');
            }

            RmStockLog::where('id', '=', $request->id)->delete();

            ActivityLog::updateProductActivityLog('Delete stock', $request->id);
                        
            return [
                'status' => 1,
                'message' => '<span class="pt-5 px-5 flex space-x-4 text-green-600">Stock is deleted successfully.</span>'
            ];
        }
    }

        /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function bulkDelete(Request $request){
        
        $validator = Validator::make($request->all(), [
            'bulk_ids' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 0,
                'message' => '<span class="pt-5 px-5 flex space-x-4 text-red-500">Field id is required</span>'
            ]);
        } else {

            if(session::has('stock_log_data')){
                session::forget('stock_log_data');
            }
            $isBulkDelete = false;
            $arrBulkIds = explode(",",$request->bulk_ids);
            foreach($arrBulkIds as $id){
                RmStockLog::where('id', '=', $id)->delete();
                $isBulkDelete = true;
            }

            
            if($isBulkDelete){
                ActivityLog::updateProductActivityLog('Bulk Delete stock',count($arrBulkIds));
            }
            
                        
            return [
                'status' => 1,
                'message' => '<span class="pt-5 px-5 flex space-x-4 text-green-600">Stock is deleted successfully.</span>'
            ];
        }
    }

    

}