<?php

namespace App\Http\Controllers;

use App\Http\Requests\Student\StoreRequest;
use App\Http\Requests\Student\UpdateRequest;
use App\Http\Resources\ProductTypeAheadResource;
use App\Models\Student;
use App\Models\Exams;
use App\Models\Classes;
use App\Models\Sections;
use App\Models\Groups;
use App\Models\Sessions;
use App\Models\Subjects;
use App\Models\MarkTypes;
use App\Models\Marks;
use App\Models\CurrentAcadmicStatus;
use App\Models\Remarks;
use App\Models\Settings;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Datatables;
use DB;
use PDF;
class ResultController extends Controller
{
    public $exam_name = [];
    public $merit_details = [];
    public $merit_list = [];
    public $exam_id = 0;

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        $arr_param['personId'] = Auth::user()->id;
        Session::put('itemArray', []);



        $data = [
            'exams' => Exams::orderBy('position', 'ASC')->get(),
            'classes' => Classes::get(),
            'sections' => Sections::get(),
            'sessions' => Sessions::orderBy('id', 'DESC')->get()
        ];

        return view('results.index', $data);
    }


    /**
     * Handle datatable serverside
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function data(Request $request)
    {
        if ($request->ajax()) {
            $examId = $request->get('examId', '');
            $classId = $request->get('classId', '');
            $sectionId = $request->get('sectionId', array());
            $sessionId = $request->get('sessionId', '');

            $exam = Exams::where('id', $examId)->select('exam_name')->first();
            $this->exam_name = isset($exam->exam_name) ? $exam->exam_name : '';


            $total_subjects = '';
            $arr['exam_id'] = $examId;
            $arr['session_id'] = $sessionId;
            $arr['class_id'] = $classId;
            $arr['section_id'] = $sectionId;
            $arr['type'] = 'all';
            $arr['total_subjects'] = $total_subjects;
            $arr_student_ids = array();

            $students = CurrentAcadmicStatus::getStudents($arr,$arr_student_ids,$is_required_marks=true);

              // MERIT LIST GENERATOR BY SECTION
              if($students){
                /* return array() */
                $this->merit_details =  Marks::getMarksGPADetails($students);
                // Add column to each collection row
                $students->map(function ($table) {
                    $table->merit_details = $this->merit_details;
                    return $table;
                });
            }

           // dd($students);
            $table = Datatables::of($students)
                ->addColumn('id', function ($row) {
                    return $row->student_id;
                })
                ->addColumn('checkbox', function ($row) {
                    return "<input type='checkbox' name='checkbox' class='checkbox' data-id='" . $row->id . "'>";
                })
                ->addColumn('details', function ($row) {
                    //  dd($row);
                    $student_id = isset($row->student_details->id) ? $row->student_details->id : '';

                    if ($row->student_details->profile_photo) {
                        $profile_photo = asset('uploads/students/' . $row->student_details->profile_photo);
                    } else {
                        $profile_photo = '/No-Image-Found.png';
                    }

                    return '
                             <div class="flex flex-row gap-4" id="__productDiv_3934">
                                <div class="w-1/2 sm:w-full md:w-fulllg:w-full">
                                    <div class="mb-3">
                                        <img src="' . $profile_photo . '" style="width:100px !important" class="w-full h-auto">
                                    </div>
                                </div>
                            </div>

                    ';
                })

                ->addColumn('name', function ($row) {
                    return $row->student_details->name;
                })

                ->addColumn('student_code', function ($row) {
                    return $row->student_details->student_code;
                })

                ->addColumn('roll_no', function ($row) {
                    if ($row->student_details->roll_no) {
                        return $row->student_details->roll_no;
                    } else {
                        return '<p class="hidden">99999</p>';
                    }

                })

                ->addColumn('class_name', function ($row) {
                    return $row->class->class_name;
                })

                ->addColumn('section_name', function ($row) {
                    return $row->section->section_name;
                })

                ->addColumn('session_name', function ($row) {
                    return $row->session->session_name;
                })

                ->addColumn('academic_result', function ($row) {
                    $merit_details = $row->merit_details;
                    $student_id = $row->student_details->id;
                    $total_subjects = $merit_details['total_subjects'];

                    if(!isset($merit_details['arr_per_student_total_gp'][$student_id])) return null;

                    $totalGP = $merit_details['arr_per_student_total_gp'][$student_id];
                    $totalMarks = $merit_details['arr_per_student_student_marks_total'][$student_id];

                    if(!empty($totalGP) && ($total_subjects > 0) ){
                        $GPA = $totalGP/$total_subjects;
                    }else{
                        $GPA = '0.00';
                    }

                    $GPA = number_format((float)$GPA, 2, '.', '');
                    $letter_grade_by_total_gpa = Marks::PerSubjectLetterGradeGeneratorByGPA($GPA);

                    return '
                    <span class="whitespace-nowrap cursor-pointer hover:text-blue-500">
                        Exam : <strong> '.$this->exam_name.' </strong>
                    </span><br>
                    <span class="whitespace-nowrap cursor-pointer hover:text-blue-500">
                        Total Subjects : <strong> '. $total_subjects .' </strong>
                    </span><br>

                    <span class="whitespace-nowrap cursor-pointer hover:text-blue-500">
                        Total Marks : <strong> '. $totalMarks .' </strong>
                    </span><br>
                    <span class="whitespace-nowrap cursor-pointer hover:text-blue-500">
                        GPA : <strong> '. $GPA.'('.$letter_grade_by_total_gpa.') </strong>
                    </span><br>
                    <span data-exam_id="1" data-session_id="'.$row->session_id.'" data-class_id="'.$row->class_id.'" data-student_id="'.$student_id.'" class ="exportMarkSheet badge-status--yellow my-2 whitespace-nowrap cursor-pointer">View Marksheet</span>
                    <br>';

                })


                ->addColumn('status', function ($row) {

                    $merit_details = $row->merit_details;
                    $student_id = $row->student_details->id;
                    $total_subjects = $merit_details['total_subjects'];
                    if(!isset($merit_details['arr_per_student_total_gp'][$student_id])) return null;
                    $totalGP = $merit_details['arr_per_student_total_gp'][$student_id];

                    if(!empty($totalGP) && ($total_subjects > 0) ){
                        $GPA = $totalGP/$total_subjects;
                    }else{
                        $GPA = 0;
                    }

                    if ($GPA > 1) {
                        $status = '<span class ="badge-status--green my-2 whitespace-nowrap cursor-pointer">Passed</span>';
                    }else{
                        $status = '<span class ="badge-status--red my-2 whitespace-nowrap cursor-pointer">Failed</span>';
                    }
                    return $status;
                })

                ->addColumn('action', function ($row) {

                    $student_id = isset($row->student_details->id) ? $row->student_details->id : '';


                    return '<div class="w-full text-center">
                    <button data-student_id='.$student_id.' class="btnPrintSingleMarkSheet btn-action--green" title="Print MarkSheet">
                        <i class="fas fa-print"></i>
                    </button>
                </div>';

                })

                ->rawColumns(['checkbox','details','roll_no', 'academic_result', 'status', 'action'])
                ->skipPaging()
                ->make(true);
            return $table;
        }
    }



/**
     * Handle the `print mark sheet as pdf` datatable
     * Serverside Datatable
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     *
     */
    public function printMarkSheet(Request $request)
    {
        $validator = $request->validate([
            'class_id' => 'required|string',
            'session_id' => 'required|string',
            'total_subjects' => 'required|string',
        ]);

        $exam_id = $request->exam_id;
        $session_id = $request->session_id;
        $class_id = $request->class_id;
        $section_id = $request->section_id ? $request->section_id : '';
        $arr_student_ids = isset($request->student_ids) ? explode(",",$request->student_ids) : array();
        $total_subjects = $request->total_subjects;

        //dd($section_id);
        $arr['exam_id'] = $exam_id;
        $arr['session_id'] = $session_id;
        $arr['class_id'] = $class_id;
        $arr['section_id'] = $section_id;
        $arr['total_subjects'] = $total_subjects;





        // MERIT LIST GENERATOR BY CLASS
        unset($arr['section_id']);
        //send empty array for $arr_student_ids to get all students of a class
        $students_list_by_class = CurrentAcadmicStatus::getStudents($arr,array(),$is_required_marks=true);
        $merit_list_by_class = Marks::getMeritList($students_list_by_class);

        // MERIT LIST GENERATOR BY SECTION
        $arr['section_id'] = $section_id;
        //send empty array for $arr_student_ids to get all students of a sections
        $students_list_by_section = CurrentAcadmicStatus::getStudents($arr,array(),$is_required_marks=true);
        $merit_list_by_section = Marks::getMeritList($students_list_by_section);

        //dd($arr_student_ids);
        if(!empty($arr_student_ids)){
            $students = CurrentAcadmicStatus::getStudents($arr,$arr_student_ids,$is_required_marks=true);
        }else{
            $students = isset($section_id)  ? $students_list_by_section : $students_list_by_class;
        }


        $currentSession =  isset($students[0]->session->session_name) ? $students[0]->session->session_name : 0 ;
        $currentClass =  isset($students[0]->class->class_name) ? $students[0]->class->class_name : 0 ;
        $currentSection =   isset($students[0]->section->section_name) ? $students[0]->section->section_name : 0 ;
        $remarks = Remarks::get();
        $arr_gpa_remarks = array();
        if(!empty($remarks)){
            foreach($remarks as $remark){
                $arr_gpa_remarks[$remark->gpa] = $remark->remark;
            }
        }

        $data = [
            'school_info' => Settings::first(),
            'exam' => Exams::where('id',$exam_id)->first(),
            'mark_types' => $this->markTypeArray(),
            'merit_list_by_class' => $merit_list_by_class,
            'merit_list_by_section' => $merit_list_by_section,
            'studentWithMarks' => $students,
            'total_subjects' => $total_subjects,
            'subjects_id_name_Arr' => $this->subjectIdNameArray(),
            'arr_gpa_remarks' => $arr_gpa_remarks,
        ];

        $customPaper = array(0,0,60.00,50.80);

        $width= '600';
        $height = '1200';

        $file_name = "Mark-sheet";

        $pdf = PDF::loadView('results.view_mark_sheet',$data)
        ->setOptions(['defaultFont' => 'Courier'])
        ->setOptions(
            ['isHtml5ParserEnabled' => true,
            'enable_remote' => true,
            'chroot'  => public_path(),
        ])
        ->setPaper('A4', 'portrait');


        $time = strtotime("today");
        if(!empty($studentWithMarks)){
            $file_name = $file_name.'-'.$currentClass.'-'.$currentSection.'-'.$currentSession.'-'.$time.'.pdf';
        }

        $path = public_path('pdf');
        $pdf->save($path . '/' . $file_name);
        $download_link = asset('pdf').'/'.$file_name;
        return response()->json([
            'message'=>'Marksheet Created Successfully, Please click to <a href="'.$download_link.'" target="_blank">View</a> Or <a href="'.$download_link.'" download>Download Now</a>'
        ]);
    }




    public function getMeritList()
    {

        $data = [
            'exams' => Exams::orderBy('position', 'ASC')->get(),
            'classes' => Classes::get(),
            'sections' => Sections::get(),
            'sessions' => Sessions::orderBy('id', 'DESC')->get()
        ];

        return view('results.merit_list', $data);
    }

        /**
     * Handle datatable serverside
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function dataMeritList(Request $request)
    {
        if ($request->ajax()) {
            $examId = $request->get('examId', '');
            $classId = $request->get('classId', '');
            $sectionId = $request->get('sectionId', array());
            $sessionId = $request->get('sessionId', '');
            $subjectId = $request->get('subjectId', '');
            $markTypes = $request->get('markTypes', array());

            $exam = Exams::where('id', $examId)->select('exam_name')->first();
            $this->exam_name = isset($exam->exam_name) ? $exam->exam_name : '';
            $this->exam_id = $examId;
            $offset = $request->get('start', 0);
            $limit = $request->get('length', 10);
            if ($limit < 1 OR $limit > 100) {
                $limit = 100;
            }

            $search = isset($request->get('search')['value'])
                    ? $request->get('search')['value']
                    : null;

            $orderColumnList = [
                'roll_no',
                'id',
                 '',
                'name',
                'roll_no',
                'section_name'
            ];

            $orderColumnIndex = isset($request->get('order')[0]['column'])
                                ? $request->get('order')[0]['column']
                                : 0;
            $orderColumnDir = isset($request->get('order')[0]['dir'])
                                ? $request->get('order')[0]['dir']
                                : 'asc';

            $orderColumn = isset($orderColumnList[$orderColumnIndex])
                            ? $orderColumnList[$orderColumnIndex]
                            : 'name';

            $otherReportParams = [
                'search' => $search,
                'limit' => $limit,
                'offset' => $offset,
                'order_column' => $orderColumn,
                'order_dir' => $orderColumnDir,
                'class_id' => $classId
            ];


            $studentByClass = CurrentAcadmicStatus::with('student_details')
            ->with('class')
            ->with('section')
            ->with('session')
            ->with('group')
            ->with(['MarksDetails' => function ($query)  use ($examId,$classId,$sessionId) {
                $query->where('exam_id',$examId);
                $query->where('class_id', $classId);
                $query->where('session_id',$sessionId);
            }])
            ->where('current_academic_status.class_id',$classId)
            ->where('current_academic_status.session_id',$sessionId)
            ->get();

            $students = $studentByClass;

            if($sectionId){
                $studentBySection = CurrentAcadmicStatus::with('student_details')
                ->with('class')
                ->with('section')
                ->with('session')
                ->with('group')
                ->with(['MarksDetails' => function ($query)  use ($examId,$classId,$sectionId,$sessionId) {
                    $query->where('exam_id',$examId);
                    $query->where('class_id', $classId);
                    $query->where('section_id', $sectionId);
                    $query->where('session_id',$sessionId);
                }])
                ->where('current_academic_status.class_id',$classId)
                ->where('current_academic_status.section_id',$sectionId)
                ->where('current_academic_status.session_id',$sessionId)
                ->get();

                $students = $studentBySection;



            }

            // MERIT LIST GENERATOR BY SECTION
            if($students){
                $this->merit_list =  Marks::getMeritList($students);
                // Add column to each collection row
                $students->map(function ($table) {
                    $table->merit_list = $this->merit_list;
                    return $table;
                });
            }

            $table = Datatables::of($students)

                ->addColumn('details', function ($row) {
                    if ($row->student_details->profile_photo) {
                        $profile_photo = asset('uploads/students/' . $row->student_details->profile_photo);
                    } else {
                        $profile_photo = '/No-Image-Found.png';
                    }

                    return '
                             <div class="flex flex-row gap-4" id="__productDiv_3934">
                                <div class="w-1/2 sm:w-full md:w-fulllg:w-full">
                                    <div class="mb-3">
                                        <img src="' . $profile_photo . '" style="width:100px !important" class="w-full h-auto">
                                    </div>
                                </div>
                            </div>

                    ';
                })

                ->addColumn('name', function ($row) {
                    return $row->student_details->name;
                })

                ->addColumn('student_code', function ($row) {
                    return $row->student_details->student_code;
                })

                ->addColumn('roll_no', function ($row) {
                    return $row->student_details->roll_no;
                })

                ->addColumn('class_name', function ($row) {
                    return $row->class->class_name;
                })

                ->addColumn('section_name', function ($row) {
                    return $row->section->section_name;
                })

                ->addColumn('session_name', function ($row) {
                    return $row->session->session_name;
                })

                ->addColumn('academic_result', function ($row) {

                    $student_id = isset($row->student_details->id) ? $row->student_details->id : '';


                    $marksDetails = Marks::getMarkDetailsBySessionIDAndStudentID($row->session->id, $this->exam_id, $student_id);

                    $totalSubjects = count($marksDetails);
                    $arr_grade_point = array();
                    $arr_letter_grade = array();
                    $arr_marks = array();
                    foreach ($marksDetails as $mark) {
                        $arr_grade_point[] = $mark['grade_point'];
                        $arr_letter_grade[] = $mark['letter_grade'];
                        $arr_marks[] = $mark['total_obtained_marks'];
                    }
                    $totalSubjects = count($marksDetails);
                    $totalGP = array_sum($arr_grade_point);
                    $totalMarks = array_sum($arr_marks);

                    if (!empty($totalGP) && ($totalSubjects > 0)) {
                        $GPA = $totalGP / $totalSubjects;
                    } else {
                        $GPA = '0.00';
                    }

                    $GPA = number_format((float) $GPA, 2, '.', '');
                    $letter_grade_by_total_gpa = Marks::PerSubjectLetterGradeGeneratorByGPA($GPA);

                    return '
                            <span class="whitespace-nowrap cursor-pointer hover:text-blue-500">
                                Exam Name : <strong>'.$this->exam_name.' </strong>
                            </span><br>
                            <span class="whitespace-nowrap cursor-pointer hover:text-blue-500">
                                Total Subjects : <strong> ' . $totalSubjects . ' </strong>
                            </span><br>

                            <span class="whitespace-nowrap cursor-pointer hover:text-blue-500">
                                Total Marks : <strong> ' . $totalMarks . ' </strong>
                            </span><br>
                            <span class="whitespace-nowrap cursor-pointer hover:text-blue-500">
                                GPA : <strong> ' . $GPA . '(' . $letter_grade_by_total_gpa . ') </strong>
                            </span>';

                })


                ->addColumn('merit_position', function ($row) {
                    $merit_list = 99999999;
                    $student_id = isset($row->student_details->id) ? $row->student_details->id : '';
                    if(isset($row->merit_list[$student_id])){
                        $merit_list = $row->merit_list[$student_id] + 1;
                    }
                    if($merit_list == 99999999){
                        return '<p class="hidden">'.$merit_list.'</p>';
                    }else{
                        return '<p>'.$merit_list.'</p>';
                    }

                })

                ->rawColumns(['details', 'academic_result', 'merit_position'])
                ->skipPaging()
                ->make(true);
            return $table;
        }
    }


    /**
     * Handle the `download merit list as pdf` datatable
     * Serverside Datatable
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     *
     */
    public function downloadMeritList(Request $request)
    {
        $validator = $request->validate([
            'exam_id' => 'required|string',
            'class_id' => 'required|string',
            'session_id' => 'required|string',
        ]);

        $exam_id = $request->exam_id;
        $session_id = $request->session_id;
        $class_id = $request->class_id;
        $section_id = $request->section_id;



        $studentByClass = CurrentAcadmicStatus::with('student_details')
            ->with('class')
            ->with('section')
            ->with('session')
            ->with('group')
            ->with(['MarksDetails' => function ($query)  use ($exam_id,$class_id,$session_id) {
                $query->where('exam_id',$exam_id);
                $query->where('class_id', $class_id);
                $query->where('session_id',$session_id);
            }])
            ->where('current_academic_status.class_id',$class_id)
            ->where('current_academic_status.session_id',$session_id)
            ->get();

            $students = $studentByClass;



            if($section_id){
                $studentBySection = CurrentAcadmicStatus::with('student_details')
                ->with('class')
                ->with('section')
                ->with('session')
                ->with('group')
                ->with(['MarksDetails' => function ($query)  use ($exam_id,$class_id,$section_id,$session_id) {
                    $query->where('exam_id',$exam_id);
                    $query->where('class_id', $class_id);
                    $query->where('section_id', $section_id);
                    $query->where('session_id',$session_id);
                }])
                ->where('current_academic_status.class_id',$class_id)
                ->where('current_academic_status.section_id',$section_id)
                ->where('current_academic_status.session_id',$session_id)
                ->get();

                $students = $studentBySection;
            }


            // MERIT LIST GENERATOR BY SECTION
            if($students){
                /* return array() */
                $this->merit_details =  Marks::getMarksGPADetails($students);
                //$this->merit_list =  Marks::getMeritList($students);
                // Add column to each collection row
                $students->map(function ($table) {
                    $table->merit_details = $this->merit_details;
                    return $table;
                });
            }
            //dd($students);


        $currentSession =  isset($students[0]->session->session_name) ? $students[0]->session->session_name : 0 ;
        $currentClass =  isset($students[0]->class->class_name) ? $students[0]->class->class_name : 0 ;
        $currentSection =   isset($students[0]->section->section_name) ? $students[0]->section->section_name : 0 ;


        $data = [
            'school_info' => Settings::first(),
            'exam' => Exams::where('id',$exam_id)->first(),
            'mark_types' => $this->markTypeArray(),
            'students' => $students,
            'subjects_id_name_Arr' => $this->subjectIdNameArray(),
        ];

        $customPaper = array(0,0,60.00,50.80);

        $width= '600';
        $height = '1200';

        $file_name = "Merit-List";

        $pdf = PDF::loadView('results.download_merit_list',$data)
        ->setOptions(['defaultFont' => 'Courier'])
        ->setOptions(
            ['isHtml5ParserEnabled' => true,
            'enable_remote' => true,
            'chroot'  => public_path(),
        ])
        ->setPaper('A4', 'portrait');

        $time = strtotime("today");
        if(!empty($students)){
            $file_name = $file_name.'-'.$currentClass.'-'.$currentSection.'-'.$currentSession.'-'.$time.'.pdf';
        }

        $path = public_path('pdf');
        $pdf->save($path . '/' . $file_name);
        $download_link = asset('pdf').'/'.$file_name;
        return redirect()->back()->with('success','Merit List Created Successfully, Please click to <a href="'.$download_link.'" target="_blank">View</a> Or <a href="'.$download_link.'" download>Download Now</a>');
    }


    private function markTypeArray(){
        $markTypes = MarkTypes::orderBy('position', 'ASC')->get();
        if(!empty($markTypes)){
            foreach($markTypes as $item){
                $arrMark[$item->id] = strtoupper($item->type);
            }
            return $arrMark;
        }
    }

    private function subjectIdNameArray(){
        $subjects = Subjects::orderBy('name', 'ASC')->get();
        if(!empty($subjects)){
            foreach($subjects as $item){
                $arrMark[$item->id] = strtoupper($item->name);
            }
            return $arrMark;
        }
    }


}
