<?php

namespace App\Http\Controllers;

use App\Http\Resources\ProductTypeAheadResource;
use App\Models\Student;
use App\Models\Classes;
use App\Models\Sections;
use App\Models\Groups;
use App\Models\Sessions;
use App\Models\Salary;
use App\Models\CurrentAcadmicStatus;
use App\Models\DailyExpenses;
use App\Models\StudentFee;
use App\Models\Banks;
use App\Models\Json;
use App\Models\OthersCollections;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Datatables;
use DB;
use PDF;

class objPaymentMethod
{
    public $name;
    public $amount;
}


class ReportController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {


        $arr_param['personId'] = Auth::user()->id;
        Session::put('itemArray', []);

        $data = [
            'classes' => Classes::get(),
            'sections' => Sections::get(),
            'sessions' => Sessions::orderBy('id', 'DESC')->get(),
            'MonthArray' => StudentFee:: MonthArray()
        ];

        return view('reports.fee.student_fee', $data);
    }


    /**
     * Handle datatable serverside
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function data_fee_list(Request $request)
    {
        if ($request->ajax()) {
            $classId = $request->get('classId', '');
            $sectionId = $request->get('sectionId', array());
            $sessionId = $request->get('sessionId', '');
            $status = $request->get('status', 0);
            Session::put('sessionStatusDueOrPaid',$status);
            $offset = $request->get('start', 0);
            $limit = $request->get('length', 10);
            if ($limit < 1 OR $limit > 100) {
                $limit = 100;
            }

            $search = isset($request->get('search')['value'])
                    ? $request->get('search')['value']
                    : null;

            $orderColumnList = [
                'roll_no',
                'id',
                 '',
                'name',
                'roll_name',
                'section_name'
            ];

            $orderColumnIndex = isset($request->get('order')[0]['column'])
                                ? $request->get('order')[0]['column']
                                : 0;
            $orderColumnDir = isset($request->get('order')[0]['dir'])
                                ? $request->get('order')[0]['dir']
                                : 'desc';

            $orderColumn = isset($orderColumnList[$orderColumnIndex])
                            ? $orderColumnList[$orderColumnIndex]
                            : 'name';

            $otherReportParams = [
                'search' => $search,
                'limit' => $limit,
                'offset' => $offset,
                'order_column' => $orderColumn,
                'order_dir' => $orderColumnDir,
                'class_id' => $classId,
            ];

            $MonthArray = StudentFee:: MonthArray();
            $now = Carbon::now();
            $MonthArray = array_chunk($MonthArray, 6);
            $prevMonthArr = $MonthArray[0];


            $nextMonthArr = array();
            if(isset($MonthArray[1])){
                $nextMonthArr = $MonthArray[1];
            }

            $personId = Auth::user()->id;

            $studentWithFees = CurrentAcadmicStatus::with('student_details')
            ->with(['FeeDetails' => function ($query) use ($sessionId){
                $query->where('session_id',$sessionId);
                }])
                ->where('current_academic_status.class_id',$classId)
                ->where('current_academic_status.section_id',$sectionId)
                ->where('current_academic_status.session_id',$sessionId)
                ->with('session')
                ->with('class')
                ->with('section')
                ->get();



            $table = Datatables::of($studentWithFees)

            ->addColumn('roll_no', function ($row) {
                $student_id = isset($row->student_details->id) ? $row->student_details->id : '';

                $roll_no = isset($row->student_details->roll_no) ? $row->student_details->roll_no : '';
                $name = isset($row->student_details->name) ? $row->student_details->name : '';
                 return $roll_no;
             })

             ->addColumn('name', function ($row) {
                 $student_id = isset($row->student_details->id) ? $row->student_details->id : '';

                 $roll_no = isset($row->student_details->roll_no) ? $row->student_details->roll_no : '';
                 $name = isset($row->student_details->name) ? $row->student_details->name : '';
                 return $name;
              })

            ->addColumn('months', function ($row) {

                $date = Carbon::now();
                $month_key = $date->format('m');
                $month_arr = StudentFee:: MonthArray();
                $monthArrPast = [];

                foreach($month_arr as $key => $value){
                    if($key == $month_key) break;
                    $monthArrPast[$key] = $value;
                }

                $FeeDetails = $row->FeeDetails;
                $arr_paid_month = array();
                foreach($FeeDetails as $fee){
                    $arr_paid_month = array_merge($arr_paid_month, explode(",",$fee->monthly_fee_fields));
                }

                $sessionStatusDueOrPaid = Session::get('sessionStatusDueOrPaid');
                $arr_paid_only = array();
                foreach($monthArrPast as $month){
                    if($sessionStatusDueOrPaid){
                        if(in_array($month,$arr_paid_month)){
                            $arr_paid_only[] = '<span class="tag-month">'.$month.'</span>';
                        }
                    }else{
                        if(!in_array($month,$arr_paid_month)){
                            $arr_paid_only[] = '<span class="tag-month">'.$month.'</span>';
                        }
                    }
                }

                $paidMonthlyFee = implode(" ",$arr_paid_only);

                return '
                <span class="dont-break-out cursor-pointer hover:text-blue-500">
                '. $paidMonthlyFee .'
                </span>
                ';

            })

            ->addColumn('count', function ($row) {

                $date = Carbon::now();
                $month_key = $date->format('m');
                $month_arr = StudentFee:: MonthArray();
                $monthArrPast = [];

                foreach($month_arr as $key => $value){
                    if($key == $month_key) break;
                    $monthArrPast[$key] = $value;
                }

                $FeeDetails = $row->FeeDetails;
                $arr_paid_month = array();
                foreach($FeeDetails as $fee){
                    $arr_paid_month = array_merge($arr_paid_month, explode(",",$fee->monthly_fee_fields));
                }

                $sessionStatusDueOrPaid = Session::get('sessionStatusDueOrPaid');
                $arr_paid_only = array();
                foreach($monthArrPast as $month){
                    if($sessionStatusDueOrPaid){
                        if(in_array($month,$arr_paid_month)){
                            $arr_paid_only[] = '<span class="tag-month">'.$month.'</span>';
                        }
                    }else{
                        if(!in_array($month,$arr_paid_month)){
                            $arr_paid_only[] = '<span class="tag-month">'.$month.'</span>';
                        }
                    }
                }

                $count = count($arr_paid_only);


                return '<strong>'. $count .'</strong>';
            })

            ->addColumn('action', function ($row) {

                $session_id = isset($row->session_id) ? $row->session_id : '';
                $student_id = isset($row->student_details->id) ? $row->student_details->id : '';


                return '<div class="w-full text-center">
                <a href="'.'student_fee_single/'.$session_id .'/'.$student_id .'" class="btn-action--gray" title="'. __('translation.View Details') .'">
                    <i class="fas fa-arrow-circle-right"></i>
                </a>
            </div>';

            })

            ->rawColumns(['details', 'months', 'count', 'action'])
            ->skipPaging()
            ->make(true);

            return $table;
        }
    }



    public function FeeReportPDFExport(Request $request)
    {


        $classId = $request->post('classId');
        $sectionId = $request->post('sectionId');
        $sessionId = $request->post('sessionId');
        $status = $request->post('status');
        Session::put('sessionStatusDueOrPaid',$status);
        $offset = $request->get('start', 0);
        $limit = $request->get('length', 10);
        if ($limit < 1 OR $limit > 100) {
            $limit = 100;
        }

        $search = isset($request->get('search')['value'])
                ? $request->get('search')['value']
                : null;

        $orderColumnList = [
            'roll_no',
            'id',
                '',
            'name',
            'roll_name',
            'section_name'
        ];

        $orderColumnIndex = isset($request->get('order')[0]['column'])
                            ? $request->get('order')[0]['column']
                            : 0;
        $orderColumnDir = isset($request->get('order')[0]['dir'])
                            ? $request->get('order')[0]['dir']
                            : 'desc';

        $orderColumn = isset($orderColumnList[$orderColumnIndex])
                        ? $orderColumnList[$orderColumnIndex]
                        : 'name';

        $otherReportParams = [
            'search' => $search,
            'limit' => $limit,
            'offset' => $offset,
            'order_column' => $orderColumn,
            'order_dir' => $orderColumnDir,
            'class_id' => $classId,
        ];

        $MonthArray = StudentFee:: MonthArray();
        $now = Carbon::now();
        $MonthArray = array_chunk($MonthArray, 6);
        $prevMonthArr = $MonthArray[0];


        $nextMonthArr = array();
        if(isset($MonthArray[1])){
            $nextMonthArr = $MonthArray[1];
        }

        $personId = Auth::user()->id;

        $studentWithFees = CurrentAcadmicStatus::with('student_details')
        ->with(['FeeDetails' => function ($query) use ($sessionId){
            $query->where('session_id',$sessionId);
            }])
            ->where('current_academic_status.class_id',$classId)
            ->where('current_academic_status.section_id',$sectionId)
            ->where('current_academic_status.session_id',$sessionId)
            ->with('session')
            ->with('class')
            ->with('section')
            ->get();



    $customPaper = array(0,0,60.00,50.80);

    $width= '600';
    $height = '1200';

    //dd($studentWithFees);

    if($status==1){
        $page_header = "Students Fee Paid List";
        $file_name = "Paid-List";
    }else{
        $page_header = "Students Fee Due List";
        $file_name = "Due-List";
    }
    $pdf = PDF::loadView('reports.fee.generate-fee-report-pdf',compact('page_header','studentWithFees'))
    ->setOptions(['defaultFont' => 'Courier'])
    ->setOptions(['isHtml5ParserEnabled' => true, 'isRemoteEnabled' => true])
    ->setPaper('A3', 'portrait');//
    // ->setPaper(array(0,0,$width,$height));

        //         $paper_size = array(0,0,360,360);
        // $dompdf->set_paper($paper_size);

    if(!empty($studentWithFees)){
        $row = $studentWithFees[0];
        $class_name = $row->class->class_name;
        $section_name = $row->section->section_name;
        $session_name = $row->session->session_name;
        $file_name = $file_name.'-'.$class_name.'-'.$section_name.'-'.$session_name;
    }
    $time = strtotime("today");
    return $pdf->download($file_name.'.pdf');
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function transaction_report()
    {
        $arr_param['personId'] = Auth::user()->id;
        Session::put('itemArray', []);

        $data = [
            'classes' => Classes::get(),
            'sections' => Sections::get(),
            'sessions' => Sessions::orderBy('id', 'DESC')->get(),
            'MonthArray' => StudentFee:: MonthArray()
        ];

        return view('reports.transaction.index', $data);
    }


    /**
     * Handle datatable serverside
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */


    public function report_transaction_summary(Request $request)
    {
        if ($request->ajax()) {

            $now = Carbon::now()->format('m');
            $start_date = $request->get('start_date', $now);
            $end_date = $request->get('end_date', $now);
            $transaction_type = $request->get('transaction_type', '');
            Session::put('sessionTransactionType',$transaction_type);

            $studentFees = StudentFee::whereBetween('entry_date', [$start_date, $end_date])
                ->where('status','paid')
                ->groupBy('payment_method')
                ->selectRaw('payment_method, sum(paid) as total')
                ->get();

            $othersCollections = OthersCollections::whereBetween('entry_date', [$start_date, $end_date])
                ->groupBy('payment_method')
                ->selectRaw('payment_method, sum(amount) as total')
                ->get();

            $salaries = Salary::whereBetween('entry_date', [$start_date, $end_date])
                ->groupBy('payment_method')
                ->selectRaw('payment_method, sum(amount) as total')
                ->get();

            $dailyExpenses = DailyExpenses::with('expense_type')->whereBetween('entry_date', [$start_date, $end_date])
                ->groupBy('payment_method')
                ->where('status','1')
                ->selectRaw('payment_method, sum(amount) as total')
                ->get();
            $paymentMethods = [
                'cash' => 'Cash',
                'cheque' => 'Cheque',
                'mobile_banking' => 'Mobile Banking',
            ];
            $data = [
                'paymentMethods' => $paymentMethods,
                'studentFees' => $studentFees,
                'othersCollections' => $othersCollections,
                'salaries' => $salaries,
                'dailyExpenses' => $dailyExpenses
            ];

            return view('reports.transaction.summary', $data);



        }
    }



    /**
     * Handle datatable serverside
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function data_student_fee_list_pending(Request $request)
    {
        if ($request->ajax()) {
            $now = Carbon::now()->format('m');
            $start_date = $request->get('start_date', $now);
            $end_date = $request->get('end_date', $now);
            $transaction_type = $request->get('transaction_type', '');
            Session::put('sessionTransactionType',$transaction_type);

            $studentFees = StudentFee::whereBetween('entry_date', [$start_date, $end_date])
            ->where('status', 'pending')
            ->get();

            $table = Datatables::of($studentFees)

             ->addColumn('entry_date', function ($row) {
                 return $row->entry_date;
              })

            ->addColumn('id', function ($row) {
                return '
                <span class="dont-break-out cursor-pointer hover:text-blue-500">
                '. $row->id .'
                </span>
                ';
            })

            ->addColumn('payment_method', function ($row) {
                $payment_method = ucwords(str_replace('_', ' ', $row->payment_method));
                return '
                <span class="dont-break-out cursor-pointer hover:text-blue-500">
                '. $payment_method .'
                </span>
                ';
            })

            ->addColumn('entry_date', function ($row) {
                return $row->entry_date;
             })

             ->addColumn('id', function ($row) {
               return '
               <span class="dont-break-out cursor-pointer hover:text-blue-500">
               '. $row->id .'
               </span>
               ';
           })

           ->addColumn('payment_method', function ($row) {
                $payment_method = ucwords(str_replace("_"," ",$row->payment_method));
               return '
               <span class="dont-break-out cursor-pointer hover:text-blue-500">
               '. $payment_method .'
               </span>
               ';
           })

           ->addColumn('amount', function ($row) {
               return  $row->amount;
           })

           ->addColumn('discount', function ($row) {
            return  $row->discount;
            })

            ->addColumn('note', function ($row) {
                return  $row->note;
                })

            ->addColumn('paid', function ($row) {
                return  $row->paid;
                })
           ->rawColumns(['id', 'entry_date', 'payment_method','amount'])
            ->skipPaging()
            ->make(true);

            return $table;
        }
    }


    /**
     * Handle datatable serverside
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function data_student_fee_list_paid(Request $request)
    {
        if ($request->ajax()) {
            $now = Carbon::now()->format('m');
            $start_date = $request->get('start_date', $now);
            $end_date = $request->get('end_date', $now);
            $transaction_type = $request->get('transaction_type', '');
            Session::put('sessionTransactionType',$transaction_type);

            $studentFees = StudentFee::whereBetween('entry_date', [$start_date, $end_date])
                ->where('status', 'paid')
                ->get();

            $table = Datatables::of($studentFees)

             ->addColumn('entry_date', function ($row) {
                 return $row->entry_date;
              })

            ->addColumn('id', function ($row) {
                return '
                <span class="dont-break-out cursor-pointer hover:text-blue-500">
                '. $row->id .'
                </span>
                ';
            })

            ->addColumn('payment_method', function ($row) {
                $payment_method = ucwords(str_replace('_', ' ', $row->payment_method));
                return '
                <span class="dont-break-out cursor-pointer hover:text-blue-500">
                '. $payment_method .'
                </span>
                ';
            })

            ->addColumn('entry_date', function ($row) {
                return $row->entry_date;
             })

             ->addColumn('id', function ($row) {
               return '
               <span class="dont-break-out cursor-pointer hover:text-blue-500">
               '. $row->id .'
               </span>
               ';
           })

           ->addColumn('payment_method', function ($row) {
                $payment_method = ucwords(str_replace("_"," ",$row->payment_method));
               return '
               <span class="dont-break-out cursor-pointer hover:text-blue-500">
               '. $payment_method .'
               </span>
               ';
           })

           ->addColumn('amount', function ($row) {
            return  $row->amount;
        })

        ->addColumn('discount', function ($row) {
         return  $row->discount;
         })

         ->addColumn('note', function ($row) {
             return  $row->note;
             })

         ->addColumn('paid', function ($row) {
             return  $row->paid;
             })
           ->rawColumns(['id', 'entry_date', 'payment_method','amount'])
            ->skipPaging()
            ->make(true);

            return $table;
        }
    }


    /**
     * Handle datatable serverside
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function data_others_collection_list(Request $request)
    {
        if ($request->ajax()) {
            $now = Carbon::now()->format('m');
            $start_date = $request->get('start_date', $now);
            $end_date = $request->get('end_date', $now);
            $transaction_type = $request->get('transaction_type', '');
            Session::put('sessionTransactionType',$transaction_type);

            $othersCollections = OthersCollections::whereBetween('entry_date', [$start_date, $end_date])
                ->get();

            $table = Datatables::of($othersCollections)

             ->addColumn('entry_date', function ($row) {
                 return $row->entry_date;
              })

            ->addColumn('id', function ($row) {
                return '
                <span class="dont-break-out cursor-pointer hover:text-blue-500">
                '. $row->id .'
                </span>
                ';
            })

            ->addColumn('payment_method', function ($row) {
                $payment_method = ucwords(str_replace("_"," ",$row->payment_method));
               return '
               <span class="dont-break-out cursor-pointer hover:text-blue-500">
               '. $payment_method .'
               </span>
               ';
           })

            ->addColumn('amount', function ($row) {
                return  $row->amount;
            })
            ->rawColumns(['details', 'id', 'payment_method','amount'])
            ->skipPaging()
            ->make(true);

            return $table;
        }
    }

    /**
     * Handle datatable serverside
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function data_expense_list(Request $request)
    {
        if ($request->ajax()) {
            $now = Carbon::now()->format('m');
            $start_date = $request->get('start_date', $now);
            $end_date = $request->get('end_date', $now);
            $expense_type_id = $request->get('expense_type_id', '');

            $dailyExpenses = DailyExpenses::with('expense_type')->whereBetween('entry_date', [$start_date, $end_date]);
            if ($expense_type_id){
                $dailyExpenses->where('expense_type_id',$expense_type_id);
            }

            $dailyExpenses->get();

            $table = Datatables::of($dailyExpenses)

             ->addColumn('entry_date', function ($row) {
                 return $row->entry_date;
              })

              ->addColumn('id', function ($row) {
                return '
                <span class="dont-break-out cursor-pointer hover:text-blue-500">
                '. $row->expense_type->name .'
                </span>
                ';
            })

            ->addColumn('payment_method', function ($row) {
                $payment_method = ucwords(str_replace("_"," ",$row->payment_method));
               return '
               <span class="dont-break-out cursor-pointer hover:text-blue-500">
               '. $payment_method .'
               </span>
               ';
           })

            ->addColumn('amount', function ($row) {
                return  $row->amount;
            })
            ->rawColumns(['id', 'entry_date', 'payment_method','amount'])
            ->skipPaging()
            ->make(true);

            return $table;
        }
    }



        /**
     * Handle datatable serverside
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function data_salaries_list(Request $request)
    {
        if ($request->ajax()) {
            $now = Carbon::now()->format('m');
            $start_date = $request->get('start_date', $now);
            $end_date = $request->get('end_date', $now);
            $transaction_type = $request->get('transaction_type', '');
            Session::put('sessionTransactionType',$transaction_type);
            //$query = Salary::with('employee')->with('bank')->whereBetween('created_at', [$start_date, $end_date]);
            $salaries = Salary::with('employee')->with('bank')->with('mobile_walet')->whereBetween('created_at', [$start_date, $end_date])
                ->get();

            $table = Datatables::of($salaries)

             ->addColumn('entry_date', function ($row) {
                 return $row->created_at;
              })
              ->addColumn('employee_name', function ($row) {
                return $row->employee->name;
             })

              ->addColumn('id', function ($row) {
                return '
                <span class="dont-break-out cursor-pointer hover:text-blue-500">
                '. $row->id .'
                </span>
                ';
            })

            ->addColumn('payment_method', function ($row) {
                $payment_method = ucwords(str_replace("_"," ",$row->payment_method));
                if($row->payment_method=='cheque'){
                    $payment_method = $row->bank->name." (".$row->acc_or_mobile_no.")";
                }
                if($row->payment_method=='mobile_banking'){
                    $payment_method = $row->mobile_walet->name." (".$row->acc_or_mobile_no.")";
                }

               return '
               <span class="dont-break-out cursor-pointer hover:text-blue-500">
               '. $payment_method.'
               </span>
               ';
           })

            ->addColumn('amount', function ($row) {
                return  $row->amount;
            })
            ->rawColumns(['id', 'entry_date', 'payment_method','amount'])
            ->skipPaging()
            ->make(true);

            return $table;
        }
    }

}
