<?php

namespace App\Http\Controllers;

use App\Models\Remarks;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Yajra\DataTables\Facades\DataTables;
use DB;
class RemarkController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return array
     */
    public function index()
    {
        $title = 'Remark';
        $data = Remarks::orderBy('id','ASC')->get();
        return view('remarks.index',compact('title','data'));
    }

      /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $remark = new Remarks();
        $remark->gpa = $request->gpa;
        $remark->remark = $request->remark;
        $remark->save();

        if($remark)
        {
            return redirect()->back()->with('success','Remark Added Successfully');
        }
        else{
         return redirect()->back()->with('danger','Something happened wrong');
        }
    }


    public function updateRemark(Request $request, $id)
    {
        $remark = Remarks::find($id);
        $remark->gpa = $request->gpa;
        $remark->remark = $request->remark;
        $remark->save();

        if($remark){
            return redirect('remarks')->with('success','Remark Updated Successfully');
        }
        else{
         return redirect('remarks')->with('danger','Something happened wrong');
        }
    }


    public function delete($id)
    {
        $remark = Remarks::where('id',$id)->delete();
        if($remark)
        {
            return redirect()->back()->with('success','Remark Deleted Successfully');
        }
        else{
         return redirect()->back()->with('danger','Something happened wrong');
        }
    }
}
