<?php

namespace App\Http\Controllers;

use App\Models\Role;
use App\Models\User;
use App\Models\DailyExpenses;
use App\Models\Student;
use App\Models\Classes;
use App\Models\Sections;
use App\Models\Groups;
use App\Models\Sessions;
use App\Models\Subjects;
use App\Models\MarkTypes;
use App\Models\Marks;
use App\Models\MarksEntryForm;
use App\Models\CurrentAcadmicStatus;
use App\Models\FeeTypes;
use App\Models\FeeTypesAmount;
use App\Models\StudentFee;
use App\Models\Json;
use Illuminate\Http\Request;
use Datatables;
use DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Carbon;
use PhpParser\Builder\Class_;

class PromotionController extends Controller
{
    public function index()
    {
        Session::put('itemArray', []);

        $data = [
            'classes' => Classes::get(),
            'sections' => Sections::get(),
            'sessions' => Sessions::orderBy('id', 'DESC')->get()
        ];

        return view('promotion.index', $data);
    }

    public function data(Request $request)
    {
        if ($request->ajax()) {



            $classId = $request->get('classId', '');
            $sectionId = $request->get('sectionId', array());
            $sessionId = $request->get('sessionId', '');
            $subjectId = $request->get('subjectId', '');
            $markTypes = $request->get('markTypes', array());

            $exam_id = 1;
            $studentWithMarks = CurrentAcadmicStatus::with('student_details')
            ->with(['MarksDetails' => function ($query)  use ($exam_id) {
                $query->where('exam_id',$exam_id);
                }])
                ->where('current_academic_status.class_id',$classId)
                ->where('current_academic_status.section_id',$sectionId)
                ->where('current_academic_status.session_id',$sessionId)
                ->with('session')
                ->with('class')
                ->with('section')
                ->get();

            $data = DailyExpenses::orderBy('id', 'desc')
                ->get();

            $table = Datatables::of($studentWithMarks)
            ->addColumn('checkbox', function ($row) {
                return "<input type='checkbox' name='checkbox' class='checkbox' data-id='" . $row->id . "'>";
            })


                ->addColumn('profile_pic', function ($row) {
                        $student_id = isset($row->student_details->id) ? $row->student_details->id : '';

                            return '
                            <div class="flex flex-row gap-4" id="__productDiv_3934">
                                <div class="w-1/2 sm:w-full md:w-fulllg:w-full">
                                <div class="mb-3">
                                    <img src="http://127.0.0.1:8000/No-Image-Found.png" style="width:100px !important" class="w-full h-auto">
                                </div>

                                </div>

                            </div>
                        ';
                })

                ->addColumn('details', function ($row) {
                    $student_id = isset($row->student_details->id) ? $row->student_details->id : '';
                           $roll_no = isset($row->student_details->roll_no) ? $row->student_details->roll_no : '';
                           $name = isset($row->student_details->name) ? $row->student_details->name : '';

                            return '
                            <div class="flex flex-row gap-4" id="__productDiv_3934">
                            <div class="w-1/2 sm:w-full md:w-fulllg:w-full">
                                <div class="mb-3">
                                    <span class="text-blue-500 font-bold">
                                        Roll No : <strong>'. $roll_no .'</strong><br>
                                    </span>

                                    <span class="whitespace-nowrap cursor-pointer hover:text-blue-500">
                                    <a href=""class="underline text-blue-500 font-bold">
                                        Name: '.$name.'
                                        </a>
                                    </span><br>

                                    <span class="whitespace-nowrap cursor-pointer hover:text-blue-500">
                                    Class : <strong> '. $row->class->class_name .' </strong>
                                    </span>

                                    <span class="whitespace-nowrap cursor-pointer hover:text-blue-500">
                                        (<strong> '. $roll_no .' </strong>)
                                    </span><br>
                                    <span class="whitespace-nowrap cursor-pointer hover:text-blue-500">
                                        Session : <strong> '. $row->session->session_name .' </strong>
                                    </span><br>


                                </div>

                            </div>

                        </div>
                    ';
                })


                ->addColumn('mark_details', function ($row) {
                    $student_id = isset($row->student_details->id) ? $row->student_details->id : '';
                    $roll_no = isset($row->student_details->roll_no) ? $row->student_details->roll_no : '';
                    $name = isset($row->student_details->name) ? $row->student_details->name : '';

                    $exam_id = 1;
                    $marksDetails = Marks::getMarkDetailsBySessionIDAndStudentID($row->session->id,$exam_id,$student_id);
                    // dd($row->session->id);
                        $totalSubjects = count($marksDetails);
                    $arr_grade_point = array();
                    $arr_letter_grade = array();
                    $arr_marks = array();
                    foreach($marksDetails as $mark){
                        $arr_grade_point[] = $mark['grade_point'];
                        $arr_letter_grade[] = $mark['letter_grade'];
                        $arr_marks[] = $mark['total_obtained_marks'];
                    }
                    $totalSubjects = count($marksDetails);
                    $totalGP = array_sum($arr_grade_point);
                    $totalMarks = array_sum($arr_marks);

                    if(!empty($totalGP) && ($totalSubjects > 0) ){
                        $GPA = $totalGP/$totalSubjects;
                    }else{
                        $GPA = '0.00';
                    }

                    $GPA = number_format((float)$GPA, 2, '.', '');
                    $letter_grade_by_total_gpa = Marks::PerSubjectLetterGradeGeneratorByGPA($GPA);

                    return '
                    <span class="whitespace-nowrap cursor-pointer hover:text-blue-500">
                        Exam Name : <strong> </strong>
                    </span><br>
                    <span class="whitespace-nowrap cursor-pointer hover:text-blue-500">
                        Total Subjects : <strong> '. $totalSubjects .' </strong>
                    </span><br>

                    <span class="whitespace-nowrap cursor-pointer hover:text-blue-500">
                        Total Marks : <strong> '. $totalMarks .' </strong>
                    </span><br>
                    <span class="whitespace-nowrap cursor-pointer hover:text-blue-500">
                        GPA : <strong> '. $GPA.'('.$letter_grade_by_total_gpa.') </strong>
                    </span><br>
                    <span data-exam_id="1" data-session_id="'.$row->session_id.'" data-class_id="'.$row->class_id.'" data-student_id="'.$student_id.'" class ="exportMarkSheet badge-status--yellow my-2 whitespace-nowrap cursor-pointer">View Marksheet</span>
                    <br>';

                })

                ->addColumn('amount', function ($row) {
                    return $row->id;
                })
                ->addColumn('note', function ($row) {
                    return $row->id;
                })
                ->addColumn('payment_status', function ($row) {
                $FeeDetails = StudentFee::where('student_id',$row->student_details->id)->where('session_id',$row->session_id)->get();

                $date = Carbon::now();
                $month_key = $date->format('m');
                $month_arr = StudentFee:: MonthArray();
                $monthArrPast = [];

                foreach($month_arr as $key => $value){
                    if($key == $month_key) break;
                    $monthArrPast[$key] = $value;
                }

                $arr_paid_month = array();
                foreach($FeeDetails as $fee){
                    $arr_paid_month = array_merge($arr_paid_month, explode(",",$fee->monthly_fee_fields));
                }

                $arr_paid_only = array();
                foreach($monthArrPast as $month){
                    if(!in_array($month,$arr_paid_month)){
                        $arr_paid_only[] = '<span class="tag-month">'.$month.'</span>';
                    }
                }

                $paidMonthlyFee = implode(" ",$arr_paid_only);
                if(count($arr_paid_only)==0 ){
                     return '
                    <strong>No Due</strong> ';
                }else{
                    return '
                    <strong>Total Due Months : </strong> '. count($arr_paid_only) .'<br/>
                    <span class="dont-break-out cursor-pointer hover:text-blue-500">
                    '. $paidMonthlyFee .'
                    </span>
                    ';
                }
                })
                ->addColumn('status', function ($row) {
                })
                ->rawColumns(['checkbox','profile_pic','details','mark_details','payment_status'])
                ->make(true);
            return $table;
        }
    }



    public function promotionModal(Request $request)
    {
        $classes = Classes::all();
        $student_ids = $request->ids;
        $session_id = $request->session_id;
        $new_session_name = $request->current_session+1;

        return view('elements.form-promotion-modal', compact('session_id','new_session_name','classes','student_ids'));
    }

    public function confirmPromotion(Request $request)
    {
        $session_id = $request->session_id;
        $new_class_id = $request->new_class_id;
        $new_session_name = $request->new_session_name;
        $student_ids = $request->student_ids;
        $arr_student_ids = explode(",", $student_ids);

        $current_academic_status = CurrentAcadmicStatus::where('session_id', $session_id)->whereIn('student_id',[$student_ids])->first();
       // dd($current_academic_status);

        $new_session_details = Sessions::where('session_name', $new_session_name)->first();
        if($new_session_details){
            $new_session_id = $new_session_details->id;
        }else{
            $new_session = new Sessions();
            $new_session->session_name = $new_session_name;
            $new_session->save();
            $new_session_id = $new_session->id;
        }



        foreach($arr_student_ids as $student_id)
        {
            $current_academic_status = CurrentAcadmicStatus::find($student_id)->replicate(); // $value->id is your primary key
            $current_academic_status->session_id = $new_session_id;
            $current_academic_status->class_id = $new_class_id;
            $current_academic_status->save();
        }

        return redirect()->back()->with('success', 'Status successfully changed');
//            } else {
//                return redirect()->back()->with('error', 'Wrong Status');
//            }

    }


}
