<?php

namespace App\Http\Controllers;

use App\Models\Student;
use App\Models\CurrentAcadmicStatus;
use App\Models\DailyExpenses;
use App\Models\Package;
use App\Models\StudentFee;
use App\Models\Banks;
use App\Models\MobileWalets;


use Illuminate\Support\Facades\Cache;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Carbon;
use Datatables;


class PersonController extends Controller
{
    public function dashboard()
    {

           $person_id = Auth::id();
           $total_student = DB::table('students')->count();
            $today = Carbon::now('Asia/Jakarta')->format('Y-m-d');

            $students = DB::table('students')
            ->select("gender",DB::raw("count(id) as total"))
            ->groupBy(DB::raw("gender"))
            ->get();

            //dd($students);

            $todays_fees = DB::table('students_fee')
            ->select("status",DB::raw("SUM(paid) as total"))
            ->groupBy(DB::raw("status"))
            ->whereDate('entry_date', Carbon::today())
            ->get();

            $todays_costs = DailyExpenses::select('status',DB::raw("SUM(amount) as total"))
            ->orderBy("created_at")
            ->groupBy(DB::raw("status"))
            ->get();

            return view('person.dashboard', compact(['students','todays_fees','todays_costs']));

    }


    public function FeeDetailsPage(Request $request)
    {

        $person_id = Auth::id();
        $status = $request->status;

        return view('person.fee-list', compact(['status']));

    }

    public function FeeDetailsDataTable(Request $request){
        $studentFees = StudentFee::with('student_details')
        ->where('entry_date',$request->entry_date)
        ->where('status',$request->status)
        ->get();
        $table = Datatables::of($studentFees)

            ->addColumn('receipt_no', function ($row) {
                return '
                    <div class="flex flex-row gap-4">
                    <div class="w-1/2 sm:w-full md:w-fulllg:w-full">
                        <div class="mb-0">
                            <span class="text-blue-500 font-bold">
                                <strong>' . $row->id . '</strong><br>
                            </span>
                        </div>
                    </div>
                </div>
            ';
            })


            ->addColumn('student_code', function ($row) {
                $student_code = isset($row->student_details->student_code) ? $row->student_details->student_code : '';
                return '<span data-id='.$row->student_details->id.' data-session='.$row->session_id.' title="View Student Details" class="btnLoadStudentDetails cursor-pointer text-blue-500 font-bold">' . $student_code . '</span>';
            })

            ->addColumn('entry_date', function ($row) {
                return $row->entry_date;
            })


            ->addColumn('payment_method', function ($row) {
                return ucwords($row->payment_method);
            })

            ->addColumn('total', function ($row) {
                return number_format($row->amount, 2);
            })

            ->addColumn('discount', function ($row) {
                return number_format($row->discount, 2);
            })

            ->addColumn('paid', function ($row) {
                return number_format($row->paid, 2);
            })

            ->addColumn('status', function ($row) {
                $bg = ($row->status == 'paid') ? 'badge-status--green' : 'badge-status--red';
                return '<span class="btnLoadStudentDetails '.$bg.' my-2 whitespace-nowrap cursor-pointer round font-bold">' . ucwords($row->status) . '</span>';
            })


        ->addColumn('payment_details', function ($row) {
            $payment_method = ucwords(str_replace("_", " ", $row->payment_method));

            $html = '<p class="m-0"><strong>Payment Method: </strong>' . $payment_method . '</p>';
            if ($row->payment_method == 'cheque') {
                $bank = Banks::where('id', $row->bank_or_wallet_id)->first();
                $html .= '<p class="m-0"><strong>Bank: </strong>' . $bank->name . '</p>';
                $html .= '<p class="m-0"><strong>Acc#: </strong>' . $row->acc_or_mobile_no . '</p>';
            }

            if ($row->payment_method == 'mobile_banking') {
                $wallet = MobileWalets::where('id', $row->bank_or_wallet_id)->first();
                $html .= '<p class="m-0"><strong>Wallet: </strong>' . $wallet->name . '</p>';
                $html .= '<p class="m-0"><strong>Acc#: </strong>' . $row->acc_or_mobile_no . '</p>';
            }
            if ($row->discount) {
                $html .= '<p class="m-0"><strong>Discount: Tk.</strong>' . $row->discount . '</p>';
                $html .= '<p class="m-0"><strong>Ref. Name: </strong>' . $row->note . '</p>';
            }
            return $html;
        })

        ->addColumn('amount', function ($row) {
            $html = '';
            if ($row->discount) {
                $html .= '<p class="m-0" style="text-decoration: line-through;color: #ff0909;" >' . number_format($row->amount,2) . '</p>';
                $html .= '<p class="m-0" style="" >' . number_format($row->paid,2) . '</p>';
            }else{
                $html .= '<p class="m-0" style="" >' . number_format($row->amount,2) . '</p>';
            }
            return $html;
        })

        ->addColumn('action', function ($row) {

            $id = isset($row->id) ? $row->id : '';


            return '<div class="w-full text-center">

            <button type="button" class="btn-action--yellow" data-id='.$id.' id="BtnPrintMoneyReceipt" title="Detail">
                View &nbsp; <i class="fas fa-eye"></i>
            </button>

        </div>';

        })

        ->rawColumns(['receipt_no', 'student_code','others_fee', 'payment_details','amount','status', 'action'])
        ->skipPaging()
        ->make(true);

        return $table;

    }

    public function StudentDetails(Request $request)
    {
        $session_id = $request->session_id;
        $student = CurrentAcadmicStatus::with('student_details')
            ->with(['FeeDetails' => function ($query){
                $query->groupBy('status');
                $query->select('id','student_id',"status", DB::raw("SUM(paid) as total"));
            }])
            ->where('student_id', $request->id)
            ->first();

            return view('person.students.student-view', compact('student'));
    }

    public function package()
    {
        $packages = DB::table('packages')
            ->get();
        return view('person.package', compact('packages'));
    }

    public function data(Request $request)
    {
        if ($request->ajax()) {

            if (isset($request->id) && $request->id != null) {
                $data = Package::where([
                    'id' => $request->id
                ])->first();

                $id = $request->id;

                return view('elements.form-update-package', compact(['data', 'id']));
            }


            $data = package::orderBy('id', 'desc')->get();


            $table = Datatables::of($data)
                ->addColumn('price', function ($row) {
                    return currency_symbol('THB') .$row->price;
                })
                ->addColumn('package_type', function ($row) {
                    if($row->package_type == 1)
                    {
                        return 'Daily';
                    }
                    else
                    {
                        return 'Monthly';
                    }
                })
                ->addColumn('manage', function ($row) {
                    return '<span x-on:click=" showEditModal=true"class="modal-open bg-green-500 text-white rounded px-2 py-1 mr-4 capitalize cursor-pointer" data-id="' . $row->id . '" id="BtnUpdate">Edit</span><span class="bg-red-500 text-white rounded px-2 py-1 capitalize cursor-pointer" data-id="' . $row->id . '" id="BtnDelete">Delete</span>';
                })

                ->rawColumns(['manage'])
                ->make(true);
            return $table;
        }
    }

    public function insert(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required|',
            'price' => 'required',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        Package::create([
            'package_name' => $request->name,
            'price' => $request->price,
            'details' => $request->details,
            'max_limit' => $request->max_limit,
            'package_type' => $request->package_type
        ]);

        return redirect()->back()->with('success', 'Package successfully created');
    }

    public function update(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required|',
            'price' => 'required',
        ],);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        DB::table('packages')
            ->where('id', $request->id)
            ->update([
                'package_name' => $request->name,
                'price' => $request->price,
                'details' => $request->details,
                'max_limit' => $request->max_limit,
                'package_type' => $request->package_type
            ]);

        if ($request->password) {
            return $this->changePassword($request);
        }

        return redirect('/admin/package')->with('success', 'Package successfully updated');
    }

    public function delete(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'id' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 0,
                'message' => 'Field id is required'
            ]);
        } else {

            DB::table('packages')->where([
                'id' => $request->id
            ])->delete();

            return [
                'status' => 1
            ];
        }
    }

}
