<?php

namespace App\Http\Controllers;

use App\Models\Product;
use App\Models\Role;
use App\Models\Shop;
use App\Models\StockLog;
use App\Models\User;
use App\Models\OthersCollections;
use App\Models\Banks;
use App\Models\MobileWalets;
use Illuminate\Http\Request;
use Datatables;
use DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Carbon;
class OthersCostController extends Controller
{
    public function othersCollection()
    {
        $banks = Banks::get();
        $mobile_wallets = MobileWalets::get();
        $title = 'OthersCollections';
        return view('person.others-collection', compact('banks', 'mobile_wallets', 'title'));
    }

    public function data(Request $request)
    {
        if ($request->ajax()) {
            if(isset($request->assign_shop)){
                $staff = User::find($request->id);
                $assigned_shops = '';
                if($staff->assigned_shops != null){
                    $assigned_shops = json_decode($staff->assigned_shops);
                }
                $data['staff_id'] = $request->id;
                $data['assigned_shops'] = $assigned_shops;
                $data['shops'] = Shop::where('person_id', Auth::id())->get();
                return view('elements.form-assign-shop', $data);
            }

            if (isset($request->id) && $request->id != null) {
                $data = OthersCollections::where([
                    'id' => $request->id
                ])->first();

                $id = $request->id;
                $roles = Role::all();
                $banks = Banks::get();
                $mobile_wallets = MobileWalets::get();


                return view('elements.form-update-others-collection', compact(['data', 'id', 'banks','mobile_wallets']));
            }

            $data = OthersCollections::orderBy('id', 'desc')
                ->get();

            $table = Datatables::of($data)
            ->addColumn('checkbox', function ($row) {
                return "<input type='checkbox' name='cost_id' class='cost_id' data-id='" . $row->id . "'>";
            })
                ->addColumn('created_at', function ($row) {
                    return $row->entry_date;
                })
                ->addColumn('amount', function ($row) {
                    return $row->amount;
                })
                ->addColumn('note', function ($row) {
                    return $row->note;
                })
                ->addColumn('status', function ($row) {
                    if($row->status==1) $status = "Approved";
                    if($row->status==0) $status = "Not Approved";
                    return $status;
                })
                ->addColumn('manage', function ($row) {
                    if (Auth::user()->role == 'member'){
                        return '<div class="w-full text-center">
                                    <button type="button" class="modal-open btn-action--green" title="'. __('translation.Edit') .'" x-on:click="showEditModal=true" data-id="' . $row->id . '" id="BtnUpdate">
                                       <i class="fas fa-pencil-alt"></i>
                                    </button>
                                    <button type="button" class="btn-action--red" title="'. __('translation.Delete') .'" data-id="' . $row->id . '" id="BtnDelete">
                                        <i class="fas fa-trash-alt"></i>
                                    </button>
                                </div>';
                    }
                })
                ->rawColumns(['checkbox','manage'])
                ->make(true);
            return $table;
        }
    }

    public function insert(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'details' => 'required|min:3',
            'amount' => 'required',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }
        try {
            $bank_or_wallet_id = '';
            $acc_or_mobile_no = '';
            if ($request->payment_method == 'cheque') {
                $bank_or_wallet_id = $request->bank_id ? $request->bank_id : '';
                $acc_or_mobile_no = $request->cheque_no ? $request->cheque_no : '';
            }

            if ($request->payment_method == 'mobile_banking') {
                $bank_or_wallet_id = $request->wallet_id ? $request->wallet_id : '';
                $acc_or_mobile_no = $request->mobile_no ? $request->mobile_no : '';
            }

            OthersCollections::create([
                'details' => $request->details,
                'amount' => $request->amount,
                'note' => $request->note,
                'entry_date' => Carbon::now(),
                'status' => '0',
                'payment_method' => $request->payment_method,
                'bank_or_wallet_id' => $bank_or_wallet_id,
                'acc_or_mobile_no' => $acc_or_mobile_no
            ]);

            return redirect()->back()->with('success', 'Data successfully created');
        }catch (\Exception $th) {
            return redirect()->back()->with('error', 'Please try again..');
        }
    }

    public function update(Request $request)
    {
        $others_collection = OthersCollections::find($request->id);

        $validator = Validator::make($request->all(), [
            'details' => 'required',
            'amount' => 'required',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        $others_collection->details = $request->details;
        $others_collection->amount = $request->amount;
        $others_collection->note = $request->note;
        $others_collection->payment_method = $request->payment_method;
        if($request->payment_method=='cheque'){
            $others_collection->bank_or_wallet_id = $request->bank_id ? $request->bank_id: '' ;
            $others_collection->acc_or_mobile_no = $request->cheque_no ? $request->cheque_no: '' ;
        }

        if($request->payment_method=='mobile_banking'){
            $others_collection->bank_or_wallet_id = $request->wallet_id ? $request->wallet_id: '' ;
            $others_collection->acc_or_mobile_no = $request->mobile_no ? $request->mobile_no: '' ;
        }

        $others_collection->update();

        return redirect('others-collection')->with('success', __('translation.Data successfully updated'));
    }

    public function changeStatusModal(Request $request)
    {
        $ids = $request->ids;
        return view('elements.form-approved-others-collection', compact('ids'));
    }

    public function changeStatus(Request $request)
    {
        $arr_ids = explode(",",$request->ids);
        DB::table('others_collections')->whereIn('id', $arr_ids)
            ->update([
                'status' => $request->status
            ]);
        return redirect()->back()->with('success', 'Status successfully changed');
//            } else {
//                return redirect()->back()->with('error', 'Wrong Status');
//            }

    }

    public function validatePassword(array $input)
    {
        // validating user input
        $rules = [
//            'current-password' => 'required|string',
            'new-password' => 'required|string|min:8', //|,confirmed',
        ];
        $message = [
            // 'confirmed' => 'Password confirmation is wrong'
        ];
        $attributes = [
            'new-password' => 'New Password'
        ];
        $validator = Validator::make($input, $rules, $message, $attributes);

        return $validator;
    }

    public function delete(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'id' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 0,
                'message' => 'Field id is required'
            ]);
        }

        OthersCollections::where('id', $request->id)->delete();
        return [
            'status' => 1
        ];
    }

    public function dashboard()
    {
        $user = Auth::user();
        $products = Product::where('person_id',$user->person_id)->get();
        return view('staff.dashboard', compact(['products']));

    }


}
