<?php

namespace App\Http\Controllers\OrderManage;

use App\Http\Controllers\Controller;
use App\Models\OrderManagement;
use App\Traits\ApiResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class StatusController extends Controller
{
    use ApiResponse;

    /**
     * Get status counters of order_managements data
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $sellerId = Auth::user()->id;
        $roleName = Auth::user()->role;

        $allAvailableOrderStatus = OrderManagement::getAllOrderStatus();

        $orderStatusCounters = OrderManagement::selectRaw('order_status, COUNT(id) AS total')
                    ->where('seller_id', $sellerId)
                    ->clientAsset($roleName)
                    ->groupBy('order_status')
                    ->orderBy('order_status', 'asc')
                    ->get();

        $orderStatusTransformed = collect($allAvailableOrderStatus)->map(function($orderLabel, $orderId) use ($orderStatusCounters) {
            $counter = $orderStatusCounters->where('order_status', $orderId)->first();

            return [
                'id' => $orderId,
                'label' => $orderLabel,
                'total' => $counter->total ?? 0
            ];
        });

        $orderStatusTransformed->prepend([
            'id' => -1,
            'label' => 'All',
            'total' => $orderStatusTransformed->sum('total')
        ]);

        return $this->apiResponse(200, 'Success', [
            'orderStatuses' => $orderStatusTransformed
        ]);
    }

    /**
     * Get status counters of woo purchase orders
     *
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getOrderStatusList(Request $request)
    {
        $parentStatusId = $request->get('parentStatusId', 0);
        $clientType = $request->get('clientType', 0);
        $roleName = Auth::user()->role;

        $statusSchema = OrderManagement::getStatusSchemaForDatatable($roleName,$clientType );
        $statusCounts = '';
        foreach ($statusSchema as $schema){
            if ($schema['id'] == $parentStatusId){
                $statusCounts = $schema['sub_status'];
            }
        }

        $data = [
            'orderStatusCounts' => $statusCounts
        ];

        return response()->json($data);
    }

}
