<?php

namespace App\Http\Controllers;

use App\Models\ModelName;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Yajra\DataTables\Facades\DataTables;

class ModelNameController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return array
     */
    public function index()
    {
        $title = 'model';
        $data = ModelName::get();
        return view('settings.model',compact('title','data'));
    }

    public function data(Request $request)
    {
        if ($request->ajax()){
            if (isset($request->id) && $request->id != null) {
                $editData = ModelName::where([
                    'id' => $request->id
                ])->first();
                return view('elements.form-update-model',compact( 'editData'));
            }

            $data = ModelName::where('shop_id', Auth::user()->shop_id)->get();

            $table = Datatables::of($data)
                ->addColumn('manage', function ($row) {
                    return '
                        <div class="w-full text-left">
                            <button type="button" class="modal-open btn-action--green" title="'. __('translation.Edit') .'" x-on:click="showEditModal=true" data-id="' . $row->id . '" id="BtnUpdate">
                                <i class="fas fa-pencil-alt"></i>
                            </button>
                            <button type="button" class="btn-action--red" title="'. __('translation.Delete') .'" data-id="' . $row->id . '" id="BtnDelete">
                                <i class="fas fa-trash-alt"></i>
                            </button>
                        </div>
                    ';
                })
                ->rawColumns(['manage'])
                ->make(true);

            return $table;
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('elements.form-update-model');

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $model = new ModelName();
        $model->name = $request->name;

        $model->shop_id = Auth::user()->shop_id;
        $model->save();

        if($model)
        {
            return redirect()->back()->with('success','Model Name Added Successfully');
        }
        else{
            return redirect()->back()->with('danger','Something happened wrong');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = ModelName::where('shop_id', Auth::user()->shop_id)->get();

        return view('settings.model',compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'id' => 'required',
            'name' => 'required'
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }
        $model = ModelName::where('id', $request->id)->first();
        $model->name = $request->name;
        $model->shop_id = Auth::user()->shop_id;
        $model->save();

        if($model)
        {
            return redirect('models')->with('success','Model Name Updated Successfully');
        }
        else{
            return redirect('models')->with('danger','Something happened wrong');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
    public function delete(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'id' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 0,
                'message' => 'Field id is required'
            ]);
        } else {

            $model = ModelName::where('id',$request->id)->where('shop_id', Auth::user()->shop_id)->first();
            if(file_exists($model->logo)){
                unlink($model->logo);
            }
            $model->delete();

            return [
                'status' => 1
            ];
        }
    }
}
