<?php

namespace App\Http\Controllers;
use App\Models\Student;
use App\Models\Exams;
use App\Models\Classes;
use App\Models\Sections;
use App\Models\Sessions;
use App\Models\Groups;
use App\Models\Subjects;
use App\Models\MarkTypes;
use App\Models\Marks;
use App\Models\MarksBySubject;
use App\Models\CurrentAcadmicStatus;
use App\Models\Settings;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Datatables;
use DB;
use PDF;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB as FacadesDB;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Hash;
use Maatwebsite\Excel\Facades\Excel;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use Illuminate\Support\Str;

use App\Exports\ExportMarksSheetBySubjectID;

class MarksReportBySubjectController extends Controller
{

    public $exam_id=0;
    public $subject_id=0;
    /**
     * Load `Marks Entry Form ` Page >> URL : .../marks_by_subject
    */
    public function EditMarksBySubjectPage()
    {

        $data = [
            'exams' => Exams::orderBy('position', 'ASC')->get(),
            'classes' => Classes::get(),
            'sections' => Sections::get(),
            'sessions' => Sessions::orderBy('id', 'DESC')->get(),
            'subjects' => Subjects::orderBy('name', 'ASC')->get(),
            'mark_types' => MarkTypes::orderBy('position', 'ASC')->get(),
        ];
        return view('results.edit_marks_by_subject', $data);
    }


    /**
     * Load `Marks Entry Form ` Page >> URL : .../marks_by_subject
    */
    public function MarksReportBySubjectPage()
    {

        $data = [
            'exams' => Exams::orderBy('position', 'ASC')->get(),
            'classes' => Classes::get(),
            'sections' => Sections::get(),
            'sessions' => Sessions::orderBy('id', 'DESC')->get(),
            'subjects' => Subjects::orderBy('name', 'ASC')->get(),
            'mark_types' => MarkTypes::orderBy('position', 'ASC')->get(),
        ];
        return view('results.marks_by_subject', $data);
    }




    /**
     * Handle the `marks entry form ` datatable
     * Serverside Datatable
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     *
     */
    public function MarksReportBySubjectDataTable(Request $request)
    {
        if ($request->ajax()) {
            $userID = Auth::user()->id;


            $examId = $request->get('examId', '');
            $classId = $request->get('classId', '');
            $sectionId = $request->get('sectionId', array());
            $sessionId = $request->get('sessionId', '');
            $subjectId = $request->get('subjectId', '');
            $markTypes = $request->get('markTypes', array());
            $total_subjects = '';
            $arr['exam_id'] = $examId;
            $arr['session_id'] = $sessionId;
            $arr['class_id'] = $classId;
            $arr['section_id'] = $sectionId;
            $arr['type'] = 'all';
            $arr['total_subjects'] = $total_subjects;
            $arr_student_ids = array();



            $data = CurrentAcadmicStatus::with('student_details')
                ->with(['MarksBySubject'=>function ($query) use ($examId,$classId,$sectionId,$sessionId,$subjectId){
                    $query->where('exam_id',$examId);
                    $query->where('class_id',$classId);
                    $query->where('section_id',$sectionId);
                    $query->where('session_id',$sessionId);
                    $query->where('subject_id',$subjectId);
                }])
                ->with('class')
                ->with('section')
                ->with('session')
                ->where('class_id',$classId)
                ->where('section_id',$sectionId)
                ->where('session_id',$sessionId)
                //->orderBy('roll_no','asc')
                ->get();

            $this->exam_id = $examId;
            $this->subject_id = $subjectId;

            $data->map(function ($table) {
                $table->exam_id = $this->exam_id;
                $table->subject_id = $this->subject_id;
                return $table;
            });

            //dd($data[0]);
            $table = Datatables::of($data)
                ->addColumn('name', function ($row) {
                    return $row->student_details->name;
                })

                ->addColumn('roll_no', function ($row) {
                    return $row->roll_no;
                })

                ->addColumn('class_name', function ($row) {
                    return $row->class->class_name;
                })
                ->addColumn('section_name', function ($row) {
                    return $row->section->section_name;
                })

                ->addColumn('session_name', function ($row) {
                    return $row->session->session_name;
                })

                ->addColumn('marks', function ($row) {
                    if (isset($row->MarksBySubject->mark_type_ids)) {
                        $markType_ids = explode(',', $row->MarksBySubject->mark_type_ids);
                        $markType = MarkTypes::whereIn('id', $markType_ids)->get();
                        $table = "<table border=0 class='w-full'>";
                        $table .= "<tr>";
                        foreach ($markType as $item) {
                            $table .= "<td style='font-size: 12px;padding: 0 !important;background:gray;color:#fff;text-align:center;'>" . $item->type . "</td>";
                        }
                        $table .= "</tr>";

                        $table .= "<tr>";
                        $marks = explode(',', $row->MarksBySubject->marks);
                        foreach ($marks as $mark) {
                            $table .= "<td style='font-size: 12px;padding: 0 !important;text-align:center;'>" . $mark . "</td>";
                        }
                        $table .= "</tr>";

                        $table .= "</table>";
                        return $table;
                    }

                })

                ->addColumn('total', function ($row) {
                    if (isset($row->MarksBySubject->marks)) {
                        $marks = explode(',', $row->MarksBySubject->marks);
                        return array_sum($marks);
                    }
                })
                ->addColumn('gpa', function ($row) {
                    if (isset($row->MarksBySubject->marks)) {
                        $marks = explode(',', $row->MarksBySubject->marks);
                        $total = array_sum($marks);
                        $gpa = Marks::PerSubjectGPAGeneratorByTotal($total);
                        return $gpa;
                    }
                })
                ->addColumn('grade', function ($row) {
                    if (isset($row->MarksBySubject->marks)) {
                        $marks = explode(',', $row->MarksBySubject->marks);
                        $total = array_sum($marks);
                        $grade = Marks::PerSubjectLetterGradeGeneratorByTotal($total);
                        return $grade;
                    }
                })

                        ->addColumn('action', function ($row) {

                            $exam_id = isset($row->exam_id) ? $row->exam_id : '';
                            $student_id = isset($row->student_id) ? $row->student_id : '';
                            $subject_id = isset($row->subject_id) ? $row->subject_id : '';
                            $class_id = isset($row->class_id) ? $row->class_id : '';
                            $section_id = isset($row->section_id) ? $row->section_id : '';
                            $session_id = isset($row->session_id) ? $row->session_id : '';


                           return '
                           <div class="w-full text-center">
                           <button data-exam_id = '.$exam_id.' data-student_id = '.$student_id.' data-subject_id='.$subject_id.' data-class_id='.$class_id.'   data-section_id='.$section_id.'  data-session_id='.$session_id.' class="add_or_edit btn-action--green" title="Edit Mark">
                               <i class="fas fa-edit"></i>
                           </button>
                       </div>';

                        })


                        ->rawColumns(['name', 'roll_no', 'class_name', 'section_name','marks','action'])
                        ->skipPaging()
                     //   ->setTotalRecords($dataCount)
                        ->make(true);

            return $table;
        }
    }


    public function LoadMarksEditFormBySubjectIdAndStudentId(Request $request)
    {
        if ($request->ajax()) {
            $userID = Auth::user()->id;


            $action = $request->get('action', '');
            $exam_id = $request->get('exam_id', '');
            $student_id = $request->get('student_id', '');
            $subject_id = $request->get('subject_id', '');
            $class_id = $request->get('class_id', array());
            $section_id = $request->get('section_id', array());
            $session_id = $request->get('session_id', '');


            $studentWithMarks = Student::with(['MarksBySubject' => function ($query)  use ($subject_id,$exam_id,$session_id,$class_id,$section_id,$student_id) {
                $query->where('subject_id',$subject_id);
                $query->where('exam_id',$exam_id);
                $query->where('session_id',$session_id);
                $query->where('class_id',$class_id);
                $query->where('section_id',$section_id);
                $query->where('student_id',$student_id);
                }])
                ->with(['currentAcademicStatus' => function ($query){
                    $query->orderBy('roll_no','asc');
                }])
                ->where('id',$student_id)->first();

                $blank_marks = Marks::where('subject_id', $subject_id)
                    ->where('exam_id', $exam_id)
                    ->where('session_id', $session_id)
                    ->where('class_id', $class_id)
                    ->where('section_id', $section_id)
                    ->first();

           //return response()->json($studentWithMarks->currentAcademicStatus->class->class_name);

            $data = [
                'action' => $action,
                'studentWithMarks' => $studentWithMarks,
                'blank_marks' => $blank_marks,
                'exam_id' => $exam_id,
                'session_id' => $session_id,
                'class_id' => $class_id,
                'section_id' => $section_id,
                'subject_id' => $subject_id,
                'student_id' => $student_id,
            ];
            return view('results.load_mark_form_to_edit_by_student_id_and_subject_id', $data);
        }
    }



    public function StoreMarkBySubjectIdAndStudentId(Request $request)
    {
        if ($request->ajax()) {
            $userID = Auth::user()->id;


            $action = $request->post('action');
            $mark_id = $request->post('mark_id');
            $is_fourth_subject = $request->post('is_fourth_subject');
            $fullmarks = $request->post('fullmarks');
            $pass_mark = $request->post('pass_mark');
            $exam_id = $request->post('exam_id');
            $student_id = $request->post('student_id');
            $subject_id = $request->post('subject_id');
            $class_id = $request->post('class_id');
            $section_id = $request->post('section_id');
            $session_id = $request->post('session_id');
            $arr_mark_type_id = json_decode($request->json_mark_type_id);
            foreach($arr_mark_type_id as $obj){
                $arr_id[] = $obj->id;
                $arr_marks[] = $obj->mark;
            }

            if($action=='insert'){

                $mark = new Marks();
                $mark->exam_id = $exam_id;
                $mark->is_fourth_subject = $is_fourth_subject;
                $mark->fullmarks = $fullmarks;
                $mark->pass_mark = $pass_mark;
                $mark->session_id = $session_id;
                $mark->class_id = $class_id;
                $mark->section_id = $section_id;
                $mark->student_id = $student_id;
                $mark->subject_id = $subject_id;
                $mark->mark_type_ids = implode(",",$arr_id);
                $mark->marks = implode(",",$arr_marks);
                $mark->save();

            }else{
                $data = [
                    'marks' => implode(",",$arr_marks),
                ];

                $marks = Marks::where('id', $mark_id)
                ->update($data);
            }


           return response()->json([
            'message' => '<h4 class="text-center">Data Submitted successfully</h4>.'
            ]
        );



        }
    }



        /**
     * Handle the `product stock report` datatable
     * Serverside Datatable
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     *
     */
    public function MarksSheetBySubjectIdPDFExport(Request $request)
    {
        if ($request->ajax()) {
            try {
                $exam_id = $request->get('examId', '');
                $class_id = $request->get('classId', '');
                $section_id = $request->get('sectionId', '');
                $session_id = $request->get('sessionId', '');
                $subject_id = $request->get('subjectId', '');

                $studentsWithMarks = CurrentAcadmicStatus::with('student_details')
                    ->with(['MarksBySubject'=>function ($query) use ($exam_id,$class_id,$section_id,$session_id,$subject_id){
                        $query->where('exam_id',$exam_id);
                        $query->where('class_id',$class_id);
                        $query->where('section_id',$section_id);
                        $query->where('session_id',$session_id);
                        $query->where('subject_id',$subject_id);
                    }])
                    ->with('class')
                    ->with('section')
                    ->with('session')
                    ->where('class_id',$class_id)
                    ->where('section_id',$section_id)
                    ->where('session_id',$session_id)
                    ->orderBy('roll_no','asc')
                    ->get();


                $exam = Exams::find($exam_id);
                $subject = Subjects::find($subject_id);
                $data = [
                    'school_info' => Settings::first(),
                    'exam' => Exams::find($exam_id),
                    'subject' => Subjects::find($subject_id),
                    'studentsWithMarks' => $studentsWithMarks
                ];


                $arr_file_name[] = $subject->name;
                $arr_file_name[] = $exam->exam_name;
                $arr_file_name[] = strtotime("today");
                $arr_file_name[] = '.pdf';

                $pdf = PDF::loadView('results.pdf_subject_wise_marks_list',$data)
                ->setOptions(['defaultFont' => 'Courier'])
                ->setOptions(
                    ['isHtml5ParserEnabled' => true,
                    'enable_remote' => true,
                    'chroot'  => public_path(),
                ])
                ->setPaper('A4', 'portrait');
                if(!empty($data)){
                    $file_name = implode("-", $arr_file_name);
                }

                $path = public_path('pdf');
                $pdf->save($path . '/' . $file_name);
                $download_link = asset('pdf').'/'.$file_name;
                return response()->json([
                    'message'=>'PDF Marksheet Created Successfully, Please click to <a href="'.$download_link.'" target="_blank">View</a> Or <a href="'.$download_link.'" download>Download Now</a>'
                ]);
            } catch (\Exception $th) {
                return response()->json([
                    'message' => 'Not Found.Something went wrong. Please Try again.'
                ]);
            }


        }
    }


    public function MarksSheetBySubjectIDExcelExportToEdit(Request $request)
    {
        if ($request->ajax()) {
            $userID = Auth::user()->id;


            $examId = $request->get('examId', '');
            $classId = $request->get('classId', '');
            $sectionId = $request->get('sectionId', array());
            $sessionId = $request->get('sessionId', '');
            $subjectId = $request->get('subjectId', '');


            $offset = $request->get('start', 0);
           // dd($offset);
            $limit = $request->get('length', 10);
            if ($limit < 1 OR $limit > 100) {
                $limit = 100;
            }

            $search = isset($request->get('search')['value'])
                    ? $request->get('search')['value']
                    : null;

            $orderColumnList = [
                'id',
                 '',
                'name',
                'roll_name',
                'section_name'
            ];

            $orderColumnIndex = isset($request->get('order')[0]['column'])
                                ? $request->get('order')[0]['column']
                                : 0;
            $orderColumnDir = isset($request->get('order')[0]['dir'])
                                ? $request->get('order')[0]['dir']
                                : 'asc';

            $orderColumn = isset($orderColumnList[$orderColumnIndex])
                            ? $orderColumnList[$orderColumnIndex]
                            : 'name';

            $otherReportParams = [
                'search' => $search,
                'limit' => $limit,
                'offset' => $offset,
                'order_column' => $orderColumn,
                'order_dir' => $orderColumnDir,
                'exam_id' => $examId,
                'class_id' => $classId,
                'subject_id' => $subjectId,
            ];



            //dd($dataCount);



            if(isset($request->excel)){
                $excelParams = [
                    'search' => $request->get('excelSearch', ''),
                    'limit' => '-1', // for all
                    'offset' => '0',
                    'order_column' => $orderColumn,
                    'order_dir' => $orderColumnDir,
                    'exam_id' => $examId,
                    'class_id' => $classId,
                    'session_id' => $sessionId,
                    'subject_id' => $subjectId,
                ];



                $dataExcel = MarksBySubject::MarksEntryExcelExport($userID, $sectionId, $excelParams);

                $mark_type_ids = '';
                $fullmarks = '';
                foreach($dataExcel as $item){
                    $mark_type_ids = $item->mark_type_ids;
                    $fullmarks = $item->fullmarks;
                }

                $dataMarkTypes = DB::select(DB::raw("
                SELECT MARK_TYPE.id,MARK_TYPE.type,MARK_TYPE.position
                FROM `mark_types` MARK_TYPE
                WHERE MARK_TYPE.id in($mark_type_ids)
                "));



                //dd($dataExcel);


                $exam = Exams::select('exam_name')->where('id', $examId)->first();
                $session = Sessions::select('session_name')->where('id', $sessionId)->first();
                $class = Classes::select('class_name')->where('id', $classId)->first();
                $section = Sections::select('section_name')->where('id', $sectionId)->first();
                $subject = Subjects::select('name')->where('id', $subjectId)->first();


                $i=1;
                $excel_data = [];
                $array_mark_type_id = [];
                $array_dynamic_header_col = [];
                if ($dataMarkTypes) {
                    foreach($dataMarkTypes as $item){
                        $type_id = $item->id;
                        $type_name = $item->type;
                        array_push($array_mark_type_id,$type_id);
                        array_push($array_dynamic_header_col,$type_name);
                    }
                }

                foreach($dataExcel as $key=>$row)
                    {

                        // HIDDEN FIELD ON EXCEL FILE

                        $excel_data[$key]['exam_id']= $examId;
                        $excel_data[$key]['session_id']= $sessionId;
                        $excel_data[$key]['class_id']= $classId;
                        $excel_data[$key]['section_id']= $sectionId;
                        $excel_data[$key]['subject_id']= $subjectId;
                        $excel_data[$key]['is_fourth_subject']= $row->is_fourth_subject;
                        $excel_data[$key]['fullmarks']= $fullmarks;
                        $excel_data[$key]['json_pass_mark']= $row->pass_mark;
                        $excel_data[$key]['student_id']= $row->student_id;

                        $excel_data[$key]['sl']= $i++;
                        $excel_data[$key]['name']= $row->name;
                        $excel_data[$key]['roll_no']= $row->roll_no;
                        $excel_data[$key]['mark_type_ids']= implode(",",$array_mark_type_id);

                        $total_marks = 0;
                        if ($row->marks) {
                            $marksArr = explode(',',$row->marks);
                            $total_marks = array_sum($marksArr);
                            foreach($dataMarkTypes as $index=>$item){
                                $type_name = $item->type;
                                $excel_data[$key][$type_name] =  $marksArr[$index] ;
                            }
                        }
                        //$excel_data[$key]['total']= $total_marks;
                        //$excel_data[$key]['GPA']= Marks::PerSubjectGPAGeneratorByTotal($total_marks);
                        //$excel_data[$key]['GRADE']= Marks::PerSubjectLetterGradeGeneratorByTotal($total_marks);

                    }


                $heading_details['title'] = "..... High School";
                $heading_details['exam_name'] = $exam->exam_name;
                $heading_details['subject_name'] = $subject->name;
                $heading_details['session'] = $session->session_name;
                $heading_details['class'] =  $class->class_name;
                $heading_details['section'] = $section->section_name;
                $heading_details['fullmarks'] = $fullmarks;
                //$secreateCode = "Pincode : ".$sessionId.'-'.$classId.'-'.$sectionId.'-'.$subjectId;

                $export_order_analysis = new ExportMarksSheetBySubjectID($excel_data,$array_dynamic_header_col,$heading_details);
                if($section->section_name){ $section_name = "_".$section->section_name;}
                $file_name = "Report ".$subject->name."_".$class->class_name.$section_name."_".$session->session_name."_".$exam->exam_name;
                $excel = Excel::download($export_order_analysis, $file_name.'.xlsx');
                $excel->setContentDisposition('attachment','reports')->getFile()->move(public_path('/reports'), $file_name.'.xlsx');
                return asset('reports').'/'.$file_name.'.xlsx';
            }
        }
    }





            /**
     * Handle the `product stock report` datatable
     * Serverside Datatable
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     *
     */
    public function markSheetView(Request $request)
    {
        if ($request->ajax()) {
            $session_id = $request->session_id;
            $exam_id = $request->exam_id;
            $class_id = $request->class_id;
            $student_id = $request->student_id;

            $marksDetails = Marks::getMarkDetailsBySessionIDAndStudentID($session_id,$exam_id,$student_id);
                            $totalSubjects = count($marksDetails);
                            $arr_grade_point = array();
                            $arr_letter_grade = array();
                            $arr_marks = array();
                            foreach($marksDetails as $mark){
                                $arr_grade_point[] = $mark['grade_point'];
                                $arr_letter_grade[] = $mark['letter_grade'];
                                $arr_marks[] = $mark['total_obtained_marks'];
                            }
                            $totalSubjects = count($marksDetails);
                            $totalGP = array_sum($arr_grade_point);
                            $totalMarks = array_sum($arr_marks);

                            if(!empty($totalGP) && ($totalSubjects > 0) ){
                                $GPA = $totalGP/$totalSubjects;
                            }else{
                                $GPA = '0.00';
                            }


            $studentWithMarks = Marks::getStudentsWithMarkDetails($exam_id,$student_id);


            $currentSession =  $studentWithMarks->currentAcademicStatus[0]->session->session_name ?? '' ;
            $currentClass =  $studentWithMarks->currentAcademicStatus[0]->class->class_name ?? '' ;
            $currentSection =  $studentWithMarks->currentAcademicStatus[0]->section->section_name ?? '' ;

            $data = [
                'classes' => CurrentAcadmicStatus::join('classes', 'classes.id', '=', 'current_academic_status.class_id')
                            ->select('classes.*')->where('current_academic_status.student_id',$student_id)->get(),
                'sections' => CurrentAcadmicStatus::join('sections', 'sections.id', '=', 'current_academic_status.section_id')
                            ->select('sections.*')->where('current_academic_status.student_id',$student_id)->get(),
                'groups' => Groups::all(),
                'sessions' => CurrentAcadmicStatus::join('sessions', 'sessions.id', '=', 'current_academic_status.session_id')
                            ->select('sessions.*')->where('current_academic_status.student_id',$student_id)->orderBy('id', 'DESC')->get(),
                'exams' => Exams::orderBy('position', 'ASC')->get(),
                'mark_types' => $this->markTypeArray(),
                'studentWithMarks' => $studentWithMarks,
                'currentSession'=> $currentSession,
                'currentClass'=> $currentClass,
                'currentSection'=> $currentSection,
                'subjects_id_name_Arr' => $this->subjectIdNameArray(),
                'totalMarks' => number_format((float)$totalMarks, 2, '.', ''),
                'totalGP' => number_format((float)$totalGP, 2, '.', ''),
                'GPA' => number_format((float)$GPA, 2, '.', ''),
            ];



            return view('marks.view_mark_sheet', $data);
        }
    }

    private function markTypeArray(){
        $markTypes = MarkTypes::orderBy('position', 'ASC')->get();
        if(!empty($markTypes)){
            foreach($markTypes as $item){
                $arrMark[$item->id] = strtoupper($item->type);
            }
            return $arrMark;
        }
    }

    private function subjectIdNameArray(){
        $subjects = Subjects::orderBy('name', 'ASC')->get();
        if(!empty($subjects)){
            foreach($subjects as $item){
                $arrMark[$item->id] = strtoupper($item->name);
            }
            return $arrMark;
        }
    }


}
