<?php

namespace App\Http\Controllers;
use App\Models\Student;
use App\Models\Exams;
use App\Models\Classes;
use App\Models\Sections;
use App\Models\Sessions;
use App\Models\Groups;
use App\Models\Subjects;
use App\Models\MarkTypes;
use App\Models\Marks;
use App\Models\MarksByClass;
use App\Models\CurrentAcadmicStatus;


use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Datatables;
use DB;
use PDF;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB as FacadesDB;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Hash;
use Maatwebsite\Excel\Facades\Excel;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use Illuminate\Support\Str;

use App\Exports\MarksEntryFromExport;
use App\Imports\MarksImportExcel;
class MarksReportByClassController extends Controller
{


    /**
     * Load `Marks Entry Form ` Page >> URL : .../marks_by_class
    */
    public function MarksReportByClassPage()
    {


        $data = [
            'exams' => Exams::orderBy('position', 'ASC')->get(),
            'classes' => Classes::get(),
            'sections' => Sections::get(),
            'sessions' => Sessions::orderBy('id', 'DESC')->get(),
            'subjects' => Subjects::orderBy('name', 'ASC')->get(),
            'mark_types' => MarkTypes::orderBy('position', 'ASC')->get(),
        ];
        return view('results.marks_by_class', $data);
    }




    /**
     * Handle the `marks entry form ` datatable
     * Serverside Datatable
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     *
     */
    public function MarksReportByClassDataTable(Request $request)
    {
        if ($request->ajax()) {
            $personId = Auth::user()->id;


            $examId = $request->get('examId', '');
            $classId = $request->get('classId', '');
            $sectionId = $request->get('sectionId', array());
            $sessionId = $request->get('sessionId', '');
            $subjectId = $request->get('subjectId', '');
            $markTypes = $request->get('markTypes', array());

            if(!empty($markTypes)){
                $strMarksTypes = implode(",",$markTypes);



            //dd($dataCount);
                $dataMarkTypes = DB::select(DB::raw("
                    SELECT MARK_TYPE.type,MARK_TYPE.position
                    FROM `mark_types` MARK_TYPE
                    WHERE MARK_TYPE.id in($strMarksTypes)
                    "));

            }

            $studentWithMarks = CurrentAcadmicStatus::with('student_details')
                ->with(['MarksDetails' => function ($query)  use ($examId,$classId) {
                $query->where('exam_id',$examId);
                $query->where('class_id',$classId);
                    }])
                ->where('current_academic_status.class_id',$classId)
                ->where('current_academic_status.section_id',$sectionId)
                ->where('current_academic_status.session_id',$sessionId)
                ->with('session')
                ->with('class')
                ->with('section')
                ->get();
            //dd($studentWithMarks);
            $table = Datatables::of($studentWithMarks)
                        ->addColumn('name', function ($row) {
                            if(isset($row->student_details->name)){
                                return $row->student_details->name;
                            }
                        })

                        ->addColumn('roll_no', function ($row) {
                            if(isset($row->student_details->roll_no)){
                                return $row->student_details->roll_no;
                            }
                        })



                        ->addColumn('marks', function ($row) {
                            //dd($row->MarksDetails);
                            $table = "<table id='mark_table' border=0 class='w-full' style='text-align:center;'>";
                            foreach($row->MarksDetails as $details){
                                $markType_ids = explode(',',$details->mark_type_ids);
                                $markType = MarkTypes::whereIn('id', $markType_ids)->get();

                                $subjectName = $details->subject->name;
                                $shortName = $details->subject->short_name;

                                $typeCount = count($markType);
                                $table .= "<td style='border:0px solid #000 !important;'>";
                                $table .= "<table border=1 class=''>";
                                $table .= "<tr>";
                                $table .= "<td colspan='".$typeCount."'>".$shortName."</td>";
                                $table .= "</tr>";

                                $table .= "<tr>";
                                    foreach($markType as $item){
                                        $typeName = substr($item->type, 0, 1);
                                        $table .= "<td>".$typeName."</td>";
                                    }
                                $table .= "</tr>";

                                $table .= "<tr>";
                                    $marks = explode(',',$details->marks);
                                    foreach($marks as $mark){
                                        $table .= "<td>".$mark."</td>";
                                    }
                                $table .= "</tr>";
                                $table .= "</table>";
                                $table .= "</td>";
                            }
                            $table .= "</table>";
                            return $table;
                        })


                        ->addColumn('total', function ($row) {
                            $grandTotal = array();
                            foreach($row->MarksDetails as $details){
                                $markType_ids = explode(',',$details->mark_type_ids);
                                $markType = MarkTypes::whereIn('id', $markType_ids)->get();

                                $subjectName = $details->subject->name;
                                $shortName = $details->subject->short_name;
                                $marks = explode(',',$details->marks);
                                $grandTotal[] = array_sum($marks);
                            }

                            return array_sum($grandTotal);

                        })
                        ->addColumn('gpa', function ($row) {

                            $arrGP = array();
                            foreach($row->MarksDetails as $details){
                                $markType_ids = explode(',',$details->mark_type_ids);
                                $markType = MarkTypes::whereIn('id', $markType_ids)->get();

                                $subjectName = $details->subject->name;
                                $shortName = $details->subject->short_name;
                                $marks = explode(',',$details->marks);
                                $total = array_sum($marks);
                                $arrGP[] = Marks::PerSubjectGPAGeneratorByTotal($total);

                            }

                           $totalGP = array_sum($arrGP);
                           $subjectCount = count($arrGP);
                           $GPA = '0.0';
                           if($subjectCount>0){
                               $GPA = $totalGP/$subjectCount;
                           }
                           return number_format($GPA,2);
                        })
                        ->addColumn('grade', function ($row) {

                            $arrGP = array();
                            foreach($row->MarksDetails as $details){
                                $markType_ids = explode(',',$details->mark_type_ids);
                                $markType = MarkTypes::whereIn('id', $markType_ids)->get();

                                $subjectName = $details->subject->name;
                                $shortName = $details->subject->short_name;
                                $marks = explode(',',$details->marks);
                                $total = array_sum($marks);
                                $arrGP[] = Marks::PerSubjectGPAGeneratorByTotal($total);

                            }

                           $totalGP = array_sum($arrGP);
                           $subjectCount = count($arrGP);
                           $GPA = '0.0';
                           if($subjectCount>0){
                               $GPA = $totalGP/$subjectCount;
                           }

                            $letter_grade = Marks::PerSubjectLetterGradeGeneratorByGPA($GPA);
                            return $letter_grade;
                        })



                        ->rawColumns(['name', 'roll_no','marks'])
                        ->skipPaging()
                        //->setTotalRecords($dataCount)
                        ->make(true);

            return $table;
        }
    }




    /**
     * Handle the `product stock report` datatable
     * Serverside Datatable
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     *
     */
    public function markSheetView(Request $request)
    {
        if ($request->ajax()) {
            $session_id = $request->session_id;
            $exam_id = $request->exam_id;
            $class_id = $request->class_id;
            $student_id = $request->student_id;

            $marksDetails = Marks::getMarkDetailsBySessionIDAndStudentID($session_id,$exam_id,$student_id);
                            $totalSubjects = count($marksDetails);
                            $arr_grade_point = array();
                            $arr_letter_grade = array();
                            $arr_marks = array();
                            foreach($marksDetails as $mark){
                                $arr_grade_point[] = $mark['grade_point'];
                                $arr_letter_grade[] = $mark['letter_grade'];
                                $arr_marks[] = $mark['total_obtained_marks'];
                            }
                            $totalSubjects = count($marksDetails);
                            $totalGP = array_sum($arr_grade_point);
                            $totalMarks = array_sum($arr_marks);

                            if(!empty($totalGP) && ($totalSubjects > 0) ){
                                $GPA = $totalGP/$totalSubjects;
                            }else{
                                $GPA = '0.00';
                            }


            $studentWithMarks = Marks::getStudentsWithMarkDetails($exam_id,$student_id);


            $currentSession =  $studentWithMarks->currentAcademicStatus[0]->session->session_name ?? '' ;
            $currentClass =  $studentWithMarks->currentAcademicStatus[0]->class->class_name ?? '' ;
            $currentSection =  $studentWithMarks->currentAcademicStatus[0]->section->section_name ?? '' ;

            $data = [
                'classes' => CurrentAcadmicStatus::join('classes', 'classes.id', '=', 'current_academic_status.class_id')
                            ->select('classes.*')->where('current_academic_status.student_id',$student_id)->get(),
                'sections' => CurrentAcadmicStatus::join('sections', 'sections.id', '=', 'current_academic_status.section_id')
                            ->select('sections.*')->where('current_academic_status.student_id',$student_id)->get(),
                'groups' => Groups::all(),
                'sessions' => CurrentAcadmicStatus::join('sessions', 'sessions.id', '=', 'current_academic_status.session_id')
                            ->select('sessions.*')->where('current_academic_status.student_id',$student_id)->orderBy('id', 'DESC')->get(),
                'exams' => Exams::orderBy('position', 'ASC')->get(),
                'mark_types' => $this->markTypeArray(),
                'studentWithMarks' => $studentWithMarks,
                'currentSession'=> $currentSession,
                'currentClass'=> $currentClass,
                'currentSection'=> $currentSection,
                'subjects_id_name_Arr' => $this->subjectIdNameArray(),
                'totalMarks' => number_format((float)$totalMarks, 2, '.', ''),
                'totalGP' => number_format((float)$totalGP, 2, '.', ''),
                'GPA' => number_format((float)$GPA, 2, '.', ''),
            ];



            return view('marks.view_mark_sheet', $data);
        }
    }


        /**
     * Handle the `product stock report` datatable
     * Serverside Datatable
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     *
     */
    public function MarksSheetByClassPDFExport(Request $request)
    {

        if($request->ajax()) {
            $personId = Auth::user()->id;

            $session_id = $request->session_id;
            $exam_id = $request->exam_id;
            $class_id = $request->class_id;
            $section_id = $request->section_id;


            $offset = $request->get('start', 0);

            $limit = $request->get('length', 10);
            if ($limit < 1 or $limit > 100) {
                $limit = 100;
            }

            $search = isset($request->get('search')['value'])
                ? $request->get('search')['value']
                : null;

            $orderColumnList = [
                'id',
                '',
                'name',
                'roll_name',
                'section_name'
            ];

            $orderColumnIndex = isset($request->get('order')[0]['column'])
                ? $request->get('order')[0]['column']
                : 0;
            $orderColumnDir = isset($request->get('order')[0]['dir'])
                ? $request->get('order')[0]['dir']
                : 'asc';

            $orderColumn = isset($orderColumnList[$orderColumnIndex])
                ? $orderColumnList[$orderColumnIndex]
                : 'name';

            $otherReportParams = [
                'search' => $search,
                'limit' => $limit,
                'offset' => $offset,
                'order_column' => $orderColumn,
                'order_dir' => $orderColumnDir,
                'exam_id' => $exam_id,
                'class_id' => $class_id,
                'section_id' => $section_id,
                'session_id' => $session_id,
            ];


            $studentWithMarks = CurrentAcadmicStatus::with('student_details')
                ->with([
                    'MarksDetails' => function ($query) use ($exam_id, $class_id) {
                        $query->where('exam_id', $exam_id);
                        $query->where('class_id', $class_id);
                    }
                ])
                ->where('current_academic_status.class_id', $class_id)
                ->where('current_academic_status.section_id', $section_id)
                ->where('current_academic_status.session_id', $session_id)
                ->with('session')
                ->with('class')
                ->with('section')
                ->get();


            $customPaper = array(0, 0, 60.00, 50.80);

            $width = '600';
            $height = '1200';

            $pdf = PDF::loadView('results.generate-class-wise-marks-report-pdf', compact('studentWithMarks'))
                ->setOptions(['defaultFont' => 'Courier'])
                ->setOptions(['isHtml5ParserEnabled' => true, 'isRemoteEnabled' => true])
                ->setPaper('A3', 'portrait');
            $time = strtotime("today");
            return $pdf->download('Tabulation Sheet-' . $time . '.pdf');
        }

    }



    private function markTypeArray(){
        $markTypes = MarkTypes::orderBy('position', 'ASC')->get();
        if(!empty($markTypes)){
            foreach($markTypes as $item){
                $arrMark[$item->id] = strtoupper($item->type);
            }
            return $arrMark;
        }
    }

    private function subjectIdNameArray(){
        $subjects = Subjects::orderBy('name', 'ASC')->get();
        if(!empty($subjects)){
            foreach($subjects as $item){
                $arrMark[$item->id] = strtoupper($item->name);
            }
            return $arrMark;
        }
    }


}
