<?php

namespace App\Http\Controllers;
use App\Models\Student;
use App\Models\Exams;
use App\Models\Classes;
use App\Models\Sections;
use App\Models\Sessions;
use App\Models\Groups;
use App\Models\Subjects;
use App\Models\MarkTypes;
use App\Models\Marks;
use App\Models\MarksEntryForm;
use App\Models\CurrentAcadmicStatus;


use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Datatables;
use DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB as FacadesDB;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Hash;
use Maatwebsite\Excel\Facades\Excel;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use Illuminate\Support\Str;

use App\Exports\MarksEntryFromExport;
use App\Exports\MarksSheetBySubjectID;
use App\Imports\MarksImportExcel;

class MarksExportImportController extends Controller
{


    /**
     * Load `Marks Entry Form ` Page >> URL : .../marks_entry_form
    */
    public function marksEntryForm()
    {


        $data = [
            'exams' => Exams::orderBy('position', 'ASC')->get(),
            'classes' => Classes::get(),
            'sections' => Sections::get(),
            'sessions' => Sessions::orderBy('id', 'DESC')->get(),
            'subjects' => Subjects::orderBy('name', 'ASC')->get(),
            'mark_types' => MarkTypes::orderBy('position', 'ASC')->get(),
        ];
        return view('marks.marks_entry_form', $data);
    }


     /**
     * Load `Marks Entry Form ` Page >> URL : .../marks_entry_form
    */
    public function marksExcelImportForm()
    {

        $data = [
            'classes' => Classes::get(),
            'sections' => Sections::get(),
            'sessions' => Sessions::orderBy('id', 'DESC')->get(),
            'subjects' => Subjects::orderBy('name', 'ASC')->get(),
            'mark_types' => MarkTypes::orderBy('position', 'ASC')->get(),
        ];
        return view('marks.marks_excel_import_form', $data);
    }


    /**
    * @return \Illuminate\Support\Collection
    */
    public function excelImport()
    {

        $file = request()->file('file');
        if($file) {
            Excel::import(new MarksImportExcel,$file);
            return back()->with('success', 'Marks imported successfully. Please View on Report.');
        }else{
            return back()->with('error', 'Please Select File');
        }

    }


    /**
     * Handle the `marks entry form ` datatable
     * Serverside Datatable
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     *
     */
    public function MarksEntryDataTable(Request $request)
    {
        if ($request->ajax()) {
            $personId = Auth::user()->id;


            $classId = $request->get('classId', '');
            $sectionId = $request->get('sectionId', array());
            $sessionId = $request->get('sessionId', '');
            $subjectId = $request->get('subjectId', '');
            $markTypes = $request->get('markTypes', array());


            $offset = $request->get('start', 0);
            $limit = $request->get('length', 10);
            if ($limit < 1 OR $limit > 100) {
                $limit = 100;
            }

            $search = isset($request->get('search')['value'])
                    ? $request->get('search')['value']
                    : null;

            $orderColumnList = [
                'id',
                 '',
                'name',
                'roll_name',
                'section_name'
            ];

            $orderColumnIndex = isset($request->get('order')[0]['column'])
                                ? $request->get('order')[0]['column']
                                : 0;
            $orderColumnDir = isset($request->get('order')[0]['dir'])
                                ? $request->get('order')[0]['dir']
                                : 'asc';

            $orderColumn = isset($orderColumnList[$orderColumnIndex])
                            ? $orderColumnList[$orderColumnIndex]
                            : 'name';

            $otherReportParams = [
                'search' => $search,
                'limit' => $limit,
                'offset' => $offset,
                'order_column' => $orderColumn,
                'order_dir' => $orderColumnDir,
                'session_id' => $sessionId,
                'class_id' => $classId,
                'subject_id' => $subjectId
            ];

            if(!empty($markTypes)){
                $strMarksTypes = implode(",",$markTypes);



            //dd($dataCount);
                $dataMarkTypes = DB::select(DB::raw("
                    SELECT MARK_TYPE.type,MARK_TYPE.position
                    FROM `mark_types` MARK_TYPE
                    WHERE MARK_TYPE.id in($strMarksTypes)
                    "));

            }


            $studentWithMarks = CurrentAcadmicStatus::join('students', 'students.id', '=', 'current_academic_status.student_id')
            ->with('session')
            ->with('class')
            ->with('section')
            //->where('students.roll_no',$roll_no)
            ->where('current_academic_status.class_id',$classId)
            ->where('current_academic_status.section_id',$sectionId)
            ->where('current_academic_status.session_id',$sessionId)
            ->orderBy('current_academic_status.id','desc')
            ->select('current_academic_status.*','students.name')
            ->orderBy('students.roll_no','asc')
            ->get();
           // dd($studentWithMarks);
            $table = Datatables::of($studentWithMarks)
                        ->addColumn('name', function ($row) {
                            return $row->name;
                        })

                        ->addColumn('roll_no', function ($row) {
                            return $row->roll_no;
                        })

                        ->addColumn('class_name', function ($row) {
                            return $row->class->class_name;
                        })
                        ->addColumn('section_name', function ($row) {
                            return $row->section->section_name;
                        })
                        ->addColumn('session_name', function ($row) {
                            return $row->session->session_name;
                        })

                        ->rawColumns(['name', 'roll_no', 'class_name', 'section_name'])
                        ->skipPaging()
                        //->setTotalRecords($dataCount)
                        ->make(true);

            return $table;
        }
    }



     /**
     * Handle the `product stock report` datatable
     * Serverside Datatable
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     *
     */
    public function MinimumPassMarkSetting(Request $request)
    {

        $markTypes = MarkTypes::whereIn('id',$request->markTypes)->orderBy('id', 'ASC')->get();
        return view('marks.minimum_pass_mark_setting', compact(['markTypes']));
    }
    /**
     * Handle the `product stock report` datatable
     * Serverside Datatable
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     *
     */
    public function MarksEntryExcelExport(Request $request)
    {
        if ($request->ajax()) {
            $personId = Auth::user()->id;


            $examId = $request->get('examId', '');
            $classId = $request->get('classId', '');
            $sectionId = $request->get('sectionId', array());
            $sessionId = $request->get('sessionId', '');
            $subjectId = $request->get('subjectId', '');
            $markTypes = $request->get('markTypes', array());
            $isFourthSubject = $request->get('isFourthSubject', array());
            $fullmarks = $request->get('fullmarks', '');
            $json_pass_mark = $request->get('json_pass_mark', '');

            $offset = $request->get('start', 0);
            $limit = $request->get('length', 10);
            if ($limit < 1 OR $limit > 100) {
                $limit = 100;
            }

            $search = isset($request->get('search')['value'])
                    ? $request->get('search')['value']
                    : null;

            $orderColumnList = [
                'id',
                 '',
                'name',
                'roll_name',
                'section_name'
            ];

            $orderColumnIndex = isset($request->get('order')[0]['column'])
                                ? $request->get('order')[0]['column']
                                : 0;
            $orderColumnDir = isset($request->get('order')[0]['dir'])
                                ? $request->get('order')[0]['dir']
                                : 'asc';

            $orderColumn = isset($orderColumnList[$orderColumnIndex])
                            ? $orderColumnList[$orderColumnIndex]
                            : 'name';

            $otherReportParams = [
                'search' => $search,
                'limit' => $limit,
                'offset' => $offset,
                'order_column' => $orderColumn,
                'order_dir' => $orderColumnDir,
                'exam_id' => $examId,
                'class_id' => $classId,
                'section_id' => $sectionId,
                'subject_id' => $subjectId,
                'is_fourth_subject' => $isFourthSubject,
                'fullmarks' => $fullmarks,
            ];

            if(!empty($markTypes)){
                $mark_type_ids = implode(",",$markTypes);

           // dd($strMarksTypes);
                $dataMarkTypes = DB::select(DB::raw("
                    SELECT MARK_TYPE.id,MARK_TYPE.type,MARK_TYPE.position
                    FROM `mark_types` MARK_TYPE
                    WHERE MARK_TYPE.id in($mark_type_ids)
                    "));

            }



            if(isset($request->excel)){

                 $data = CurrentAcadmicStatus::with('student_details')
                ->with('session')
                ->with('class')
                ->with('section')
                ->where('current_academic_status.class_id',$classId)
                ->where('current_academic_status.section_id',$sectionId)
                ->where('current_academic_status.session_id',$sessionId)
                ->orderBy('current_academic_status.roll_no','asc')
                ->get();

                $exam = Exams::select('exam_name')->where('id', $examId)->first();
                $subject = Subjects::select('name')->where('id', $subjectId)->first();


                $i=1;
                $excel_data = [];
                $array_mark_type_id = [];
                $array_dynamic_header_col = [];
                if($dataMarkTypes) {
                    foreach($dataMarkTypes as $item){
                        $type_id = $item->id;
                        $type_name = $item->type;
                        array_push($array_mark_type_id,$type_id);
                        array_push($array_dynamic_header_col,$type_name);
                    }
                }

                if ($data) {
                    foreach ($data as $key => $row) {

                        // HIDDEN FIELD ON EXCEL FILE
                        $excel_data[$key]['exam_id'] = $examId;
                        $excel_data[$key]['session_id'] = $sessionId;
                        $excel_data[$key]['class_id'] = $classId;
                        $excel_data[$key]['section_id'] = $sectionId;
                        $excel_data[$key]['subject_id'] = $subjectId;
                        $excel_data[$key]['is_fourth_subject'] = $isFourthSubject;
                        $excel_data[$key]['fullmarks'] = $fullmarks;
                        $excel_data[$key]['mark_type_ids'] = implode(",", $array_mark_type_id);
                        $excel_data[$key]['json_pass_mark'] = $json_pass_mark;
                        $excel_data[$key]['student_id'] = $row->student_id;

                        $excel_data[$key]['sl'] = $i++;
                        $excel_data[$key]['name'] = $row->student_details->name;
                        $excel_data[$key]['roll_no'] = $row->roll_no;

                        if ($dataMarkTypes) {
                            foreach ($dataMarkTypes as $item) {
                                $type_name = $item->type;
                                $excel_data[$key][$type_name] = '';
                            }
                        }

                    }

                  //  dd($excel_data);
                    $heading_details['title'] = "..... High School";
                    $heading_details['exam_name'] = $exam->exam_name;
                    $heading_details['subject_name'] = $subject->name;
                    $heading_details['session'] = $data[0]->session->session_name;
                    $heading_details['class'] =  $data[0]->class->class_name;
                    $heading_details['section'] = $data[0]->section->section_name;
                    $heading_details['fullmarks'] = $fullmarks;
                    //$secreateCode = "Pincode : ".$sessionId.'-'.$classId.'-'.$sectionId.'-'.$subjectId;

                    $export_marks_entry_form = new MarksEntryFromExport($excel_data,$array_dynamic_header_col,$heading_details);

                    $arr_file_name[] = $subject->name;
                    $arr_file_name[] = $data[0]->class->class_name;
                    $arr_file_name[] = $data[0]->section->section_name;
                    $arr_file_name[] = $data[0]->session->session_name;
                    $arr_file_name[] = $exam->exam_name;

                    $file_name = implode("_", $arr_file_name);

                    $excel = Excel::download($export_marks_entry_form, $file_name.'.xlsx');
                    $excel->setContentDisposition('attachment','marks-entry-from')->getFile()->move(public_path('/marks-entry-from'), $file_name.'.xlsx');
                    return asset('marks-entry-from').'/'.$file_name.'.xlsx';
                }
            }
        }
    }



            /**
     * Handle the `product stock report` datatable
     * Serverside Datatable
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     *
     */
    public function markSheetView(Request $request)
    {
        if ($request->ajax()) {
            $session_id = $request->session_id;
            $exam_id = $request->exam_id;
            $class_id = $request->class_id;
            $student_id = $request->student_id;

            $marksDetails = Marks::getMarkDetailsBySessionIDAndStudentID($session_id,$exam_id,$student_id);
                            $totalSubjects = count($marksDetails);
                            $arr_grade_point = array();
                            $arr_letter_grade = array();
                            $arr_marks = array();
                            foreach($marksDetails as $mark){
                                $arr_grade_point[] = $mark['grade_point'];
                                $arr_letter_grade[] = $mark['letter_grade'];
                                $arr_marks[] = $mark['total_obtained_marks'];
                            }
                            $totalSubjects = count($marksDetails);
                            $totalGP = array_sum($arr_grade_point);
                            $totalMarks = array_sum($arr_marks);

                            if(!empty($totalGP) && ($totalSubjects > 0) ){
                                $GPA = $totalGP/$totalSubjects;
                            }else{
                                $GPA = '0.00';
                            }


            $studentWithMarks = Student::with(['MarksDetails' => function ($query)  use ($exam_id) {
                $query->where('exam_id',$exam_id);
                }])
                ->with(['currentAcademicStatus' => function ($query){
                    $query->orderBy('id','desc');
                }])
                ->where('id',$student_id)->first();
            $currentSession =  $studentWithMarks->currentAcademicStatus[0]->session->session_name ?? '' ;
            $currentClass =  $studentWithMarks->currentAcademicStatus[0]->class->class_name ?? '' ;
            $currentSection =  $studentWithMarks->currentAcademicStatus[0]->section->section_name ?? '' ;
            $currentExam =  Exams::where('id', $exam_id)->first() ;

            $data = [
                'classes' => CurrentAcadmicStatus::join('classes', 'classes.id', '=', 'current_academic_status.class_id')
                            ->select('classes.*')->where('current_academic_status.student_id',$student_id)->get(),
                'sections' => CurrentAcadmicStatus::join('sections', 'sections.id', '=', 'current_academic_status.section_id')
                            ->select('sections.*')->where('current_academic_status.student_id',$student_id)->get(),
                'groups' => Groups::all(),
                'sessions' => CurrentAcadmicStatus::join('sessions', 'sessions.id', '=', 'current_academic_status.session_id')
                            ->select('sessions.*')->where('current_academic_status.student_id',$student_id)->orderBy('id', 'DESC')->get(),
                'exams' => Exams::orderBy('position', 'ASC')->get(),
                'mark_types' => $this->markTypeArray(),
                'currentExam' => $currentExam,
                'studentWithMarks' => $studentWithMarks,
                'currentSession'=> $currentSession,
                'currentClass'=> $currentClass,
                'currentSection'=> $currentSection,
                'subjects_id_name_Arr' => $this->subjectIdNameArray(),
                'totalMarks' => number_format((float)$totalMarks, 2, '.', ''),
                'totalGP' => number_format((float)$totalGP, 2, '.', ''),
                'GPA' => number_format((float)$GPA, 2, '.', ''),
            ];



            return view('marks.view_mark_sheet', $data);
        }
    }




    private function markTypeArray(){
        $markTypes = MarkTypes::orderBy('position', 'ASC')->get();
        if(!empty($markTypes)){
            foreach($markTypes as $item){
                $arrMark[$item->id] = strtoupper($item->type);
            }
            return $arrMark;
        }
    }

    private function subjectIdNameArray(){
        $subjects = Subjects::orderBy('name', 'ASC')->get();
        if(!empty($subjects)){
            foreach($subjects as $item){
                $arrMark[$item->id] = strtoupper($item->name);
            }
            return $arrMark;
        }
    }


}
