<?php

namespace App\Http\Controllers;
use App\Models\Student;
use App\Models\Exams;
use App\Models\Classes;
use App\Models\Sections;
use App\Models\Sessions;
use App\Models\Groups;
use App\Models\Subjects;
use App\Models\MarkTypes;
use App\Models\Marks;
use App\Models\MarksEntryForm;
use App\Models\CurrentAcadmicStatus;


use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Datatables;
use DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB as FacadesDB;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Hash;
use Maatwebsite\Excel\Facades\Excel;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use Illuminate\Support\Str;

use App\Exports\MarksEntryFromExport;
use App\Imports\MarksImportExcel;
class MarksController extends Controller
{


    /**
     * Handle the `product stock report` datatable
     * Serverside Datatable
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     *
     */
    public function printMarkSheet(Request $request)
    {
        if ($request->ajax()) {
            $session_id = $request->session_id;
            $exam_id = $request->exam_id;
            $class_id = $request->class_id;
            $student_id = $request->student_id;

            $marksDetails = Marks::getMarkDetailsBySessionIDAndStudentID($session_id,$exam_id,$student_id);
                            $totalSubjects = count($marksDetails);
                            $arr_grade_point = array();
                            $arr_letter_grade = array();
                            $arr_marks = array();
                            foreach($marksDetails as $mark){
                                $arr_grade_point[] = $mark['grade_point'];
                                $arr_letter_grade[] = $mark['letter_grade'];
                                $arr_marks[] = $mark['total_obtained_marks'];
                            }
                            $totalSubjects = count($marksDetails);
                            $totalGP = array_sum($arr_grade_point);
                            $totalMarks = array_sum($arr_marks);

                            if(!empty($totalGP) && ($totalSubjects > 0) ){
                                $GPA = $totalGP/$totalSubjects;
                            }else{
                                $GPA = '0.00';
                            }


            $studentWithMarks = Student::with(['MarksDetails' => function ($query)  use ($exam_id) {
                $query->where('exam_id',$exam_id);
                }])
                ->with(['currentAcademicStatus' => function ($query){
                    $query->orderBy('id','desc');
                }])
                ->where('id',$student_id)->first();
            $currentSession =  $studentWithMarks->currentAcademicStatus[0]->session->session_name ?? '' ;
            $currentClass =  $studentWithMarks->currentAcademicStatus[0]->class->class_name ?? '' ;
            $currentSection =  $studentWithMarks->currentAcademicStatus[0]->section->section_name ?? '' ;


            //dd($studentWithMarks);
            $data = [
                'classes' => CurrentAcadmicStatus::join('classes', 'classes.id', '=', 'current_academic_status.class_id')
                            ->select('classes.*')->where('current_academic_status.student_id',$student_id)->get(),
                'sections' => CurrentAcadmicStatus::join('sections', 'sections.id', '=', 'current_academic_status.section_id')
                            ->select('sections.*')->where('current_academic_status.student_id',$student_id)->get(),
                'groups' => Groups::all(),
                'sessions' => CurrentAcadmicStatus::join('sessions', 'sessions.id', '=', 'current_academic_status.session_id')
                            ->select('sessions.*')->where('current_academic_status.student_id',$student_id)->orderBy('id', 'DESC')->get(),
                'exams' => Exams::orderBy('position', 'ASC')->get(),
                'mark_types' => $this->markTypeArray(),
                'studentWithMarks' => $studentWithMarks,
                'currentSession'=> $currentSession,
                'currentClass'=> $currentClass,
                'currentSection'=> $currentSection,
                'subjects_id_name_Arr' => $this->subjectIdNameArray(),
                'totalMarks' => number_format((float)$totalMarks, 2, '.', ''),
                'totalGP' => number_format((float)$totalGP, 2, '.', ''),
                'GPA' => number_format((float)$GPA, 2, '.', ''),
            ];

            return view('marks.view_mark_sheet', $data);
        }
    }

    private function markTypeArray(){
        $markTypes = MarkTypes::orderBy('position', 'ASC')->get();
        if(!empty($markTypes)){
            foreach($markTypes as $item){
                $arrMark[$item->id] = strtoupper($item->type);
            }
            return $arrMark;
        }
    }

    private function subjectIdNameArray(){
        $subjects = Subjects::orderBy('name', 'ASC')->get();
        if(!empty($subjects)){
            foreach($subjects as $item){
                $arrMark[$item->id] = strtoupper($item->name);
            }
            return $arrMark;
        }
    }


}
