<?php

namespace App\Http\Controllers;
use App\Models\Student;
use App\Models\Classes;
use App\Models\Sections;
use App\Models\Groups;
use App\Models\Sessions;
use App\Models\Settings;
use App\Models\CurrentAcadmicStatus;
use App\Models\FeeTypes;
use App\Models\StudentFee;
use App\Models\Banks;
use App\Models\MobileWalets;



use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Datatables;
use DB;
use PDF;
class FeeDetailsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {


        $arr_param['personId'] = Auth::user()->id;
        Session::put('itemArray', []);

        $data = [
            'classes' => Classes::get(),
            'sections' => Sections::get(),
            'sessions' => Sessions::orderBy('id', 'DESC')->get(),
            'MonthArray' => StudentFee:: MonthArray()
        ];

        return view('student_fee.index', $data);
    }


    /**
     * Handle datatable serverside
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function data(Request $request)
    {
        if ($request->ajax()) {
            $classId = $request->get('classId', '');
            $sectionId = $request->get('sectionId', array());
            $sessionId = $request->get('sessionId', '');

            $offset = $request->get('start', 0);
            $limit = $request->get('length', 10);
            if ($limit < 1 OR $limit > 100) {
                $limit = 100;
            }

            $search = isset($request->get('search')['value'])
                    ? $request->get('search')['value']
                    : null;

            $orderColumnList = [
                'roll_no',
                'id',
                 '',
                'name',
                'roll_name',
                'section_name'
            ];

            $orderColumnIndex = isset($request->get('order')[0]['column'])
                                ? $request->get('order')[0]['column']
                                : 0;
            $orderColumnDir = isset($request->get('order')[0]['dir'])
                                ? $request->get('order')[0]['dir']
                                : 'desc';

            $orderColumn = isset($orderColumnList[$orderColumnIndex])
                            ? $orderColumnList[$orderColumnIndex]
                            : 'name';

            $otherReportParams = [
                'search' => $search,
                'limit' => $limit,
                'offset' => $offset,
                'order_column' => $orderColumn,
                'order_dir' => $orderColumnDir,
                'class_id' => $classId,
            ];

            $MonthArray = StudentFee:: MonthArray();
            $now = Carbon::now();
            $MonthArray = array_chunk($MonthArray, 6);
            $prevMonthArr = $MonthArray[0];


            $nextMonthArr = array();
            if(isset($MonthArray[1])){
                $nextMonthArr = $MonthArray[1];
            }

            $personId = Auth::user()->id;

            $studentWithFees = CurrentAcadmicStatus::with('student_details')
            ->with(['FeeDetails' => function ($query) use ($sessionId){
                $query->where('session_id',$sessionId);
                }])
                ->where('current_academic_status.class_id',$classId)
                ->where('current_academic_status.section_id',$sectionId)
                ->where('current_academic_status.session_id',$sessionId)
                ->with('session')
                ->with('class')
                ->with('section')
                ->get();



            $table = Datatables::of($studentWithFees)

            ->addColumn('details', function ($row) {

                           $student_id = isset($row->student_details->id) ? $row->student_details->id : '';
                           $student_code = isset($row->student_details->student_code) ? $row->student_details->student_code : '';

                           $roll_no = isset($row->roll_no) ? $row->roll_no : '';
                           $name = isset($row->student_details->name) ? $row->student_details->name : '';

                            return '
                            <div class="flex flex-row gap-4" id="">
                            <div class="w-1/2 sm:w-full md:w-fulllg:w-full">
                                <div class="mb-3">
                                    <img src="http://127.0.0.1:8000/No-Image-Found.png" style="width:100px !important" class="w-full h-auto">
                                </div>
                                <div class="mb-3">
                                    <span class="text-blue-500 font-bold">
                                        Student ID : <strong>'. $student_code .'</strong><br>
                                    </span>

                                    <span class="text-blue-500 font-bold">
                                        Roll No : <strong>'. $roll_no .'</strong><br>
                                    </span>

                                    <span class="whitespace-nowrap cursor-pointer hover:text-blue-500">
                                    <a href=""class="underline text-blue-500 font-bold">
                                        Name: '.$name.'
                                        </a>
                                    </span><br>

                                    <span class="whitespace-nowrap cursor-pointer hover:text-blue-500">
                                    Class : <strong> '. $row->class->class_name .' </strong>
                                    </span>

                                    <span class="whitespace-nowrap cursor-pointer hover:text-blue-500">
                                        (<strong> '. $row->section->section_name .' </strong>)
                                    </span><br>
                                    <span class="whitespace-nowrap cursor-pointer hover:text-blue-500">
                                        Session : <strong> '. $row->session->session_name .' </strong>
                                    </span><br>


                                </div>

                            </div>

                        </div>
                    ';
                        })

                        ->addColumn('monthly_fee', function ($row) {

                            $FeeDetails = $row->FeeDetails;
                            $arr_monthly_fee_fields = array();
                            foreach($FeeDetails as $fee){
                                $arr_monthly_fee_fields[] = '<span class="tag-month">'.str_replace(',', '</span><span class="tag-other">' ,$fee->monthly_fee_fields)."</span>";
                            }

                            $paidMonthlyFee = implode(" ",$arr_monthly_fee_fields);
                            return '
                            <span class="dont-break-out cursor-pointer hover:text-blue-500">
                            '. $paidMonthlyFee .'
                            </span>
                            ';

                        })

                        ->addColumn('others_fee', function ($row) {

                            $FeeDetails = $row->FeeDetails;
                            $arr_others_fee_fields = array();
                            foreach($FeeDetails as $fee){
                                if($fee->others_fee_fields){
                                    $arr_others_fee_fields[] = '<span class="tag-other">'.str_replace('@', '</span><span class="tag-other">' ,$fee->others_fee_fields)."</span>";
                                }
                            }

                            $paid_others_fee_fields = implode(" ",$arr_others_fee_fields);
                            return '
                            <span class="dont-break-out cursor-pointer hover:text-blue-500">
                            '. $paid_others_fee_fields .'
                            </span>
                            ';

                        })



                        ->addColumn('amount', function ($row) {

                            $FeeDetails = $row->FeeDetails;
                            $arr_discount = array();
                            $arr_amount = array();
                            $arr_paid = array();
                            $total_discount = 0;
                            $total_amount = 0;
                            $total_paid = 0;
                            foreach($FeeDetails as $fee){
                                $arr_discount[] = $fee->discount;
                                $arr_amount[] = $fee->amount;
                                $arr_paid[] = $fee->paid;
                            }
                            $total_discount = array_sum($arr_discount);
                            $total_amount = array_sum($arr_amount);
                            $total_paid = array_sum($arr_paid);

                            $html = '';
                            if ($total_discount > 0 ) {
                                $html .= '<p class="m-0" style="text-decoration: line-through;color: #ff0909;" >' . number_format($total_amount,2) . '</p>';
                                $html .= '<p class="m-0" style="" >' . number_format($total_paid,2) . '</p>';
                            }else{
                                $html .= '<p class="m-0" style="" >' . number_format($total_paid,2) . '</p>';
                            }
                            return $html;

                           return '<strong>'. $total_paid .'</strong>';
                        })

                        ->addColumn('action', function ($row) {

                            $session_id = isset($row->session_id) ? $row->session_id : '';
                            $student_id = isset($row->student_details->id) ? $row->student_details->id : '';


                           return '<div class="w-full text-center">
                           <a href="'.'student_fee_single/'.$session_id .'/'.$student_id .'" class="btn-action--gray" title="'. __('translation.View Details') .'">
                               <i class="fas fa-arrow-circle-right"></i>
                           </a>
                       </div>';

                        })

                        ->rawColumns(['details', 'monthly_fee','others_fee', 'amount', 'action'])
                        ->skipPaging()
                        ->make(true);

            return $table;
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        Session::put('itemArray', []);

        //Generate a timestamp using mt_rand.
        $timestamp = mt_rand(1, time());

        $monthListArr = StudentFee::MonthArray();
        //dd($student);
        $feeTypes = FeeTypes::where('status',FeeTypes::ACTIVE)->orderBy('name')->get();

        $data = [
            'timestamp' => $timestamp,
            'classes' => Classes::all(),
            'sections' => Sections::all(),
            'groups' => Groups::all(),
            'sessions' => Sessions::orderBy('session_name','desc')->get(),
            'feeTypes' => $feeTypes,
            'monthListArr' => $monthListArr,
        ];

        return view('student_fee.create', $data);
    }




    /**
     * Store `student fee` data
     *
     * @param  \App\Http\Requests\Student\StoreRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        try {
            $studentFeeExist = StudentFee::where('student_id',$request->student_id)
                                ->where('session_id',$request->session_id)
                                ->where('class_id',$request->class_id)
                                ->where('monthly_fee_fields',$request->monthly_fee_fields)
                                ->where('others_fee_details',$request->others_fee_details)
                                ->where('amount',$request->amount)
                                ->where('paid',$request->paid)
                                ->first();

            if(!empty($studentFeeExist)){
                return "exist";
            }

            $studentFee = new StudentFee();
            $studentFee->student_id = $request->student_id ? $request->student_id: 0 ;
            $studentFee->session_id = $request->session_id ? $request->session_id: 0 ;
            $studentFee->class_id = $request->class_id ? $request->class_id: 0 ;
            $studentFee->monthly_fee_fields = $request->monthly_fee_fields ? $request->monthly_fee_fields: NULL ;


            $studentFee->others_fee_fields = $request->others_fee_fields ? $request->others_fee_fields: NULL ;
            $studentFee->others_fee_details = $request->others_fee_details ? $request->others_fee_details: NULL ;
            $studentFee->monthly_fee_total = $request->monthly_fee_total ? $request->monthly_fee_total: 0 ;
            $studentFee->other_amount_total = $request->other_amount_total ? $request->other_amount_total: 0 ;
            $studentFee->amount = $request->amount ? $request->amount: 0 ;
            $studentFee->entry_date = $request->entry_date ? $request->entry_date: '' ;
            $studentFee->discount = $request->discount ? $request->discount: 0 ;
            $studentFee->note = $request->note ? $request->note: '' ;
            $studentFee->paid = $request->paid ? $request->paid: 0 ;
            $studentFee->payment_method = $request->payment_method ? $request->payment_method: 'cash' ;

            if($request->payment_method=='cheque'){
                $studentFee->bank_or_wallet_id = $request->bank_name ? $request->bank_name: '' ;
                $studentFee->acc_or_mobile_no = $request->cheque_no ? $request->cheque_no: '' ;
            }

            if($request->payment_method=='mobile_banking'){
                $studentFee->bank_or_wallet_id = $request->wallet_name ? $request->wallet_name: '' ;
                $studentFee->acc_or_mobile_no = $request->mobile_no ? $request->mobile_no: '' ;
            }

            if($request->discount>0){
                $studentFee->status = 'pending';
            }else{
                $studentFee->status = 'paid';
            }
            $studentFee->user_id = Auth::user()->id ;
            $studentFee->save();

            return $studentFee->id;

        } catch (\Exception $th) {
            report($th);

            return response()->json([
                'message' => 'Something went wrong. ' . $th->getMessage()
            ], 500);
        }
    }





      /**
     * Show inventory sync table page.
     *
     * @param  int  $id
     * @return \Illuminate\View\View
     */
    public function studentFeeSingleEdit($id){

        $banks = Banks::get();
        $mobile_wallets = MobileWalets::get();

        $personId = Auth::user()->id;
        $studentFee = StudentFee::find($id);
        $monthListArr = StudentFee::MonthArray();

        $session_id = $studentFee->session_id;
        $class_id = $studentFee->class_id;

        $student = CurrentAcadmicStatus::with('student_details')
        ->where('student_id',$studentFee->student_id)
        ->first();
        $student_details= $student->student_details;

        $feeTypes = FeeTypes::with(['fee_types_amount' => function ($query)  use ($session_id,$class_id){
            $query->where('session_id', $session_id);
            $query->where('class_id', $class_id);
        }])
        ->orderBy('name')->get();

        $arr_monthly_fee_fields_paid = explode(",",$studentFee->monthly_fee_fields);
        $arr_others_fee_fields_paid = explode("@",$studentFee->others_fee_fields);
        return view(
            'student_fee.edit',
            compact(
                [
                'banks',
                'mobile_wallets',
                'student_details',
                'studentFee',
                'feeTypes',
                'monthListArr',
                'arr_monthly_fee_fields_paid',
                'arr_others_fee_fields_paid'
                ]
            )
        );
    }

    /**
     * Store `student fee` update
     *
     * @param  \App\Http\Requests\Student\StoreRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {

        try {

            $studentFee = StudentFee::find($request->id);
            $studentFee->id = $request->id ? $request->id: 0 ;
            $studentFee->student_id = $request->student_id ? $request->student_id: 0 ;
            $studentFee->session_id = $request->session_id ? $request->session_id: 0 ;
            $studentFee->class_id = $request->class_id ? $request->class_id: 0 ;
            $studentFee->monthly_fee_fields = $request->monthly_fee_fields ? $request->monthly_fee_fields: NULL ;


            $studentFee->others_fee_fields = $request->others_fee_fields ? $request->others_fee_fields: NULL ;
            $studentFee->others_fee_details = $request->others_fee_details ? $request->others_fee_details: NULL ;
            $studentFee->monthly_fee_total = $request->monthly_fee_total ? $request->monthly_fee_total: 0 ;
            $studentFee->other_amount_total = $request->other_amount_total ? $request->other_amount_total: 0 ;
            $studentFee->amount = $request->amount ? $request->amount: 0 ;
            $studentFee->entry_date = $request->entry_date ? $request->entry_date: '' ;
            $studentFee->discount = $request->discount ? $request->discount: 0 ;
            $studentFee->note = $request->note ? $request->note: '' ;
            $studentFee->paid = $request->paid ? $request->paid: 0 ;

            $studentFee->payment_method = $request->payment_method ? $request->payment_method: '' ;
            $studentFee->bank_or_wallet_id = $request->bank_or_wallet_id ? $request->bank_or_wallet_id: '' ;
            $studentFee->acc_or_mobile_no = $request->acc_or_mobile_no ? $request->acc_or_mobile_no: '' ;
            if($request->payment_method=='cheque'){
                $studentFee->bank_or_wallet_id = $request->bank_name ? $request->bank_name: '' ;
                $studentFee->acc_or_mobile_no = $request->cheque_no ? $request->cheque_no: '' ;
            }

            if($request->payment_method=='mobile_banking'){
                $studentFee->bank_or_wallet_id = $request->wallet_name ? $request->wallet_name: '' ;
                $studentFee->acc_or_mobile_no = $request->mobile_no ? $request->mobile_no: '' ;
            }

            $studentFee->update();
           return $studentFee->id;

        } catch (\Exception $th) {
            report($th);

            return response()->json([
                'message' => 'Something went wrong. ' . $th->getMessage()
            ], 500);
        }
    }


    /**
     * Show fee_types filter by class,section,group,session.
     *
     * @param  int  $id
     * @return \Illuminate\View\View
     */
    public function filterOthersFee(Request $request)
    {
        $banks = Banks::get();
        $mobile_walets = MobileWalets::get();
        $session_id = $request->session_id;
        $class_id = $request->class_id;
        $section_id = $request->section_id;
        $group_id = $request->group_id;
        $roll_no = $request->roll_no;

        $student = Student::searchStudent($roll_no,$session_id,$class_id,$section_id,$group_id);
           // $feeTypes = FeeTypes::where('status',FeeTypes::ACTIVE)->orderBy('name')->get();
        if(empty($student)){
            return "Sorry, Student not found with roll no ".$roll_no.", Please try again...";
        }

        $feeTypes = FeeTypes::with(['fee_types_amount' => function ($query)  use ($session_id){
            $query->where('session_id', $session_id);
        }])
        ->orderBy('name')->get();

        $studeFeePaid = StudentFee::where('session_id',$session_id)
                    ->where('class_id',$class_id)
                    ->where('student_id',$student->student_id)
                    ->get();

        $arrPaidMonthlyFee = array();
        $arrPaidOthersFee = array();
        foreach($studeFeePaid as $row){
            $arrPaidMonthlyFee[]= $row->monthly_fee_fields;
            $arrPaidOthersFee[]= $row->others_fee_fields;
        }
        $arrPaidMonthlyFee = explode(',',(implode(",",$arrPaidMonthlyFee))) ;
        $arrPaidOthersFee = explode('@',(implode("@",$arrPaidOthersFee))) ;

        $monthListArr = StudentFee::MonthArray();
        return view(
            'student_fee.filter_others_fee_field',
            compact(
                [
                'student',
                'banks',
                'mobile_walets',
                'monthListArr',
                'feeTypes',
                'class_id',
                'arrPaidMonthlyFee',
                'arrPaidOthersFee'
                ]
            )
        );
    }


    /**
     * Show fee_types on multiple.
     *
     * @param  int  $id
     * @return \Illuminate\View\View
     */
    public function addRemoveOthersFeeField(Request $request)
    {

        $checked = $request->checked;
        if($checked=='true'){
            $feeTypes = FeeTypes::orderBy('name')->get();
        }else{
            $feeTypes = FeeTypes::where('status',FeeTypes::ACTIVE)->orderBy('name')->get();
        }

        return view(
            'student_fee.add_remove_others_fee_field',
            compact(
                [
                'feeTypes',
                'checked'
                ]
            )
        );
    }


    /**
     * Set Status 1 OR 0 on fee_types table page.
     *
     * @param  int  $id
     * @return \Illuminate\View\View
     */
    public function statusChangeOthersFeeField(Request $request)
    {

        $status = $request->status;
        $feeTypes = FeeTypes::find($request->id);
        $feeTypes->status = $request->status;
        $feeTypes->save();
        return 'success';
    }

    /**
     * Set Status Approve on Student Fee
     *
     * @param  int  $id
     * @return \Illuminate\View\View
     */
    public function FeeStatusApprove(Request $request)
    {

        $status = $request->status;
        $studentFee = StudentFee::find($request->id);
        $studentFee->status = $request->status;
        $studentFee->save();
        return redirect()->back()->with('success','Status has been changed successfully');
    }



    /**
     * Show fee_types filter by class,section,group,session.
     *
     * @param  int  $id
     * @return \Illuminate\View\View
     */
    public function getMoneyReceipt(Request $request)
    {
        $receipt_id = $request->receipt_id;
        $studentFee = StudentFee::where('id',$receipt_id)->first();
        $class_id = $studentFee->class_id;
        $session_id = $studentFee->session_id;
        $student_id = $studentFee->student_id;

        $student = Student::with(['currentAcademicStatus'
        => function ($query)  use ($session_id,$class_id){
            $query->where('session_id', $session_id);
            $query->where('class_id', $class_id);
        }])
        ->where('id',$student_id)->first();
        $feeTypes = FeeTypes::with(['fee_types_amount' => function ($query)  use ($session_id){
            $query->where('session_id', $session_id);
        }])
        ->get();

        $school_info = Settings::first();
        $monthListArr = StudentFee::MonthArray();
        return view(
            'student_fee.get_money_receipt',
            compact(
                [
                'school_info',
                'student',
                'monthListArr',
                'feeTypes',
                'class_id',
                'studentFee'
                ]
            )
        );
    }



    public function studentFeeSingle($session_id,$student_id)
    {

        $student = Student::with(['currentAcademicStatus'
        => function ($query)  use ($student_id,$session_id){
            $query->where('session_id', $session_id);
        }])
        ->where('id',$student_id)->first();
        $arr_param['personId'] = Auth::user()->id;
        Session::put('itemArray', []);

      //  dd($student);
        $data = [
            'student' =>$student,
            'classes' => Classes::get(),
            'sections' => Sections::get(),
            'sessions' => Sessions::orderBy('id', 'DESC')->get(),
            'MonthArray' => StudentFee:: MonthArray()
        ];

        return view('student_fee.student_fee_single', $data);
    }

    /**
     * Handle datatable serverside
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function feeListByStudentID(Request $request)
    {
        if ($request->ajax()) {
            $classId = $request->post('classId');
            $sectionId = $request->post('sectionId');
            $sessionId = $request->post('sessionId');
            $student_code = $request->post('student_code');

            $student = Student::where('student_code',$student_code)
            ->first();

            $offset = $request->get('start', 0);
            $limit = $request->get('length', 10);
            if ($limit < 1 OR $limit > 100) {
                $limit = 100;
            }


            $search = isset($request->get('search')['value'])
                    ? $request->get('search')['value']
                    : null;

            $orderColumnList = [
                'roll_no',
                'id',
                 '',
                'name',
                'roll_name',
                'section_name'
            ];

            $orderColumnIndex = isset($request->get('order')[0]['column'])
                                ? $request->get('order')[0]['column']
                                : 0;
            $orderColumnDir = isset($request->get('order')[0]['dir'])
                                ? $request->get('order')[0]['dir']
                                : 'desc';

            $orderColumn = isset($orderColumnList[$orderColumnIndex])
                            ? $orderColumnList[$orderColumnIndex]
                            : 'name';

            $otherReportParams = [
                'search' => $search,
                'limit' => $limit,
                'offset' => $offset,
                'order_column' => $orderColumn,
                'order_dir' => $orderColumnDir,
                'class_id' => $classId,
            ];

            $personId = Auth::user()->id;

            $studentFees = StudentFee::where('student_id',$student->id)
                ->where('class_id',$classId)
                ->where('session_id',$sessionId)
                ->get();
          //  dd($student->id);
            $table = Datatables::of($studentFees)

                ->addColumn('receipt_no', function ($row) {
                    return '
                                    <div class="flex flex-row gap-4">
                                    <div class="w-1/2 sm:w-full md:w-fulllg:w-full">
                                        <div class="mb-3">
                                            <span class="text-blue-500 font-bold">
                                                <strong>' . $row->id . '</strong><br>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            ';
                })

                ->addColumn('entry_date', function ($row) {
                    return $row->entry_date;
                })

                ->addColumn('monthly_fee', function ($row) {
                    $monthly_fee_fields = '';
                    if (!empty($row->monthly_fee_fields))
                        $monthly_fee_fields = '<span class="tag-month">' . str_replace(',', '</span><span class="tag-other">', $row->monthly_fee_fields) . "</span>";

                    return '
                            <span class="dont-break-out cursor-pointer hover:text-blue-500">
                            ' . $monthly_fee_fields . '
                            </span>
                            ';

                })

                ->addColumn('others_fee', function ($row) {
                    $others_fee_fields = '';
                    if (!empty($row->others_fee_fields))
                        $others_fee_fields = '<span class="tag-other">' . str_replace('@', '</span><span class="tag-other">', $row->others_fee_fields) . "</span>";

                    return '
                            <span class="dont-break-out cursor-pointer hover:text-blue-500">
                            ' . $others_fee_fields . '
                            </span>
                            ';

                })

                ->addColumn('payment_details', function ($row) {
                    $payment_method = ucwords(str_replace("_", " ", $row->payment_method));

                    $html = '<p class="m-0"><strong>Payment Method: </strong>' . $payment_method . '</p>';
                    if ($row->payment_method == 'cheque') {
                        $bank = Banks::where('id', $row->bank_or_wallet_id)->first();
                        $html .= '<p class="m-0"><strong>Bank: </strong>' . $bank->name . '</p>';
                        $html .= '<p class="m-0"><strong>Acc#: </strong>' . $row->acc_or_mobile_no . '</p>';
                    }

                    if ($row->payment_method == 'mobile_banking') {
                        $wallet = MobileWalets::where('id', $row->bank_or_wallet_id)->first();
                        $html .= '<p class="m-0"><strong>Wallet: </strong>' . $wallet->name . '</p>';
                        $html .= '<p class="m-0"><strong>Acc#: </strong>' . $row->acc_or_mobile_no . '</p>';
                    }
                    if ($row->discount) {
                        $html .= '<p class="m-0"><strong>Discount: Tk.</strong>' . $row->discount . '</p>';
                        $html .= '<p class="m-0"><strong>Note: </strong>' . $row->note . '</p>';
                    }
                    return $html;
                })

                ->addColumn('amount', function ($row) {
                    $html = '';
                    if ($row->discount) {
                        $html .= '<p class="m-0" style="text-decoration: line-through;color: #ff0909;" >' . number_format($row->amount,2) . '</p>';
                        $html .= '<p class="m-0" style="" >' . number_format($row->paid,2) . '</p>';
                    }else{
                        $html .= '<p class="m-0" style="" >' . number_format($row->amount,2) . '</p>';
                    }
                    return $html;
                })

                ->addColumn('action', function ($row) {

                    $id = isset($row->id) ? $row->id : '';


                    $action = '<div class="w-full text-center">
                        <a href="'.url('student_fee/edit', [ 'id' => $id ]) .'"  class="modal-open btn-action--yellow" title="Edit" x-on:click="showEditModal=true" data-id="3934" id="BtnUpdate">
                            <i class="fas fa-pencil-alt"></i>
                        </a>
                        <button type="button" class="btn-action--red" title="Delete" data-id="'.$id.'" id="BtnDelete">
                            <i class="fas fa-trash-alt"></i>
                        </button>';
                        if($row->status=='pending'){
                            $action .= '<button type="button" class="BtnChangeStatus modal-open btn-action--green" title="Change Status" data-id="' . $id . '">
                            <i class="bi bi-file-ruled"></i>
                            </button>';
                        }


                        $action .= ' <button type="button" class="modal-open btn-action--blue" title="Print Receipt" data-id="' . $id . '" id="BtnPrintMoneyReceipt">
                            <i class="fas fa-print"></i>
                        </button>
                    </div>';
                return $action;
                })

                        ->rawColumns(['receipt_no', 'monthly_fee','others_fee', 'payment_details','amount', 'action'])
                        ->skipPaging()
                        ->make(true);

            return $table;
        }
    }


        /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function studentFeeHistory()
    {
        return view('student_fee.student_fee_history');
    }


    /**
     * Handle datatable serverside
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function feeListHistory(Request $request)
    {
        if ($request->ajax()) {
            $classId = $request->get('classId', '');
            $sectionId = $request->get('sectionId', array());
            $sessionId = $request->get('sessionId', '');

            $offset = $request->get('start', 0);
            $limit = $request->get('length', 10);
            if ($limit < 1 OR $limit > 100) {
                $limit = 100;
            }


            $search = isset($request->get('search')['value'])
                    ? $request->get('search')['value']
                    : null;

            $orderColumnList = [
                'roll_no',
                'id',
                 '',
                'name',
                'roll_name',
                'section_name'
            ];

            $orderColumnIndex = isset($request->get('order')[0]['column'])
                                ? $request->get('order')[0]['column']
                                : 0;
            $orderColumnDir = isset($request->get('order')[0]['dir'])
                                ? $request->get('order')[0]['dir']
                                : 'desc';

            $orderColumn = isset($orderColumnList[$orderColumnIndex])
                            ? $orderColumnList[$orderColumnIndex]
                            : 'name';

            $otherReportParams = [
                'search' => $search,
                'limit' => $limit,
                'offset' => $offset,
                'order_column' => $orderColumn,
                'order_dir' => $orderColumnDir,
                'class_id' => $classId,
            ];

            $MonthArray = StudentFee:: MonthArray();
            $now = Carbon::now();
            $MonthArray = array_chunk($MonthArray, 6);
            $prevMonthArr = $MonthArray[0];


            $nextMonthArr = array();
            if(isset($MonthArray[1])){
                $nextMonthArr = $MonthArray[1];
            }

            $personId = Auth::user()->id;

            $studentFees = StudentFee::with('student_details')->get();

            $table = Datatables::of($studentFees)

                    ->addColumn('receipt_no', function ($row) {
                                    return '
                                    <div class="flex flex-row gap-4">
                                    <div class="w-1/2 sm:w-full md:w-fulllg:w-full">
                                        <div class="mb-3">
                                            <span class="text-blue-500 font-bold">
                                                <strong>'. $row->id .'</strong><br>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            ';
                        })

                        ->addColumn('student_code', function ($row) {
                            return isset($row->student_details->student_code) ? $row->student_details->student_code : '';
                        })

                        ->addColumn('entry_date', function ($row) {
                            return $row->entry_date ;
                        })

                        ->addColumn('monthly_fee', function ($row) {
                            $monthly_fee_fields ='';
                            if(!empty($row->monthly_fee_fields))
                                $monthly_fee_fields = '<span class="tag-month">'.str_replace(',', '</span><span class="tag-other">' ,$row->monthly_fee_fields)."</span>";

                            return '
                            <span class="dont-break-out cursor-pointer hover:text-blue-500">
                            '. $monthly_fee_fields .'
                            </span>
                            ';

                        })

                        ->addColumn('others_fee', function ($row) {
                            $others_fee_fields ='';
                            if(!empty($row->others_fee_fields))
                                $others_fee_fields = '<span class="tag-other">'.str_replace('@', '</span><span class="tag-other">' ,$row->others_fee_fields)."</span>";

                            return '
                            <span class="dont-break-out cursor-pointer hover:text-blue-500">
                            '. $others_fee_fields .'
                            </span>
                            ';

                        })

                        ->addColumn('payment_details', function ($row) {
                            $payment_method = ucwords(str_replace("_", " ", $row->payment_method));

                            $html = '<p class="m-0"><strong>Payment Method: </strong>' . $payment_method . '</p>';
                            if ($row->payment_method == 'cheque') {
                                $bank = Banks::where('id', $row->bank_or_wallet_id)->first();
                                $html .= '<p class="m-0"><strong>Bank: </strong>' . $bank->name . '</p>';
                                $html .= '<p class="m-0"><strong>Acc#: </strong>' . $row->acc_or_mobile_no . '</p>';
                            }

                            if ($row->payment_method == 'mobile_banking') {
                                $wallet = MobileWalets::where('id', $row->bank_or_wallet_id)->first();
                                $html .= '<p class="m-0"><strong>Wallet: </strong>' . $wallet->name . '</p>';
                                $html .= '<p class="m-0"><strong>Acc#: </strong>' . $row->acc_or_mobile_no . '</p>';
                            }
                            if ($row->discount) {
                                $html .= '<p class="m-0"><strong>Discount: Tk.</strong>' . $row->discount . '</p>';
                                $html .= '<p class="m-0"><strong>Note: </strong>' . $row->note . '</p>';
                            }
                            return $html;
                        })

                        ->addColumn('amount', function ($row) {
                            $html = '';
                            if ($row->discount) {
                                $html .= '<p class="m-0" style="text-decoration: line-through;color: #ff0909;" >' . number_format($row->amount,2) . '</p>';
                                $html .= '<p class="m-0" style="" >' . number_format($row->paid,2) . '</p>';
                            }else{
                                $html .= '<p class="m-0" style="" >' . number_format($row->amount,2) . '</p>';
                            }
                            return $html;
                        })

                        ->addColumn('action', function ($row) {

                            $id = isset($row->id) ? $row->id : '';


                           return '<div class="w-full text-center">

                           <a href="" class="btn-action--green" title="Detail">
                               <i class="fas fa-info"></i>
                           </a>
                           <a href="'.url('student_fee/edit', [ 'id' => $id ]) .'"  class="modal-open btn-action--yellow" title="Edit" x-on:click="showEditModal=true" data-id="3934" id="BtnUpdate">
                               <i class="fas fa-pencil-alt"></i>
                           </a>
                           <button type="button" class="btn-action--red" title="Delete" data-id="'.$id.'" id="BtnDelete">
                               <i class="fas fa-trash-alt"></i>
                           </button>
                           <button type="button" class="modal-open btn-action--blue" title="Stock Adjust" x-on:click="showQuantityModal=true" data-id="'.$id.'" id="BtnQuantity">
                               <i class="fas fa-warehouse"></i>
                           </button>
                           <a href="'.url('students.create', [ 'id' => $id ]) .'" class="btn-action--gray" title="'. __('translation.Inventory Sync') .'">
                               <i class="fas fa-arrow-circle-right"></i>
                           </a>
                       </div>';

                        })

                        ->rawColumns(['receipt_no', 'monthly_fee','others_fee', 'payment_details','amount', 'action'])
                        ->skipPaging()
                        ->make(true);

            return $table;
        }
    }

    public function delete(Request $request)
    {

        StudentFee::where('id', $request->id)->delete();
        return [
            'status' => 1
        ];
    }

}
