<?php

namespace App\Http\Controllers;

use App\Models\Feature;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Yajra\DataTables\Facades\DataTables;

class FeatureController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return array
     */
    public function index()
    {
        $title = 'feature';
        $data = Feature::where('shop_id',Auth::user()->shop_id)->get();
        return view('settings.feature',compact('title','data'));
    }

    public function data(Request $request)
    {
        if ($request->ajax()){
            if (isset($request->id) && $request->id != null) {
                $editData = Feature::where([
                    'id' => $request->id
                ])->first();
                return view('elements.form-update-feature',compact( 'editData'));
            }

            $data = Feature::where('shop_id',Auth::user()->shop_id)->get();

            $table = Datatables::of($data)
                ->addColumn('status', function ($row) {
                    if($row->status){
                        return '
                        <div class="w-full text-left">
                            <span class="badge-status--yellow">
                                Active
                            </span>
                        </div>
                    ';
                    }
                    
                })
                ->addColumn('manage', function ($row) {
                    return '
                        <div class="w-full text-left">
                            <button type="button" class="modal-open btn-action--green" title="'. __('translation.Edit') .'" x-on:click="showEditModal=true" data-id="' . $row->id . '" id="BtnUpdate">
                                <i class="fas fa-pencil-alt"></i>
                            </button>
                            <button type="button" class="btn-action--red" title="'. __('translation.Delete') .'" data-id="' . $row->id . '" id="BtnDelete">
                                <i class="fas fa-trash-alt"></i>
                            </button>
                        </div>
                    ';
                })
                ->rawColumns(['status','manage'])
                ->make(true);

            return $table;
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('elements.form-update-feature');

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        
        $feature = new Feature();

        $status = isset($request->status) ? 1 : 0 ;
        $feature->name = $request->name;
        $feature->status = $status;
        $feature->shop_id = Auth::user()->shop_id;
        
        $feature->save();

        if($feature)
        {
            return redirect()->back()->with('success','Feature Added Successfully');
        }
        else{
            return redirect()->back()->with('danger','Something happened wrong');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = Feature::where('shop_id',Auth::user()->shop_id)->get();

        return view('settings.feature',compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'id' => 'required',
            'name' => 'required'
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }
        $status = isset($request->status) ? 1 : 0 ;
        
        $feature = Feature::where('id', $request->id)->first();
        $feature->name = $request->name;
        $feature->status = $status;
        $feature->shop_id = Auth::user()->shop_id;
        $feature->save();

        if($feature)
        {
            return redirect('features')->with('success','Feature Updated Successfully');
        }
        else{
            return redirect('features')->with('danger','Something happened wrong');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
    public function delete(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'id' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 0,
                'message' => 'Field id is required'
            ]);
        } else {

            $feature = Feature::where('id',$request->id)->where('seller_id',Auth::user()->id)->first();
            if(file_exists($feature->logo)){
                unlink($feature->logo);
            }
            $feature->delete();

            return [
                'status' => 1
            ];
        }
    }
}
