<?php

namespace App\Http\Controllers;

use App\Models\ExpenseType;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Yajra\DataTables\Facades\DataTables;
use DB;
class ExpenseTypesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return array
     */
    public function index()
    {
        $title = 'expense_type';
        $data = ExpenseType::get();
        return view('expense_types.index',compact('title','data'));
    }

      /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $expense_type = new ExpenseType();
        $expense_type->name = $request->name;
        $expense_type->save();

        if($expense_type)
        {
            return redirect()->back()->with('success','ExpenseType Added Successfully');
        }
        else{
         return redirect()->back()->with('danger','Something happened wrong');
        }
    }


    public function updateExpenseType(Request $request, $id)
    {
        $expense_type = ExpenseType::find($id);
        $expense_type->name = $request->name;
        $expense_type->save();

        if($expense_type){
            return redirect('expense_types')->with('success','ExpenseType Updated Successfully');
        }
        else{
         return redirect('expense_types')->with('danger','Something happened wrong');
        }
    }



    public function delete($id)
    {
        $expense_type = ExpenseType::where('id',$id)->delete();
        if($expense_type)
        {
            return redirect()->back()->with('success','ExpenseType Deleted Successfully');
        }
        else{
         return redirect()->back()->with('danger','Something happened wrong');
        }
    }
}
