<?php

namespace App\Http\Controllers;

use App\Models\Exams;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Yajra\DataTables\Facades\DataTables;
use DB;
class ExamController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return array
     */
    public function index()
    {
        $title = 'exam';
        $data = Exams::orderBy('position','ASC')->get();
        return view('exams.index',compact('title','data'));
    }

      /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $exam = new Exams();
        $exam->exam_name = $request->exam_name;
        $exam->position = Exams::max('position')+1;
        $exam->save();

        if($exam)
        {
            return redirect()->back()->with('success','Exam Added Successfully');
        }
        else{
         return redirect()->back()->with('danger','Something happened wrong');
        }
    }


    public function updateExam(Request $request, $id)
    {
        $exam = Exams::find($id);
        $exam->exam_name = $request->exam_name;
        $exam->save();

        if($exam){
            return redirect('exams')->with('success','Exam Updated Successfully');
        }
        else{
         return redirect('exams')->with('danger','Something happened wrong');
        }
    }


    public function examReOrder(Request $request)
    {

        //return($request->order);
        foreach ($request->order as $order) {
                DB::table('exams')
                ->where('id',$order['id'])
                ->update([
                    'position' =>$order['position']
                ]);

            }
            return "success";
    }

    public function delete($id)
    {
        $exam = Exams::where('id',$id)->delete();
        if($exam)
        {
            return redirect()->back()->with('success','Exam Deleted Successfully');
        }
        else{
         return redirect()->back()->with('danger','Something happened wrong');
        }
    }
}
