<?php

namespace App\Http\Controllers;

use App\Models\Product;
use App\Models\Role;
use App\Models\Shop;
use App\Models\StockLog;
use App\Models\User;
use App\Models\DailyExpenses;
use App\Models\ExpenseType;
use App\Models\Banks;
use App\Models\Settings;

use App\Models\MobileWalets;
use Illuminate\Http\Request;
use Datatables;
use DB;
use PDF;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Carbon;
class DailyExpensesController extends Controller
{
    public function dailyExpenses()
    {
        $expense_types = ExpenseType::get();
        $banks = Banks::get();
        $mobile_walets = MobileWalets::get();
        $title = 'Daily Expense';
        return view('transactions.daily-expense', compact('expense_types','banks', 'mobile_walets', 'title'));
    }

    public function data(Request $request)
    {
        if ($request->ajax()) {
            if(isset($request->assign_shop)){
                $staff = User::find($request->id);
                $assigned_shops = '';
                if($staff->assigned_shops != null){
                    $assigned_shops = json_decode($staff->assigned_shops);
                }
                $data['staff_id'] = $request->id;
                $data['assigned_shops'] = $assigned_shops;
                $data['shops'] = Shop::where('person_id', Auth::id())->get();
                return view('elements.form-assign-shop', $data);
            }

            if (isset($request->id) && $request->id != null) {
                $data = DailyExpenses::where([
                    'id' => $request->id
                ])->first();

                $id = $request->id;
                $expense_types = ExpenseType::all();
                $banks = Banks::get();
                $mobile_wallets = MobileWalets::get();

                return view('elements.form-update-daily-expense', compact(['data', 'id', 'expense_types', 'banks','mobile_wallets']));
            }

            $data = DailyExpenses::orderBy('id', 'desc')
                ->with('expense_type')
                ->get();
            $table = Datatables::of($data)
            ->addColumn('checkbox', function ($row) {
                return "<input type='checkbox' name='cost_id' class='cost_id' data-id='" . $row->id . "'>";
            })
                ->addColumn('created_at', function ($row) {
                    return $row->entry_date;
                })

                ->addColumn('expense_type', function ($row) {
                    return $row->expense_type->name;
                })

                ->addColumn('amount', function ($row) {
                    return $row->amount;
                })
                ->addColumn('note', function ($row) {
                    return $row->note;
                })
                ->addColumn('status', function ($row) {
                    if($row->status==1) $status = "Approved";
                    if($row->status==0) $status = "Not Approved";
                    return $status;
                })
                ->addColumn('manage', function ($row) {
                    if (Auth::user()->role == 'member'){
                        return '<div class="w-full text-center">
                                    <button type="button" class="modal-open btn-action--green" title="'. __('translation.Edit') .'" x-on:click="showEditModal=true" data-id="' . $row->id . '" id="BtnUpdate">
                                       <i class="fas fa-pencil-alt"></i>
                                    </button>
                                    <button type="button" class="btn-action--red" title="'. __('translation.Delete') .'" data-id="' . $row->id . '" id="BtnDelete">
                                        <i class="fas fa-trash-alt"></i>
                                    </button>
                                </div>';
                    }
                })
                ->rawColumns(['checkbox','manage'])
                ->make(true);
            return $table;
        }
    }

    public function insert(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'expense_type_id' => 'required',
            'amount' => 'required',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        //dd($request->all());
        $bank_or_wallet_id = 0;
        $acc_or_mobile_no = 0;
        if($request->payment_method=='cheque'){
            $bank_or_wallet_id = $request->bank_name ? $request->bank_name: 0 ;
            $acc_or_mobile_no = $request->cheque_no ? $request->cheque_no: '' ;
        }

        if($request->payment_method=='mobile_banking'){
            $bank_or_wallet_id = $request->wallet_name ? $request->wallet_name: '' ;
            $acc_or_mobile_no = $request->mobile_no ? $request->mobile_no: '' ;
        }

            $dailyCost = new DailyExpenses();

            $dailyCost->expense_type_id = $request->expense_type_id;
            $dailyCost->amount = $request->amount;
            $dailyCost->note = $request->note;
            $dailyCost->entry_date = Carbon::now();
            $dailyCost->status = '0';
            $dailyCost->payment_method = $request->payment_method;
            $dailyCost->bank_or_wallet_id = $bank_or_wallet_id;
            $dailyCost->acc_or_mobile_no = $acc_or_mobile_no;

            $dailyCost->save();

        return redirect()->back()->with('success', 'Data successfully created');
    }

    public function update(Request $request)
    {
        $daily_expense = DailyExpenses::find($request->id);

        $validator = Validator::make($request->all(), [
            'expense_type_id' => 'required',
            'amount' => 'required',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        $daily_expense->expense_type_id = $request->expense_type_id;
        $daily_expense->amount = $request->amount;
        $daily_expense->note = $request->note;
        $daily_expense->payment_method = $request->payment_method;
        if($request->payment_method=='cheque'){
            $daily_expense->bank_or_wallet_id = $request->bank_name ? $request->bank_name: '' ;
            $daily_expense->acc_or_mobile_no = $request->cheque_no ? $request->cheque_no: '' ;
        }

        if($request->payment_method=='mobile_banking'){
            $daily_expense->bank_or_wallet_id = $request->wallet_name ? $request->wallet_name: '' ;
            $daily_expense->acc_or_mobile_no = $request->mobile_no ? $request->mobile_no: '' ;
        }
        $daily_expense->update();

        return redirect('daily-expense')->with('success', __('translation.Data successfully updated'));
    }

    public function changeStatusModal(Request $request)
    {
        $ids = $request->ids;
        return view('elements.form-approved-daily-expense', compact('ids'));
    }

    public function changeStatus(Request $request)
    {
        $arr_ids = explode(",",$request->ids);
        DB::table('daily_expenses')->whereIn('id', $arr_ids)
            ->update([
                'status' => $request->status
            ]);
        return redirect()->back()->with('success', 'Status successfully changed');
//            } else {
//                return redirect()->back()->with('error', 'Wrong Status');
//            }

    }

    public function delete(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'id' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 0,
                'message' => 'Field id is required'
            ]);
        }

        DailyExpenses::where('id', $request->id)->delete();
        return [
            'status' => 1
        ];
    }



    public function expenseReport(Request $request){

        $data = [
            'expenses_types' => ExpenseType::all()
        ];

        return view('reports.expenses.index',$data);
    }



    /**
     * Handle datatable serverside
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function expensePDFExport(Request $request)
    {

            $now = Carbon::now()->format('m');

            $start_date = $request->post('start_date') ? $request->post('start_date') : $now;
            $end_date = $request->post('end_date') ? $request->post('end_date') : $now;
            $expense_type_id = $request->post('expense_type_id') ? $request->post('expense_type_id') : 0;

            $dailyExpenses = DailyExpenses::with('expense_type')->whereBetween('entry_date', [$start_date, $end_date]);
            if ($expense_type_id) {
                $dailyExpenses->where('expense_type_id', $expense_type_id);
            }

            $daily_expenses = $dailyExpenses->get();
            $customPaper = array(0,0,60.00,50.80);

        $width= '600';
        $height = '1200';

        $data = [
            'school_info' => Settings::first(),
            'start_date' => $start_date,
            'end_date' => $end_date,
            'daily_expenses' => $daily_expenses
        ];

        $page_header = "Expense-List";
        $file_name = "Expense-List";

        $pdf = PDF::loadView('reports.expenses.pdf-report',$data)
        ->setOptions(['defaultFont' => 'Courier'])
        ->setOptions(
            ['isHtml5ParserEnabled' => true,
            'enable_remote' => true,
            'chroot'  => public_path(),
        ])
        ->setPaper('A4', 'portrait');//
        // ->setPaper(array(0,0,$width,$height));

            // $paper_size = array(0,0,360,360);
            // $dompdf->set_paper($paper_size);

        $time = strtotime("today");
        if(!empty($data)){
            $file_name = $file_name.'-'.$time.'.pdf';
        }

        $path = public_path('pdf');
        $pdf->save($path . '/' . $file_name);
        $download_link = asset('pdf').'/'.$file_name;
        return 'PDF Created Successfully, Please click to <a class="font-bold" href="'.$download_link.'" target="_blank">View</a> Or <a class="font-bold" href="'.$download_link.'" download>Download Now</a>';


          //  return view('reports.expense.pdf-report',$data);


    }



}
