<?php

namespace App\Http\Controllers;

use App\Models\Classes;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Yajra\DataTables\Facades\DataTables;
use DB;
class ClassController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return array
     */
    public function index()
    {
        $title = 'class';
        $data = Classes::orderBy('position','ASC')->get();
        return view('classes.index',compact('title','data'));
    }

      /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $class = new Classes();
        $class->class_name = $request->class_name;
        $class->class_code = $request->class_code;
        $class->position = Classes::max('position')+1;
        $class->save();

        if($class)
        {
            return redirect()->back()->with('success','Class Added Successfully');
        }
        else{
         return redirect()->back()->with('danger','Something happened wrong');
        }
    }


    public function updateClass(Request $request, $id)
    {
        $class = Classes::find($id);
        $class->class_name = $request->class_name;
        $class->class_code = $request->class_code;
        $class->update();

        if($class){
            return redirect('classes')->with('success','Class Updated Successfully');
        }
        else{
         return redirect('classes')->with('danger','Something happened wrong');
        }
    }


    public function classReOrder(Request $request)
    {

        //return($request->order);
        foreach ($request->order as $order) {
                DB::table('classes')
                ->where('id',$order['id'])
                ->update([
                    'position' =>$order['position']
                ]);

            }
            return "success";
    }

    public function delete($id)
    {
        $class = Classes::where('id',$id)->delete();
        if($class)
        {
            return redirect()->back()->with('success','Class Deleted Successfully');
        }
        else{
         return redirect()->back()->with('danger','Something happened wrong');
        }
    }
}
