<?php

namespace App\Http\Controllers;

use App\Models\BanksOrMobiles;
use App\Models\Account;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use DB;

// use App\Http\Requests\Category\MassDestroyCategoryRequest;
// use App\Http\Requests\Category\StoreCategoryRequest;
// use App\Http\Requests\Category\UpdateCategoryRequest;

class BankOrMobileController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $banks_or_mobiles = BanksOrMobiles::orderBy('type', 'asc')
        ->orderBy('name', 'asc')
        ->get();

        $data = BanksOrMobiles::with('accounts')
        ->orderBy('type', 'asc')
        ->orderBy('name', 'asc')
        ->get();
        
        $title = 'Banks/Mobiles';
        return view('settings.banks_or_mobiles',compact('banks_or_mobiles','data', 'title'));
    }



    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
      
        $bank_or_mobile = new BanksOrMobiles();
        $bank_or_mobile->name = $request->name;
        $bank_or_mobile->type = $request->type;

        $bank_or_mobile->shop_id = Auth::user()->shop_id;
        $bank_or_mobile->save();

        if($bank_or_mobile)
        {
            return redirect()->back()->with('success','Bank/Mobile Added Successfully');
        }
        else{
         return redirect()->back()->with('danger','Something happened wrong');
        }
    }


    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function updateBankOrMobile(Request $request, $id)
    {
        $bank_or_mobile = BanksOrMobiles::find($id);
        $bank_or_mobile->name = $request->name;
        $bank_or_mobile->type = $request->type;
        
        $bank_or_mobile->save();

        if($bank_or_mobile){
            return redirect('banks_or_mobiles')->with('success','Item Updated Successfully');
        }
        else{
         return redirect('banks_or_mobiles')->with('danger','Something happened wrong');
        }
    }


    public function reOrder(Request $request)
    {

        //return($request->order);
        foreach ($request->order as $order) {
                DB::table('banks_or_mobiles')
                ->where('id',$order['id'])
                ->update([
                    'parent_category_id' =>$order['parent_category_id'],
                    'position' =>$order['position'],
                ]);

            }
            return "success";
    }



    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete($id)
    {
        $bank_or_mobile = BanksOrMobiles::where('id',$id)->where('shop_id',Auth::user()->shop_id)->delete();
        if($bank_or_mobile)
        {
            return redirect()->back()->with('success','Item Deleted Successfully');
        }
        else{
         return redirect()->back()->with('danger','Something happened wrong');
        }
    }



        /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function storeAccount(Request $request)
    {
      
        
        $account = new Account();
        $account->account_no = $request->account_no;
        $account->bank_or_mobile_wallet_id = $request->bank_or_mobile_wallet_id;
        $account->save();

        if($account)
        {
            return redirect()->back()->with('success','Account Added Successfully');
        }
        else{
         return redirect()->back()->with('danger','Something happened wrong');
        }
    }


        /**
     * Get all sub-banks_or_mobiles
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function editAccount(Request $request)
    {
        $banks_or_mobiles = BanksOrMobiles::get();
        
        if ($request->ajax()){
            if (isset($request->id) && $request->id != null) {
                $editData = Account::where([
                    'id' => $request->id
                ])->first();
                $data = [
                    'banks_or_mobiles' => $banks_or_mobiles,
                    'editData' => $editData,
                ];
                return view('elements.form-update-account-no',compact( 'editData', 'banks_or_mobiles'));
            }
        }
    }

    public function updateAccount(Request $request)
    {
        $account = Account::find($request->id);
        $account->account_no = $request->account_no;
        $account->bank_or_mobile_wallet_id = $request->bank_or_mobile_wallet_id;        
        $account->save();

        if($account)
        {
            return redirect('banks_or_mobiles')->with('success','Account Updated Successfully');
        }
        else{
         return redirect('banks_or_mobiles')->with('danger','Something happened wrong');
        }
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function deleteAccount($id)
    {
        $account = Account::where('id',$id)->delete();
        if($account)
        {
            return redirect()->back()->with('success','Account Deleted Successfully');
        }
        else{
         return redirect()->back()->with('danger','Something happened wrong');
        }
    }

    
    public function loadBankOrMobileDropdown(Request $request)
    {
        if ($request->ajax()){
            $type='Cash';
            if (isset($request->id) && $request->id != null) {
                if($request->id==1){
                    $type='Cash';                    
                    $label='Cash';
                }elseif($request->id==2){
                    $type='bank';                    
                    $label='Bank Name';
                }else{
                    $type='mobile';
                    $label='Mobile Banking';
                }
                $banks_or_mobiles = BanksOrMobiles::where('type',$type)->get();
                $data = [
                    'type' => $type,
                    'label' => $label,
                    'banks_or_mobiles' => $banks_or_mobiles,
                ];
                return view('elements.form-load-bank-or-mobile',$data);
            }
        }
    }

    
    public function loadBankOrMobileAccountDropdown(Request $request)
    {
        if ($request->ajax()){
            
            if (isset($request->bank_or_mobile_wallet_id) && $request->bank_or_mobile_wallet_id != null) {
                $accounts = Account::where('bank_or_mobile_wallet_id',$request->bank_or_mobile_wallet_id)->get();
                
                $data = [
                    'accounts' => $accounts,
                ];
                return view('elements.form-load-bank-or-mobile-account',$data);
            }
        }
    }
}
