<?php

namespace App\Http\Controllers;

use App\Models\ActivityLog;
use App\Models\Permission;
use App\Models\User;
use App\Models\InitialTransaction;
use App\Models\ReceivePayments;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use App\Http\Requests\Applications\{ApplicationStoreRequest, ApplicationUpdateRequest};
use App\Imports\BulkImport;
use App\Models\Product;
use App\Models\OrderManagement;
use App\Models\Applications;
use App\Models\ApplicationDetails;
use App\Models\Supplier;
use App\Models\Lender;
use App\Models\Banks;
use App\Models\BanksOrMobiles;
use App\Models\Account;
use App\Models\Shop;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Datatables;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Maatwebsite\Excel\Facades\Excel;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Str;

use App\Exports\OrderAnalysisExport;


class ApplicationController extends Controller
{
    public function index()
    {

        $shop = Shop::where('id', Auth::user()->shop_id)->first();
        $applicationCount = count(DB::connection('mysql_secondary')->select('SELECT * FROM applications'));


        $permissionFilter = 'AND permission_of_secretary=1 AND permission_of_gs=1 AND permission_of_president=1';

        $syncCount = count(DB::connection('mysql_secondary')->select("SELECT * FROM applications WHERE 1=1 $permissionFilter"));
      
        return view('seller.applications.index', compact('shop', 'applicationCount','syncCount'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return Response
     */
    public function edit($id)
    {
        $application = DB::connection('mysql_secondary')->select("SELECT * FROM applications WHERE id=$id");
        
        $resultArray = json_decode(json_encode($application[0]), true);
       
        $matches_key_associate = array(
            'trade_license',
            'tin_no',
            'vat_no',
            'php_no'
            );
    
            $matches_key_general = array(
            'trade_license',
            'trade_mark',
            'tin_no',
            'vat_no',
            'fire_certificate',
            'env_certificate',
            'industry_lic',
            'php_no',
            'formulation_lic',
            'import_lic',
            'holesale_lic',
            'bsti_cm_lic',
            'bsti_cover_lic',
            );


            $missing_keys = [];
            foreach ($matches_key_associate as $key) {
                if (!isset($resultArray[$key]) || empty($resultArray[$key])) {
                    $missing_keys[] = $key;
                }
            }
            
            if(empty($missing_keys)) {
                $member_no = 'AM';
                $member_type = 'Associate';
            } else {
                $member_no = 'TM';
                $member_type = 'Temporary';
            }

            // check if general member
            if($member_no=='AM'){
                $missing_keys = [];
                foreach ($matches_key_general as $key) {
                    if (!isset($resultArray[$key]) || empty($resultArray[$key])) {
                        $missing_keys[] = $key;
                    }
                }

                if (empty($missing_keys)) {
                    $member_no = 'GM';
                    $member_type = 'General';
                } else {
                    $member_no = 'TM';
                    $member_type = 'Temporary';
                }

            }

        $data = [
            'member_no' => $member_no,
            'application' => $application[0],
        ];
        return view("seller.applications.edit", $data);
    }

     /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return Response
     */
    public function download($id)
    {
        $application = DB::connection('mysql_secondary')->select("SELECT * FROM applications WHERE id=$id");
        
        $resultArray = json_decode(json_encode($application[0]), true);
        
        $matches_key_associate = array(
            'trade_license',
            'tin_no',
            'vat_no',
            'php_no'
            );
    
            $matches_key_general = array(
            'trade_license',
            'trade_mark',
            'tin_no',
            'vat_no',
            'fire_certificate',
            'env_certificate',
            'industry_lic',
            'php_no',
            'formulation_lic',
            'import_lic',
            'holesale_lic',
            'bsti_cm_lic',
            'bsti_cover_lic',
            );

            $missing_keys = [];
            foreach ($matches_key_associate as $key) {
                if (!isset($resultArray[$key]) || empty($resultArray[$key])) {
                    $missing_keys[] = $key;
                }
            }
            
            if(empty($missing_keys)) {
                $member_no = 'AM';
                $member_type = 'Associate';
            } else {
                $member_no = 'TM';
                $member_type = 'Temporary';
            }

            // check if general member
            if($member_no=='AM'){
                $missing_keys = [];
                foreach ($matches_key_general as $key) {
                    if (!isset($resultArray[$key]) || empty($resultArray[$key])) {
                        $missing_keys[] = $key;
                    }
                }

                if (empty($missing_keys)) {
                    $member_no = 'GM';
                    $member_type = 'General';
                } else {
                    $member_no = 'TM';
                    $member_type = 'Temporary';
                }

            }

        $firstDate = (new \DateTime('first day of January'))->format('jS F');
        $currentYear = (new \DateTime('first day of January'))->format('Y');

        $data = [
            'application' => $application[0],
            'member_no' => $member_no,
            'member_type' => $member_type,
            'firstDate' => $firstDate,
            'currentYear' => $currentYear,
        ];


        return view("seller.applications.download", $data);
    }


    public function compareDataWithKeys($data, $keys) {
        foreach ($keys as $key) {
            // Check if the key exists in the data and has a non-empty value
            if (!isset($data[$key]) || empty($data[$key])) {
                return false; // Return false if any key is missing or empty
            }
        }
        return true; // All keys exist and have non-empty values
    }



    public function data(Request $request)
    {
        if ($request->ajax()){
            
            if (isset($request->id) && $request->id != null) {
      
                $application = Applications::with('opening_due')->findOrFail($request->id); 
                
                $data = [
                    'prouctionUnits' =>Shop::all(),
                    'application' => $application,
                ];

                return view("seller.applications.modal-templates.edit", $data);
            }

            $product_name = $request->get('product_name', '');
            $application_type = $request->get('application_type', '');
            $memberType = $request->get('memberType', '');
            $statusId = $request->get('statusId', '');
            
           
            $start = $request->get('start', 0);
            $limit = $request->get('length', 10);
            if ($limit < 1 OR $limit > 100) {
                $limit = 100;
            }

            $search = isset($request->get('search')['value'])
                    ? $request->get('search')['value']
                    : null;

            $orderColumnList = [
                'applications.id',
                'application_name',
                'phone',
                'company',
                'address',
                'status',
            ];

            $orderColumnIndex = isset($request->get('order')[0]['column'])
                                ? $request->get('order')[0]['column']
                                : 0;
            $orderColumnDir = isset($request->get('order')[0]['dir'])
                                ? $request->get('order')[0]['dir']
                                : 'desc';
            $orderColumnDir = 'desc';

            $orderColumn = $orderColumnList[$orderColumnIndex] ?? 'product_id';

            $userRole = 'member';
            $userId = Auth::id();

            $memberTypeFilter = '';
            if($memberType=='Temporary') {
                $memberTypeFilter = "AND member_type='Temporary'";
            }
            if($memberType=='Assistant') {
                $memberTypeFilter = "AND member_type='Assistant'";
            }
            if($memberType=='General') {
                $memberTypeFilter = "AND member_type='General'";
            }
            

            $permissionFilter = '';
            if($statusId=='permission_of_secretary') {
                $permissionFilter = 'AND permission_of_secretary=1';
            }
            if($statusId=='permission_of_gs') {
                $permissionFilter = 'AND permission_of_gs=1';
            }
            if($statusId=='permission_of_president') {
                $permissionFilter = 'AND permission_of_president=1';
            }
            
            $data = DB::connection('mysql_secondary')->select("SELECT * FROM applications WHERE 1=1 $memberTypeFilter $permissionFilter");
            
          
            
            $totalData = count(DB::connection('mysql_secondary')->select("SELECT * FROM applications WHERE 1=1 $memberTypeFilter $permissionFilter"));
            

            $table = Datatables::of($data)
            
           
                ->addColumn('id', function ($row) {                  
                    return $row->id;                    
                })

                ->addColumn('date', function ($row) {
                    return $row->applied_date; 
                })
                ->addColumn('company', function ($row) {
                    return $row->company_name; 
                })
               
                ->addColumn('brand_name', function ($row) {                    
                    return $row->brand_name; 
                })

                ->addColumn('member_type', function ($row) {              
                    return $row->member_type; 
                })

                ->addColumn('issue_or_expire_date', function ($row) {
                    $details = '';                    
                    $details = "<p class='dark:text-gray-400 transition'><strong>Iusse: </strong>$row->issue_date</p>";
                    $details .= "<p class='dark:text-gray-400 transition'><strong>Expire: </strong>$row->expire_date</p>";
                    return $details; 
                })
                
                ->addColumn('permission_of_secretary', function ($row) {
                    $details = '';
                    if($row->permission_of_secretary==0){
                        $details = '<span class="text-red-700 transition">Denied</span>';
                    }

                    if($row->permission_of_secretary){
                        $details = '<span class="text-green-700 transition">Approved</span>';
                    }
                    return $details; 
                })

                ->addColumn('permission_of_gs', function ($row) {
                    $details = '';
                    if($row->permission_of_gs==0){
                        $details = '<span class="text-red-700 transition">Denied</span>';
                    }

                    if($row->permission_of_gs){
                        $details = '<span class="text-green-700 transition">Approved</span>';
                    }
                    return $details; 
                })

                ->addColumn('permission_of_president', function ($row) {
                    $details = '';
                    if($row->permission_of_president==0){
                        $details = '<span class="text-red-700 transition">Denied</span>';
                    }

                    if($row->permission_of_president){
                        $details = '<span class="text-green-700 transition">Approved</span>';
                    }
                    return $details; 
                })    
                ->addColumn('actions', function ($row) {
                    $actionContent = '';
                    
                    $actionContent = '
                    <div class="w-full text-center">
                        <div class="flex flex-wrap items-center -m-1.5">
                                <div class="m-1.5">
                                    <button id="BtnIssueDate" data-id="'.$row->id.'" class="btn bg-white dark:bg-gray-800 border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="fill-current text-gray-400 dark:text-gray-500 shrink-0" width="16" height="16" viewBox="0 0 24 24" id="calendar">
                                            <path d="M12,19a1,1,0,1,0-1-1A1,1,0,0,0,12,19Zm5,0a1,1,0,1,0-1-1A1,1,0,0,0,17,19Zm0-4a1,1,0,1,0-1-1A1,1,0,0,0,17,15Zm-5,0a1,1,0,1,0-1-1A1,1,0,0,0,12,15ZM19,3H18V2a1,1,0,0,0-2,0V3H8V2A1,1,0,0,0,6,2V3H5A3,3,0,0,0,2,6V20a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V6A3,3,0,0,0,19,3Zm1,17a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V11H20ZM20,9H4V6A1,1,0,0,1,5,5H6V6A1,1,0,0,0,8,6V5h8V6a1,1,0,0,0,2,0V5h1a1,1,0,0,1,1,1ZM7,15a1,1,0,1,0-1-1A1,1,0,0,0,7,15Zm0,4a1,1,0,1,0-1-1A1,1,0,0,0,7,19Z"></path>
                                        </svg>
                                    </button>
                                </div>
                                <div class="m-1.5">
                                    <button id="BtnStatusChange" data-id="'.$row->id.'" class="btn bg-white dark:bg-gray-800 border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600">
                                        <svg class="fill-current text-violet-500 shrink-0" width="16" height="16" viewBox="0 0 24 24" id="lock">
                                        <path d="M12,13a1.49,1.49,0,0,0-1,2.61V17a1,1,0,0,0,2,0V15.61A1.49,1.49,0,0,0,12,13Zm5-4V7A5,5,0,0,0,7,7V9a3,3,0,0,0-3,3v7a3,3,0,0,0,3,3H17a3,3,0,0,0,3-3V12A3,3,0,0,0,17,9ZM9,7a3,3,0,0,1,6,0V9H9Zm9,12a1,1,0,0,1-1,1H7a1,1,0,0,1-1-1V12a1,1,0,0,1,1-1H17a1,1,0,0,1,1,1Z"></path>
                                        </svg>
                                    </button>
                                </div>

                            <div class="m-1.5">
                                <!-- Start -->
                                <a href="'. route('application.edit', [ 'application' => $row->id ]) .'" class="btn bg-white dark:bg-gray-800 border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600">
                                   
                                        <svg class="fill-current text-gray-400 dark:text-gray-500 shrink-0" xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 48 48" id="eye">
                                        <path fill="none" d="M0 0h48v48H0z"></path>
                                        <path d="M24 9C14 9 5.46 15.22 2 24c3.46 8.78 12 15 22 15 10.01 0 18.54-6.22 22-15-3.46-8.78-11.99-15-22-15zm0 25c-5.52 0-10-4.48-10-10s4.48-10 10-10 10 4.48 10 10-4.48 10-10 10zm0-16c-3.31 0-6 2.69-6 6s2.69 6 6 6 6-2.69 6-6-2.69-6-6-6z"></path>
                                        </svg>
                                </a>
                                <!-- End -->
                            </div>


                            <div class="m-1.5">
                                <!-- Start -->
                                <a href="'. route('application.download', [ 'application' => $row->id ]) .'" class="btn bg-white dark:bg-gray-800 border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600">
                                   <svg xmlns="http://www.w3.org/2000/svg" enable-background="new 0 0 100 100" width="16" height="16" viewBox="0 0 48 48"  id="download">
                                        <path d="m24 32.5 8-8h-6v-18h-4v18h-6l8 8zm18-26H30v3.97h12v28.06H6V10.47h12V6.5H6c-2.21 0-4 1.79-4 4v28c0 2.21 1.79 4 4 4h36c2.21 0 4-1.79 4-4v-28c0-2.21-1.79-4-4-4z"></path>
                                    </svg>                            
                                </a>
                                <!-- End -->
                            </div>

  
                            <div class="m-1.5">
                                <!-- Start -->
                                <button id="BtnDeleteItem" data-id="'.$row->id.'" class="btn bg-white dark:bg-gray-800 border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600">
                                    <svg class="fill-current text-red-500 shrink-0" width="16" height="16" viewBox="0 0 16 16">
                                        <path d="M5 7h2v6H5V7zm4 0h2v6H9V7zm3-6v2h4v2h-1v10c0 .6-.4 1-1 1H2c-.6 0-1-.4-1-1V5H0V3h4V1c0-.6.4-1 1-1h6c.6 0 1 .4 1 1zM6 2v1h4V2H6zm7 3H3v9h10V5z"></path>
                                    </svg>
                                </button>
                                <!-- End -->
                            </div>
                        </div>                       
                    </div>
                    ';
                   
                    return $actionContent;
                })
                ->rawColumns(['id','application_name','issue_or_expire_date','permission_of_secretary','permission_of_gs','permission_of_president','actions'])
                ->skipPaging()
                ->setTotalRecords($totalData)
                ->make(true);

            return $table;
        }
    }


    public function fn_memberType($application)
    {
        $resultArray = json_decode(json_encode($application), true);
        
        $matches_key_associate = array(
            'trade_license',
            'tin_no',
            'vat_no',
            'php_no'
            );
    
            $matches_key_general = array(
            'trade_license',
            'trade_mark',
            'tin_no',
            'vat_no',
            'fire_certificate',
            'env_certificate',
            'industry_lic',
            'php_no',
            'formulation_lic',
            'import_lic',
            'holesale_lic',
            'bsti_cm_lic',
            'bsti_cover_lic',
            );

            $missing_keys = [];
            foreach ($matches_key_associate as $key) {
                if (!isset($resultArray[$key]) || empty($resultArray[$key])) {
                    $missing_keys[] = $key;
                }
            }
            
            if(empty($missing_keys)) {
                $member_no = 'AM';
                $member_type = 'Associate';
            } else {
                $member_no = 'TM';
                $member_type = 'Temporary';
            }

            // check if general member
            if($member_no=='AM'){
                $missing_keys = [];
                foreach ($matches_key_general as $key) {
                    if (!isset($resultArray[$key]) || empty($resultArray[$key])) {
                        $missing_keys[] = $key;
                    }
                }

                if (empty($missing_keys)) {
                    $member_no = 'GM';
                    $member_type = 'General';
                } else {
                    $member_no = 'TM';
                    $member_type = 'Temporary';
                }
            }

            return $member_no;

    }

    function loadInsertForm(Request $request){
        $data = [
            'prouctionUnits' =>Shop::all(),
        ];
        return view("seller.applications.modal-templates.create",$data);
    }

    /**
     * Store new application
     *
     * @param ApplicationStoreRequest $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function insert(ApplicationStoreRequest $request)
    {
        try {
            if(Session::has('application_date')){
                $application = Session::forget('application_date');
            }

            
            $application = new Applications();
            $application->application_name = $request->application_name ?? NULL;
            $application->company = $request->company ?? NULL;
            
            $application->phone = $request->phone ?? NULL;
            $application->address = $request->address ?? NULL;
            $application->status = 1;
            $application->save();
            $applicationId = $application->id; 
 
            if($applicationId){

                return response()->json([
                    'status' => 1,
                    'message' => '<span class="flex space-x-4 text-green-600">Application created successfully</span>'
                ]);
            }

        } catch (\Throwable $th) {
            report($th);

            return redirect()->back()
                    ->with('error', $th->getMessage())
                    ->withInput();
        }
    }

    /**
     * Update the application data
     *
     * @param ApplicationUpdateRequest $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function update(ApplicationUpdateRequest $request)
    {
        try {
            if(Session::has('application_date')){
                Session::forget('application_date');
            }
            
            $application = Applications::find($request->id);   
            $application->application_name = $request->application_name ?? NULL;
            $application->company = $request->company ?? NULL;
            $application->phone = $request->phone ?? NULL; 
            $application->address = $request->address ?? NULL;
            $application->status = 1;
            $application->save();
            $applicationId = $application->id; 



            
            if($applicationId){

                return response()->json([
                    'status' => 1,
                    'message' => '<span class="flex space-x-4 text-green-600">Application updated successfully</span>'
                ]);
            }
            else{
                return redirect()->back()->with('danger','Something happened wrong');
            }


        } catch (\Throwable $th) {
            report($th);
            return $this->apiResponse(500, "Something went wrong. {$th->getMessage()}");
        }
    }


    
    function loadDeleteForm(Request $request){

        $application = Applications::findOrFail($request->id); 
       
        abort_if(!$application, 404);

        $data = [
            'application' => $application           
        ];

        return view('seller.applications.modal-templates.delete', $data);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete(Request $request){
        
        $validator = Validator::make($request->all(), [
            'id' => 'required'
        ]);

        $orderManagementDetail = OrderManagement::where('application_id', '=', $request->id)->first();
        if($orderManagementDetail){
            return response()->json([
                'status' => 0,
                'message' => '<span class="pt-5 px-5 flex space-x-4 text-red-500">This Application is already purchased Product, You may deactivate only.'
            ]);
        }

        if ($validator->fails()) {
            return response()->json([
                'status' => 0,
                'message' => '<span class="pt-5 px-5 flex space-x-4 text-red-500">Field id is required</span>'
            ]);
        } else {

            if(session::has('application_date')){
                session::forget('application_date');
            }

            Applications::where('id', '=', $request->id)->delete();

            ActivityLog::updateProductActivityLog('Delete  Application', $request->id);
                        
            return [
                'status' => 1,
                'message' => '<span class="pt-5 px-5 flex space-x-4 text-green-600">This Entry is deleted successfully.</span>'
            ];
        }
    }

        /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function bulkDelete(Request $request){
        
        $validator = Validator::make($request->all(), [
            'bulk_ids' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 0,
                'message' => '<span class="pt-5 px-5 flex space-x-4 text-red-500">Field id is required</span>'
            ]);
        } else {

            if(session::has('application_date')){
                session::forget('application_date');
            }
            $isBulkDelete = false;
            $arrBulkIds = explode(",",$request->bulk_ids);
            foreach($arrBulkIds as $id){
                Applications::where('id', '=', $id)->delete();
                $isBulkDelete = true;
            }

            
            if($isBulkDelete){
                ActivityLog::updateProductActivityLog('Bulk Delete  Applications',count($arrBulkIds));
            }
            
                        
            return [
                'status' => 1,
                'message' => '<span class="pt-5 px-5 flex space-x-4 text-green-600"> Applications deleted successfully.</span>'
            ];
        }
    }


    public function statusFormLoad(Request $request)
    {
        if ($request->ajax()){
            
            if (isset($request->id) && $request->id != null) {
      
                $application = DB::connection('mysql_secondary')->select("SELECT * FROM applications WHERE id=$request->id"); 
                
                $data = [
                    'application' => $application[0],
                ];

                return view("seller.applications.modal-templates.status", $data);
            }
        }
    }

    public function issueDateChangeFormLoad(Request $request)
    {
        if ($request->ajax()){
            
            if (isset($request->id) && $request->id != null) {
      
                $application = DB::connection('mysql_secondary')->select("SELECT * FROM applications WHERE id=$request->id"); 
                
                $data = [
                    'application' => $application[0],
                ];

                return view("seller.applications.modal-templates.edit", $data);
            }
        }
    }

        /**
     * Update the stock data
     *
     * @param ApplicationUpdateRequest $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function updateStatus(Request $request)
    {
        try {
            if(Session::has('application_date')){
                Session::forget('application_date');
            }
            
           
            if(Auth::user()->role=='secretary'){
                $permission_of_secretary = $request->permission_of_secretary ?? 0;
                DB::connection('mysql_secondary')->select("UPDATE applications SET permission_of_secretary=$permission_of_secretary WHERE id=$request->id");
            }

            if(Auth::user()->role=='general-secretary'){
                $permission_of_gs = $request->permission_of_gs ?? 0;
                DB::connection('mysql_secondary')->select("UPDATE applications SET permission_of_gs=$permission_of_gs WHERE id=$request->id");
            }

            if(Auth::user()->role=='president'){
                $permission_of_president = $request->permission_of_president ?? 0;
                DB::connection('mysql_secondary')->select("UPDATE applications SET permission_of_president=$permission_of_president WHERE id=$request->id");
            }

            return response()->json([
                'status' => 1,
                'message' => '<span class="flex space-x-4 text-green-600">Application Status updated successfully</span>'
            ]);
            
            


        } catch (\Throwable $th) {
            report($th);
            return $this->apiResponse(500, "Something went wrong. {$th->getMessage()}");
        }
    }


    /**
     * Update the stock data
     *
     * @param ApplicationUpdateRequest $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function updateIssueOrExpireDate(Request $request)
    {
        
        //dd($request->all());
        $issue_date = $request->issue_date != null ? date('Y-m-d', strtotime($request->issue_date)) : '';
        if($issue_date){
            DB::connection('mysql_secondary')->select("UPDATE applications SET issue_date='$issue_date' WHERE id=$request->id");
        }

        $expire_date = $request->expire_date != null ? date('Y-m-d', strtotime($request->expire_date)) : '';
        if($expire_date){
            DB::connection('mysql_secondary')->select("UPDATE applications SET expire_date='$expire_date' WHERE id=$request->id");
        }

        return response()->json([
            'status' => 1,
            'message' => '<span class="flex space-x-4 text-green-600">Application Issue/Expire Date updated successfully</span>'
        ]);
        
    }
        


    public function loadApplicationByUnitID(Request $request){
        $data = [
            'applications' => Applications::where('shop_id',$request->shop_id)->get(),
        ];
        return view('elements.load-application-by-production-unit-id',$data);
    }

    

}