<?php
/**
 * API Controller was written for accepting
 * payload from WooCommerce to perform CRUD operations
 * @author Arnob (adstcare@gmail.com)
 * @since Jun 12th, 2021 @ 3:01pm
 */
namespace App\Http\Controllers;

use App\Models\DoDoChat;
use App\Models\Shop;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class ApiController extends Controller
{
    private $topic;
    private $source_shop;
    public function __construct()
    {
        $this->topic = isset($_SERVER['HTTP_X_WC_WEBHOOK_TOPIC']) ? $_SERVER['HTTP_X_WC_WEBHOOK_TOPIC'] : '';
        $this->source_shop = isset($_SERVER['HTTP_X_WC_WEBHOOK_SOURCE']) ? $_SERVER['HTTP_X_WC_WEBHOOK_SOURCE'] : '';
    }

    public function dodoChatAuthentication($username, $password)
    {
        if(Auth::attempt([
            'phone' => $username,
            'password' => $password,
            'is_active' => 1
        ])) {

            $authCode = Str::random(20);
            $dodohat = new DoDoChat();
            $dodohat->username = $username;
            $dodohat->login_time = now();
            $dodohat->auth_code = $authCode;
            $dodohat->name = Auth::user()->name;
            $dodohat->save();

            if(Auth::user()->role == 'member') {
                $shops = Shop::where('seller_id', Auth::id())->get();
                $all_shops = [];
                foreach ($shops as $shop) {
                    $shop_type = json_decode($shop->shop_type);
                    if(count((array) $shop_type)){
                    }
                }

                if(count($all_shops)){
                    return response()->json([
                        'status'=>'success',
                        'data' => Auth::user(),
                        'shops' => json_encode($all_shops),
                        'auth_code' => $authCode
                    ], 200);
                } else {
                    return response()->json(['status'=>'No shops are configured.'], 200);
                }
            }

            if(Auth::user()->role == 'staff') {
                $shops = json_decode(Auth::user()->assigned_shops);
                if(count((array)$shops)) {
                    $all_shops = [];
                    foreach ($shops as $item) {
                        $shop = Shop::find($item);
                        $shop_type = json_decode($shop->shop_type);
                        if(count((array) $shop_type)){
                        

                        }
                    }

                    return response()->json([
                        'status'=>'success',
                        'data' => Auth::user(),
                        'shops' => json_encode($all_shops),
                        'auth_code' => $authCode
                    ], 200);

                } else {
                    return response()->json(['status'=>'No shops are assigned to you.'], 200);
                }
            }
        } else {
            return response()->json(['status'=>'Invalid credentials, please try again...'], 401);
        }
    }
}
