<?php

namespace App\Http\Controllers;

use App\Http\Requests\Student\StoreRequest;
use App\Http\Requests\Student\UpdateRequest;
use App\Http\Resources\ProductTypeAheadResource;
use App\Models\Student;
use App\Models\Exams;
use App\Models\Classes;
use App\Models\Sections;
use App\Models\Groups;
use App\Models\Sessions;
use App\Models\CurrentAcadmicStatus;
use App\Models\Settings;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Datatables;
use DB;
use PDF;

class AdmitCardController extends Controller
{

    public $exam_name = [];
    public $merit_details = [];
    public $merit_list = [];

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        $arr_param['personId'] = Auth::user()->id;
        Session::put('itemArray', []);



        $data = [
            'exams' => Exams::orderBy('position', 'ASC')->get(),
            'classes' => Classes::get(),
            'sections' => Sections::get(),
            'sessions' => Sessions::orderBy('id', 'DESC')->get()
        ];

        return view('admit_cards.index', $data);
    }


    /**
     * Handle datatable serverside
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function AdmitCardsDataTable(Request $request)
    {
        if ($request->ajax()) {
            $examId = $request->get('examId', '');
            $classId = $request->get('classId', '');
            $sectionId = $request->get('sectionId', array());
            $sessionId = $request->get('sessionId', '');

            $exam = Exams::where('id', $examId)->select('exam_name')->first();
            $this->exam_name = isset($exam->exam_name) ? $exam->exam_name : '';


            $offset = $request->get('start', 0);
            $limit = $request->get('length', 10);
            if ($limit < 1 or $limit > 100) {
                $limit = 100;
            }

            $search = isset($request->get('search')['value'])
                ? $request->get('search')['value']
                : null;

            $orderColumnList = [
                'roll_no',
                'id',
                '',
                'name',
                'section_name'
            ];

            $orderColumnIndex = isset($request->get('order')[0]['column'])
                ? $request->get('order')[0]['column']
                : 0;
            $orderColumnDir = isset($request->get('order')[0]['dir'])
                ? $request->get('order')[0]['dir']
                : 'desc';

            $orderColumn = isset($orderColumnList[$orderColumnIndex])
                ? $orderColumnList[$orderColumnIndex]
                : 'name';

            $otherReportParams = [
                'search' => $search,
                'limit' => $limit,
                'offset' => $offset,
                'order_column' => $orderColumn,
                'order_dir' => $orderColumnDir,
                'class_id' => $classId,
            ];


            $arr['exam_id'] = $examId;
            $arr['session_id'] = $sessionId;
            $arr['class_id'] = $classId;
            $arr['section_id'] = $sectionId;
            $arr_student_ids = array();

            $students = CurrentAcadmicStatus::getStudents($arr, $arr_student_ids,$is_required_marks=false);


            $table = Datatables::of($students)
                ->addColumn('id', function ($row) {
                    return $row->student_id;
                })
                ->addColumn('checkbox', function ($row) {
                    return "<input type='checkbox' name='checkbox' class='checkbox' data-id='" . $row->id . "'>";
                })
                ->addColumn('details', function ($row) {
                    //  dd($row);
                    $student_id = isset($row->student_details->id) ? $row->student_details->id : '';

                    if ($row->student_details->profile_photo) {
                        $profile_photo = asset('uploads/students/' . $row->student_details->profile_photo);
                    } else {
                        $profile_photo = '/No-Image-Found.png';
                    }

                    return '
                             <div class="flex flex-row gap-4" id="__productDiv_3934">
                                <div class="w-1/2 sm:w-full md:w-fulllg:w-full">
                                    <div class="mb-3">
                                        <img src="' . $profile_photo . '" style="width:100px !important" class="w-full h-auto">
                                    </div>
                                </div>
                            </div>

                    ';
                })

                ->addColumn('name', function ($row) {
                    return $row->student_details->name;
                })

                ->addColumn('student_code', function ($row) {
                    return $row->student_details->student_code;
                })

                ->addColumn('roll_no', function ($row) {
                    if ($row->roll_no) {
                        return $row->roll_no;
                    } else {
                        return '<p class="hidden">99999</p>';
                    }

                })

                ->addColumn('class_name', function ($row) {
                    return $row->class->class_name;
                })

                ->addColumn('section_name', function ($row) {
                    return $row->section->section_name;
                })

                ->addColumn('session_name', function ($row) {
                    return $row->session->session_name;
                })

                ->addColumn('action', function ($row) {

                    $student_id = isset($row->student_details->id) ? $row->student_details->id : '';


                    return '<div class="w-full text-center">
                           <button data-student_id=' . $student_id . ' class="btnPrintSingleAdmitCard btn-action--green" title="Print Admit Card">
                               <i class="fas fa-print"></i>
                           </button>
                       </div>';

                })

                ->rawColumns(['checkbox', 'details', 'roll_no', 'action'])
                ->skipPaging()
                ->make(true);
            return $table;
        }
    }



    /**
     * Handle the `print mark sheet as pdf` datatable
     * Serverside Datatable
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     *
     */
    public function AdmitCardsPDFExport(Request $request)
    {
        $validator = $request->validate([
            'class_id' => 'required|string',
            'session_id' => 'required|string',
        ]);

        $exam_id = $request->exam_id;
        $session_id = $request->session_id;
        $class_id = $request->class_id;
        $section_id = $request->section_id ? $request->section_id : '';
        $arr_student_ids = isset($request->student_ids) ? explode(",", $request->student_ids) : array();

        //dd($section_id);
        $arr['exam_id'] = $exam_id;
        $arr['session_id'] = $session_id;
        $arr['class_id'] = $class_id;
        $arr['section_id'] = $section_id;

        if (!empty($arr_student_ids)) {
            $students = CurrentAcadmicStatus::getStudents($arr, $arr_student_ids,$is_required_marks=false);
        } else {
            if ($section_id) {
                $students = CurrentAcadmicStatus::getStudents($arr, array(),$is_required_marks=false);
            }else{
                $students = CurrentAcadmicStatus::getStudents($arr, array(),$is_required_marks=false);
            }

        }


        $currentSession = isset($students[0]->session->session_name) ? $students[0]->session->session_name : 0;
        $currentClass = isset($students[0]->class->class_name) ? $students[0]->class->class_name : 0;
        $currentSection = isset($students[0]->section->section_name) ? $students[0]->section->section_name : 0;

        $data = [
            'school_info' => Settings::first(),
            'exam' => Exams::where('id', $exam_id)->first(),
            'students' => $students,
        ];

        $customPaper = array(0, 0, 60.00, 50.80);

        $width = '600';
        $height = '1200';

        $file_name = "Admit-Card";

        $pdf = PDF::loadView('admit_cards.pdf_admit_card', $data)
            ->setOptions(['defaultFont' => 'Courier'])
            ->setOptions(
                [
                    'isHtml5ParserEnabled' => true,
                    'enable_remote' => true,
                    'chroot' => public_path(),
                ]
            )
            ->setPaper('A4', 'portrait');


        $time = strtotime("today");
        if (!empty($studentWithMarks)) {
            $file_name = $file_name . '-' . $currentClass . '-' . $currentSection . '-' . $currentSession . '-' . $time . '.pdf';
        }

        $path = public_path('pdf');
        $pdf->save($path . '/' . $file_name);
        $download_link = asset('pdf') . '/' . $file_name;
        return response()->json([
            'message' => 'Admit Card Created Successfully, Please click to <a href="' . $download_link . '" target="_blank">View</a> Or <a href="' . $download_link . '" download>Download Now</a>'
        ]);
    }



}

