<?php

namespace App\Http\Controllers;

use App\Http\Requests\AdmissionForm\StoreRequest;
use App\Http\Requests\AdmissionForm\UpdateRequest;
use App\Http\Requests\AdmissionForm\DeleteRequest;
use App\Models\Student;
use App\Models\Classes;
use App\Models\Sections;
use App\Models\Groups;
use App\Models\Sessions;
use App\Models\CurrentAcadmicStatus;
use App\Models\FeeTypes;
use App\Models\FeeTypesAmount;
use App\Models\StudentFee;
use App\Models\Banks;
use App\Models\MobileWalets;
use App\Models\Settings;
use App\Models\Json;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use Illuminate\Support\Facades\Validator;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Datatables;
use DB;
use PDF;
class AdmissionFormController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {


        $arr_param['user_id'] = Auth::user()->id;
        Session::put('itemArray', []);

        $data = [
            'classes' => Classes::get(),
            'sections' => Sections::get(),
            'sessions' => Sessions::orderBy('id', 'DESC')->get()
        ];

        return view('admission_form.index', $data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        Session::put('itemArray', []);

        $user_id = Auth::user()->id;

        //Generate a timestamp using mt_rand.
        $timestamp = mt_rand(1, time());

        $monthListArr = StudentFee::MonthArray();
        //dd($student);
        $feeTypes = FeeTypes::where('status',FeeTypes::ACTIVE)->orderBy('name')->get();

        $data = [
            'timestamp' => $timestamp,
            'classes' => Classes::all(),
            'sections' => Sections::all(),
            'groups' => Groups::all(),
            'sessions' => Sessions::orderBy('id', 'DESC')->get(),
            'feeTypes' => $feeTypes,
            'monthListArr' => $monthListArr,
        ];

        return view('admission_form.create', $data);
    }



    /**
     * Store `student` data
     *
     * @param  \App\Http\Requests\AdmissionForm\StoreRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreRequest $request)
    {


        try {
            $student = new Student();
            $student->name = $request->name ? $request->name: NULL ;

            $student->fathers_name = $request->fathers_name ? $request->fathers_name: NULL ;
            $student->fathers_phone = $request->fathers_phone ? $request->fathers_phone: NULL ;

            $student->mothers_name = $request->mothers_name ? $request->mothers_name: NULL ;
            $student->mothers_phone = $request->mothers_phone ? $request->mothers_phone: NULL ;

            $student->legal_guardians_name = $request->legal_guardians_name ? $request->legal_guardians_name: NULL ;
            $student->legal_guardians_phone = $request->legal_guardians_phone ? $request->legal_guardians_phone: NULL ;

            $student->voter_type = $request->voter_type ? $request->voter_type: NULL ;
           // dd($student);
            $student->status = 'regular';
            $student->save();

            $session = Sessions::where('id', $request->session_id)->first();
            $last_two_digit = substr($session->session_name, -2);
            $six_digit_id = str_pad($student->id, 8, '0', STR_PAD_LEFT);
            $student_code = $last_two_digit.$six_digit_id;
                //update Profile Photo and Student Code
                Student::where('id', $student->id)
                    ->update([
                        'student_code' => $student_code
                        ]
                        );



            // Add into Current Academic Status
            $currentSessionClassSections = new CurrentAcadmicStatus();
            $currentSessionClassSections->student_id = $student->id;
            $currentSessionClassSections->session_id = $request->session_id ? $request->session_id: 0  ;
            $currentSessionClassSections->class_id = $request->class_id ? $request->class_id: ''  ;
            $currentSessionClassSections->section_id = $request->section_id ? $request->section_id: ''  ;
            $currentSessionClassSections->group_id = $request->group_id ? $request->group_id: ''  ;
            $currentSessionClassSections->roll_no = $request->roll_no ? $request->roll_no: ''  ;

            $currentSessionClassSections->save();



            /** Save Payment Info  */
            $studentFee = new StudentFee();
            $studentFee->entry_date = $request->entry_date ? $request->entry_date: '' ;
            $studentFee->student_id = $student->id ;
            $studentFee->session_id = $request->session_id ? $request->session_id: 0 ;
            $studentFee->class_id = $request->class_id ? $request->class_id: 0 ;
            $studentFee->monthly_fee_fields = $request->monthly_fee_fields ? $request->monthly_fee_fields: NULL ;


            $studentFee->others_fee_fields = 'Admission Form Fee' ;
            $studentFee->other_amount_total = $request->form_fee ? $request->form_fee: 0 ;
            $studentFee->amount = $request->form_fee ? $request->form_fee: 0 ;
            $studentFee->entry_date = $request->entry_date ? $request->entry_date: '' ;
            $studentFee->discount = $request->discount ? $request->discount: 0 ;
            $studentFee->note = $request->note ? $request->note: '' ;
            $studentFee->paid = $request->form_fee ? $request->form_fee: 0 ;
            $studentFee->payment_method = $request->payment_method ? $request->payment_method: 'cash' ;
            if($request->payment_method=='cheque'){
                $studentFee->bank_or_wallet_id = $request->bank_name ? $request->bank_name: '' ;
                $studentFee->acc_or_mobile_no = $request->cheque_no ? $request->cheque_no: '' ;
            }

            if($request->payment_method=='mobile_banking'){
                $studentFee->bank_or_wallet_id = $request->wallet_name ? $request->wallet_name: '' ;
                $studentFee->acc_or_mobile_no = $request->cheque_no ? $request->cheque_no: '' ;
            }

            if($request->discount>0){
                $studentFee->status = 'pending';
            }else{
                $studentFee->status = 'paid';
            }
            $studentFee->user_id = Auth::user()->id ;
            $studentFee->save();

            QrCode::generate($student_code, 'qrcodes/'.$student_code.'.svg');

            return response()->json([
                'receipt_id' => $studentFee->id,
                'student_id' => $studentFee->student_id
            ]);


        } catch (\Exception $th) {
            report($th);

            return response()->json([
                'message' => 'Something went wrong. ' . $th->getMessage()
            ], 500);
        }
    }



        /**
     * Show fee_types filter by class,section,group,session.
     *
     * @param  int  $id
     * @return \Illuminate\View\View
     */
    public function getStudentByCode(Request $request)
    {

        $data['found'] = FALSE;
        try {
            $user_id = Auth::user()->id;
            $studentDetails = Student::where('student_code', $request->student_code)->first();
            //dd($studentDetails);
            $student = CurrentAcadmicStatus::where('student_id', $studentDetails->id)
                ->join('students', 'students.id', '=', 'current_academic_status.student_id')
                ->with('session')
                ->with('class')
                ->with('group')
                ->select(
                    'students.*',
                    'current_academic_status.roll_no',
                    'current_academic_status.class_id',
                    'current_academic_status.section_id',
                    'current_academic_status.group_id',
                    'current_academic_status.session_id',
                )
                ->first();
            // dd($student);
            //Generate a timestamp using mt_rand.
            $timestamp = mt_rand(1, time());

            $monthListArr = StudentFee::MonthArray();

            $feeTypes = FeeTypes::where('status', FeeTypes::ACTIVE)->orderBy('name')->get();

            $all_divisions = Json::getAllDivision();
            $all_districts = Json::getAllDistrict();
            $all_postcodes = Json::getAllPostCodes();
            $all_upazilas = Json::getAllUpazilas();

            $data = [
                'student' => $student,
                'timestamp' => $timestamp,
                'classes' => Classes::all(),
                'sections' => Sections::all(),
                'groups' => Groups::all(),
                'sessions' => Sessions::orderBy('id', 'DESC')->get(),
                'feeTypes' => $feeTypes,
                'monthListArr' => $monthListArr,
                'all_divisions' => $all_divisions,
                'all_districts' => $all_districts,
                'all_postcodes' => $all_postcodes,
                'all_upazilas' => $all_upazilas,
            ];
        }catch (\Exception $th) {
            report($th);
            return 'Not Found.Please Enter a Valid ID.';
        }

        return view('admission_form.edit',$data);




    }


    /**
     * Update `student` data
     *
     * @param  \App\Http\Requests\Student\StoreRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateRequest $request)
    {

        try {
            $student_id = $request->id ? $request->id: NULL ;
            $roll_no = $request->roll_no ? $request->roll_no: NULL ;
            $name = $request->name ? $request->name: NULL ;
            $dob = $request->dob ? date('Y-m-d', strtotime($request->dob)) : NULL ;
            $birth_regi_no = $request->birth_regi_no ? $request->birth_regi_no : NULL ;
            $age = $request->age ? $request->age : NULL ;
            $occupation = $request->occupation ? $request->occupation : NULL ;
            $is_phyically_disabled = $request->is_phyically_disabled ? $request->is_phyically_disabled : NULL ;
            if($is_phyically_disabled){
                $phyically_disabled_type = $request->phyically_disabled_type ? $request->phyically_disabled_type : NULL ;
            }else{
                $phyically_disabled_type = NULL ;
            }

            $birthplace = $request->birthplace ? $request->birthplace: NULL ;
            $religion = $request->religion ? $request->religion: NULL ;
            $nationality = $request->nationality ? $request->nationality: NULL ;
            $marital_status = $request->marital_status ? $request->marital_status: 0 ;
            $blood_group = $request->blood_group ? $request->blood_group: NULL ;
            $gender = $request->gender ? $request->gender: NULL ;
            $is_siblings_study_here = $request->is_siblings_study_here ? $request->is_siblings_study_here : NULL ;

            if($is_siblings_study_here){
                $siblings_id_no = $request->siblings_id_no ? $request->siblings_id_no : NULL ;
            }else{
                $siblings_id_no = NULL ;
            }

            $arr_psc_info = array();
            $arr_psc_info['psc_passing_year'] = $request->psc_passing_year ? $request->psc_passing_year: NULL ;
            $arr_psc_info['psc_roll_no'] = $request->psc_roll_no ? $request->psc_roll_no: NULL ;
            $arr_psc_info['psc_id_no'] = $request->psc_id_no ? $request->psc_id_no: NULL ;
            $arr_psc_info['psc_gpa'] = $request->psc_gpa ? $request->psc_gpa: NULL ;
            $arr_psc_info['psc_scholarship'] = $request->psc_scholarship ? $request->psc_scholarship: NULL ;
            $arr_psc_info['psc_scholarship_id_no'] = $request->psc_scholarship_id_no ? $request->psc_scholarship_id_no: NULL ;

            $psc_info = json_encode($arr_psc_info);

            $arr_jsc_info = array();
            $arr_jsc_info['jsc_passing_year'] = $request->jsc_passing_year ? $request->jsc_passing_year: NULL ;
            $arr_jsc_info['jsc_roll_no'] = $request->jsc_roll_no ? $request->jsc_roll_no: NULL ;
            $arr_jsc_info['jsc_id_no'] = $request->jsc_id_no ? $request->jsc_id_no: NULL ;
            $arr_jsc_info['jsc_gpa'] = $request->jsc_gpa ? $request->jsc_gpa: NULL ;
            $arr_jsc_info['jsc_scholarship'] = $request->jsc_scholarship ? $request->jsc_scholarship: NULL ;
            $arr_jsc_info['jsc_scholarship_id_no'] = $request->jsc_scholarship_id_no ? $request->jsc_scholarship_id_no: NULL ;

            $jsc_info = json_encode($arr_jsc_info);

            if($request->psc_scholarship){
                $scholarship = $request->psc_scholarship;
            }else if($request->jsc_scholarship){
                $scholarship = $request->jsc_scholarship;
            }else{
                $scholarship = NULL;
            }
            $arr_current_address = array();
            $arr_current_address['village'] = $request->village ? $request->village: NULL ;
            $arr_current_address['post_code'] = $request->post_code ? $request->post_code: NULL ;
            $arr_current_address['upazila'] = $request->upazila ? $request->upazila: NULL ;
            $arr_current_address['district'] = $request->district ? $request->district: NULL ;

            $current_address = json_encode($arr_current_address);

            $arr_permanent_address = array();
            $arr_permanent_address['village'] = $request->village_permanent ? $request->village_permanent: NULL ;
            $arr_permanent_address['post_code'] = $request->post_code_permanent ? $request->post_code_permanent: NULL ;
            $arr_permanent_address['upazila'] = $request->upazila_permanent ? $request->upazila_permanent: NULL ;
            $arr_permanent_address['district'] = $request->district_permanent ? $request->district_permanent: NULL ;

            $permanent_address = json_encode($arr_permanent_address);
            $same_as_current = $request->same_as_current ? $request->same_as_current: NULL ;


            $ward_no = $request->ward_no ? $request->ward_no: NULL ;
            $moholla = $request->moholla ? $request->moholla: NULL ;
            $previous_school = $request->previous_school ? $request->previous_school: NULL ;

            $family_members = $request->family_members ? $request->family_members: NULL ;
            $monthly_income = $request->monthly_income ? $request->monthly_income: NULL ;
            $total_land_or_asset = $request->total_land_or_asset ? $request->total_land_or_asset: NULL ;

            $fathers_name = $request->fathers_name ? $request->fathers_name: NULL ;
            $fathers_phone = $request->fathers_phone ? $request->fathers_phone: NULL ;

            $mothers_name = $request->mothers_name ? $request->mothers_name: NULL ;
            $mothers_phone = $request->mothers_phone ? $request->mothers_phone: NULL ;

            $legal_guardians_name = $request->legal_guardians_name ? $request->legal_guardians_name: NULL ;
            $legal_guardians_phone = $request->legal_guardians_phone ? $request->legal_guardians_phone: NULL ;

            $voter_type = $request->voter_type ? $request->voter_type: NULL ;
            $status = 'regular';

            $session = Sessions::where('id', $request->session_id)->first();
            $last_two_digit = substr($session->session_name, -2);
            $six_digit_id = str_pad($student_id, 8, '0', STR_PAD_LEFT);
            $student_code = $last_two_digit.$six_digit_id;

            $data = [
                'student_code' => $student_code,
                'name' => $name,
                'dob' => $dob,
                'birth_regi_no' => $birth_regi_no,
                'birthplace' => $birthplace,
                'age' => $age,
                'occupation' => $occupation,
                'is_phyically_disabled' => $is_phyically_disabled,
                'phyically_disabled_type' => $phyically_disabled_type,
                'religion' => $religion,
                'nationality' => $nationality,
                'marital_status' => $marital_status,
                'blood_group' => $blood_group,
                'gender' => $gender,
                'is_siblings_study_here' => $is_siblings_study_here,
                'siblings_id_no' => $siblings_id_no,
                'is_siblings_study_here' => $is_siblings_study_here,
                'siblings_id_no' => $siblings_id_no,
                'current_address' => $current_address,
                'same_as_current' => $same_as_current,
                'permanent_address' => $permanent_address,
                'ward_no' => $ward_no,
                'moholla' => $moholla,
                'previous_school' => $previous_school,
                'psc_info' => $psc_info,
                'jsc_info' => $jsc_info,
                'scholarship' => $scholarship,
                'family_members' => $family_members,
                'monthly_income' => $monthly_income,
                'total_land_or_asset' => $total_land_or_asset,
                'fathers_name' => $fathers_name,
                'fathers_phone' => $fathers_phone,
                'mothers_name' => $mothers_name,
                'mothers_phone' => $mothers_phone,
                'legal_guardians_name' => $legal_guardians_name,
                'legal_guardians_phone' => $legal_guardians_phone,
                'voter_type' => $voter_type
            ];


            $file_name = '';

            if(!is_null($request->file('profile_photo'))){
                $profile_photo = $request->file('profile_photo') ;
                //Display File Extension
                $extension = $profile_photo->getClientOriginalExtension();
                $file_name = $student_id.".".$extension;
                //Move Uploaded File
                $destinationPath = 'uploads/students';
                $profile_photo->move($destinationPath,$file_name);
                $data['profile_photo'] = $file_name;
            }



            Student::where('id',$student_id)
                ->update($data);



            $data_current = array(
                'student_id' => $student_id ,
                'roll_no' => $roll_no,
                'session_id' => $request->session_id ? $request->session_id: '' ,
                'class_id' => $request->class_id ? $request->class_id: '' ,
                'section_id' => $request->section_id ? $request->section_id: '' ,
                'group_id' => $request->group_id ? $request->group_id: '' ,
            );

            CurrentAcadmicStatus::where('student_id', $student_id)
                ->update($data_current);

            $print_money_receipt = FALSE;
             /** Save Payment Info  */
             if($request->paid>0){
                $studentFee = new StudentFee();
                $studentFee->student_id = $student_id ;
                $studentFee->session_id = $request->session_id ? $request->session_id: 0 ;
                $studentFee->class_id = $request->class_id ? $request->class_id: 0 ;
                $studentFee->monthly_fee_fields = $request->monthly_fee_fields ? $request->monthly_fee_fields: NULL ;


                $studentFee->others_fee_fields = $request->others_fee_fields ? $request->others_fee_fields: NULL ;
                $studentFee->others_fee_details = $request->others_fee_details ? $request->others_fee_details: NULL ;
                $studentFee->monthly_fee_total = $request->monthly_fee_total ? $request->monthly_fee_total: 0 ;
                $studentFee->other_amount_total = $request->other_amount_total ? $request->other_amount_total: 0 ;
                $studentFee->amount = $request->amount ? $request->amount: 0 ;
                $studentFee->entry_date = $request->entry_date ? $request->entry_date: '' ;
                $studentFee->discount = $request->discount ? $request->discount: 0 ;
                $studentFee->note = $request->note ? $request->note: '' ;
                $studentFee->paid = $request->paid ? $request->paid: 0 ;
                $studentFee->payment_method = $request->payment_method ? $request->payment_method: 'cash' ;

                if($request->payment_method=='cheque'){
                    $studentFee->bank_or_wallet_id = $request->bank_name ? $request->bank_name: '' ;
                    $studentFee->acc_or_mobile_no = $request->cheque_no ? $request->cheque_no: '' ;
                }

                if($request->payment_method=='mobile_banking'){
                    $studentFee->bank_or_wallet_id = $request->wallet_name ? $request->wallet_name: '' ;
                    $studentFee->acc_or_mobile_no = $request->cheque_no ? $request->cheque_no: '' ;
                }

                if($request->discount>0){
                    $studentFee->status = 'pending';
                }else{
                    $studentFee->status = 'paid';
                }

                $studentFee->user_id = Auth::user()->id ;
                $studentFee->save();

                $print_money_receipt = TRUE;

            }


             if($print_money_receipt){
                return response()->json([
                    'student_id' => $student_id,
                    'receipt_id' => $studentFee->id,
                    'message' => 'Student  created successfully.',
                ]);
             }




        } catch (\Exception $th) {
            report($th);

            return response()->json([
                'message' => 'Something went wrong. ' . $th->getMessage()
            ], 500);
        }
    }



     /**
     * Handle datatable serverside
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function data(Request $request)
    {
        if ($request->ajax()) {
            $classId = $request->get('classId', 0);
            $sessionId = $request->get('sessionId', 0);
            $studentWithMarks = CurrentAcadmicStatus::with('student_details')
                                ->where('current_academic_status.class_id',$classId)
                                ->where('current_academic_status.session_id',$sessionId)

                                ->with('session')
                                ->with('class')
                                ->get();

        }
        if($classId==0 && $sessionId==0){
            $studentWithMarks = CurrentAcadmicStatus::with('student_details')
                                ->where('current_academic_status.roll_no','')
                                ->with('session')
                                ->with('class')
                                ->get();

        }

            $offset = $request->get('start', 0);
            $limit = $request->get('length', 10);
            if ($limit < 1 OR $limit > 100) {
                $limit = 100;
            }

            $search = isset($request->get('search')['value'])
                    ? $request->get('search')['value']
                    : null;

            $orderColumnList = [
                'roll_no',
                'id',
                 '',
                'name',
                'roll_name',
            ];

            $orderColumnIndex = isset($request->get('order')[0]['column'])
                                ? $request->get('order')[0]['column']
                                : 0;
            $orderColumnDir = isset($request->get('order')[0]['dir'])
                                ? $request->get('order')[0]['dir']
                                : 'desc';

            $orderColumn = isset($orderColumnList[$orderColumnIndex])
                            ? $orderColumnList[$orderColumnIndex]
                            : 'name';

            $otherReportParams = [
                'search' => $search,
                'limit' => $limit,
                'offset' => $offset,
                'order_column' => $orderColumn,
                'order_dir' => $orderColumnDir,
                'class_id' => $classId,
            ];



            $table = Datatables::of($studentWithMarks)


                        ->addColumn('name', function ($row) {

                            $name = isset($row->student_details->name) ? $row->student_details->name : '';
                            return $name;
                        })

                        ->addColumn('student_code', function ($row) {

                            $student_code = isset($row->student_details->student_code) ? $row->student_details->student_code : '';
                            return $student_code;
                        })

                        ->addColumn('class_name', function ($row) {
                            return $row->class->class_name;
                        })



                        ->addColumn('session_name', function ($row) {
                            return $row->session->session_name;
                         })

                        ->addColumn('action', function ($row) {

                            $student_id = isset($row->student_details->id) ? $row->student_details->id : '';

                            if(\App\Models\Role::checkRolePermissions('Can access action: Admission Form - Delete Admission Form')){
                                return '<div class="w-full text-center">
                                    <a style="display:none !important" href="'.route('admission_form.edit', [ 'id' => $student_id ]) .'" class="btn-action--yellow" title="'. __('translation.Edit') .'">
                                    <i class="fas fa-pencil-alt"></i>
                                    </a>

                                    <button type="button" class="btn-action--red" title="Delete" data-id="'.$student_id.'" id="BtnDeleteStudent">
                                        <i class="fas fa-trash-alt"></i>
                                    </button>
                                </div>';
                            }
                        })

                        ->rawColumns(['action'])
                        ->skipPaging()
                        ->make(true);

            return $table;

    }

    /**
     * Show fee_types filter by class,section,group,session.
     *
     * @param  int  $id
     * @return \Illuminate\View\View
     */
    public function getAdmissionMoneyReceipt(Request $request)
    {
        $student_id = $request->student_id;
        $receipt_id = $request->receipt_id;
        $studentFee = StudentFee::where('id',$receipt_id)->first();

        $student = Student::with('currentAcademicStatus')
        ->where('id',$student_id)->first();
        $feeTypes = FeeTypes::get();
        $monthListArr = StudentFee::MonthArray();
        $school_info = Settings::first();
        return view(
            'admission_form.get_money_receipt',
            compact(
                [
                'school_info',
                'student',
                'monthListArr',
                'feeTypes',
                'studentFee'
                ]
            )
        );
    }



    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function confirmAdmission()
    {
        Session::put('itemArray', []);

        $user_id = Auth::user()->id;

        //Generate a timestamp using mt_rand.
        $timestamp = mt_rand(1, time());

        $monthListArr = StudentFee::MonthArray();
        //dd($student);
        $feeTypes = FeeTypes::where('status',FeeTypes::ACTIVE)->orderBy('name')->get();

        $data = [
            'timestamp' => $timestamp,
            'classes' => Classes::all(),
            'sections' => Sections::all(),
            'groups' => Groups::all(),
            'sessions' => Sessions::orderBy('id', 'DESC')->get(),
            'feeTypes' => $feeTypes,
            'monthListArr' => $monthListArr,
        ];

        return view('admission_form.confirm', $data);
    }


    /**
     * This will return data into PO Edit Page >> Shipment Details Tab
     * Page URL : .... admission_form/{id}/edit
     * @return mixed
     */

    public function editAdmissionForm($id)
    {

        $user_id = Auth::user()->id;

        $student = CurrentAcadmicStatus::where('student_id', $id)
        ->join('students', 'students.id', '=', 'current_academic_status.student_id')
        ->with('session')
        ->with('class')
        ->with('group')
        ->orderBy('current_academic_status.id','desc')
        ->select(
            'students.*',
            'current_academic_status.roll_no as current_roll',
            'current_academic_status.class_id',
            'current_academic_status.section_id',
            'current_academic_status.group_id',
            'current_academic_status.session_id',
            )
        ->first();
        $classes = Classes::all();
        $sections = Sections::all();
        $groups = Groups::all();
        $sessions = Sessions::orderBy('id', 'DESC')->get();

        //Generate a timestamp using mt_rand.
        $timestamp = mt_rand(1, time());

        $monthListArr = StudentFee::MonthArray();

        $feeTypes = FeeTypes::where('status',FeeTypes::ACTIVE)->orderBy('name')->get();

        $data = [
            'timestamp' => $timestamp,
            'classes' => Classes::all(),
            'sections' => Sections::all(),
            'groups' => Groups::all(),
            'sessions' => Sessions::orderBy('id', 'DESC')->get(),
            'feeTypes' => $feeTypes,
            'monthListArr' => $monthListArr,
        ];

        return view(
            'admission_form.edit',
            compact(
                [
                'timestamp',
                'student',
                'classes',
                'sections',
                'groups',
                'sessions',
                'feeTypes',
                'monthListArr',

                ]
            )
    );
    }




    /**
     * Show fee_types on multiple.
     *
     * @param  int  $id
     * @return \Illuminate\View\View
     */
    public function addRemoveOthersFeeField(Request $request)
    {

        $checked = $request->checked;
        if($checked=='true'){
            $feeTypes = FeeTypes::orderBy('name')->get();
        }else{
            $feeTypes = FeeTypes::where('status',FeeTypes::ACTIVE)->orderBy('name')->get();
        }

        return view(
            'admission_form.add_remove_others_fee_field',
            compact(
                [
                'feeTypes',
                'checked'
                ]
            )
        );
    }


    /**
     * Set Status 1 OR 0 on fee_types table page.
     *
     * @param  int  $id
     * @return \Illuminate\View\View
     */
    public function statusChangeOthersFeeField(Request $request)
    {

        $status = $request->status;
        $feeTypes = FeeTypes::find($request->id);
        $feeTypes->status = $request->status;
        $feeTypes->save();
        return 'success';
    }




    public function admissionFilterOthersFeeExistanceChecking(Request $request)
    {

        $session_id = $request->session_id;
        $class_id = $request->class_id;
        $feeTypesAmount = FeeTypesAmount::where('class_id',$class_id)->where('session_id',$session_id)->get();
        $session = Sessions::where('id',$session_id)->first();
        if($feeTypesAmount->isEmpty()){
            return "Please Enter Others Fee Amount for Session ".$session->session_name;
        }
    }
    /**
     * Show fee_types filter by class,section,group,session.
     *
     * @param  int  $id
     * @return \Illuminate\View\View
     */
    public function admissionFilterOthersFee(Request $request)
    {
        $banks = Banks::get();
        $mobile_walets = MobileWalets::get();
        $session_id = $request->session_id;
        $class_id = $request->class_id;
        $section_id = $request->section_id;
        $group_id = $request->group_id;
        $roll_no = $request->roll_no;

        $student = Student::searchStudent($roll_no,$session_id,$class_id,$section_id,$group_id);
           // $feeTypes = FeeTypes::where('status',FeeTypes::ACTIVE)->orderBy('name')->get();
        if(empty($student)){
           // return "Sorry, Student not found with roll no ".$roll_no.", Please try again...";
        }

        $feeTypes = FeeTypes::with(['fee_types_amount' => function ($query)  use ($session_id){
            $query->where('session_id', $session_id);
        }])
        ->orderBy('name')->get();

       // $studeFeePaid = StudentFee::where('session_id',$session_id)
              //      ->where('class_id',$class_id)
                   // ->where('student_id',99999999999999999999)
                //    ->get();

        $arrPaidMonthlyFee = array();
        $arrPaidOthersFee = array();
        //foreach($studeFeePaid as $row){
          //  $arrPaidMonthlyFee[]= $row->monthly_fee_fields;
           // $arrPaidOthersFee[]= $row->others_fee_fields;
       // }
       // $arrPaidMonthlyFee = explode(',',(implode(",",$arrPaidMonthlyFee))) ;
        //$arrPaidOthersFee = explode('@',(implode("@",$arrPaidOthersFee))) ;



        $monthListArr = StudentFee::MonthArray();
        return view(
            'admission_form.filter_others_fee_field',
            compact(
                [
                'banks',
                'mobile_walets',
                'student',
                'monthListArr',
                'feeTypes',
                'class_id',
                'session_id',
                'arrPaidMonthlyFee',
                'arrPaidOthersFee'
                ]
            )
        );
    }


    /**
     * Show fee_types on multiple.
     *
     * @param  int  $id
     * @return \Illuminate\View\View
     */
    public function admissionAddRemoveOthersFeeField(Request $request)
    {

        $checked = $request->checked;
        if($checked=='true'){
            $feeTypes = FeeTypes::orderBy('name')->get();
        }else{
            $feeTypes = FeeTypes::where('status',FeeTypes::ACTIVE)->orderBy('name')->get();
        }

        return view(
            'admission_form.add_remove_others_fee_field',
            compact(
                [
                'feeTypes',
                'checked'
                ]
            )
        );
    }


    /**
     * Set Status 1 OR 0 on fee_types table page.
     *
     * @param  int  $id
     * @return \Illuminate\View\View
     */
    public function admissionStatusChangeOthersFeeField(Request $request)
    {

        $status = $request->status;
        $feeTypes = FeeTypes::find($request->id);
        $feeTypes->status = $request->status;
        $feeTypes->save();
        return 'success';
    }


    public function deleteStudent(DeleteRequest $request)
    {
            Student::where('id', $request->id)->delete();
            CurrentAcadmicStatus::where('student_id', $request->id)->delete();
            return [
                'status' => 1
            ];

    }




}
